/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLSocket;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.MessageWireFormat;
import net.jxta.impl.endpoint.MessageWireFormatBinary;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.JTlsRecord;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import net.jxta.impl.endpoint.tls.TlsConn;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class JTlsInputStream
extends InputStream {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$JTlsInputStream == null ? (class$net$jxta$impl$endpoint$tls$JTlsInputStream = JTlsInputStream.class$("net.jxta.impl.endpoint.tls.JTlsInputStream")) : class$net$jxta$impl$endpoint$tls$JTlsInputStream).getName());
    TlsConn conn;
    private boolean tlsInputDebug = false;
    private JTlsRecord jtrec = null;
    private MessageWireFormat wireIn = null;
    private int sequenceNumber = 0;
    private int mrrSequenceNumber = 0;
    private Vector inputElements = new Vector(10, 1);
    private InputStream plain_in = null;
    private InputStream netIn = null;
    private static int MAXQUEUESIZE = 25;
    Vector inputQueue = new Vector(MAXQUEUESIZE);
    private static final String ACKKEY = "ack=";
    private static final String SACKKEY = "sack=";
    private int holeStart = 0;
    private int holeEnd = 0;
    private static final byte[] ACKText = new byte[]{84, 76, 83, 65, 67, 75};
    private MessageElement currentElt = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$JTlsInputStream;

    public JTlsInputStream(TlsConn conn) {
        this.conn = conn;
        this.jtrec = new JTlsRecord();
        this.wireIn = new MessageWireFormatBinary(JTlsDefs.MTYPE);
        this.sequenceNumber = 0;
        this.mrrSequenceNumber = 0;
        this.plain_in = null;
    }

    int getSequenceNumber() {
        return this.sequenceNumber;
    }

    int getMaxIQSize() {
        return MAXQUEUESIZE;
    }

    public void setPlaintextInputStream(SSLSocket s) {
        this.plain_in = s.getInputStream();
    }

    public int readMessage(Message jmsg) {
        try {
            this.wireIn.readMessage(this.plain_in, jmsg);
        }
        catch (IOException iox) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("IOException in JTlsInputStream.readMessage:\n  " + iox.getMessage()));
            }
            return -1;
        }
        return 0;
    }

    private int rcvdACK(MessageElement elt) {
        String[] names = MessageElement.parseName(elt.getName());
        String namespace = names[0];
        String ackStr = names[1];
        int i = ackStr.indexOf(ACKKEY);
        if (i != -1) {
            Integer j = new Integer(ackStr.substring(i + 4));
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("ACK RCVD, SEQN = " + j));
            }
            return j;
        }
        return 0;
    }

    private void triggerRetransmission(int seqnum) {
        if (seqnum > this.mrrSequenceNumber + 1) {
            if (this.holeStart == this.mrrSequenceNumber && this.holeEnd + 1 == seqnum) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("TRIGGER ACK: Ignore duplicate hole [" + this.mrrSequenceNumber + ", " + seqnum + "]"));
                }
                this.holeEnd = seqnum;
                return;
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("TRIGGER ACK: Input hole [" + this.mrrSequenceNumber + ", " + seqnum + "]"));
            }
            String sackList = SACKKEY + this.mrrSequenceNumber + "," + seqnum;
            this.sendACK(this.mrrSequenceNumber, sackList);
            this.holeStart = this.mrrSequenceNumber;
            this.holeEnd = seqnum;
        }
    }

    private void sendACK(int oldSeqn) {
        int ackSeqn = this.mrrSequenceNumber;
        boolean nToAck = false;
        String selectedAckList = oldSeqn != 0 ? SACKKEY + oldSeqn + "," + ackSeqn : SACKKEY + ackSeqn;
        int j = 0;
        while (j < this.inputQueue.size()) {
            IQElt iQ = (IQElt)this.inputQueue.elementAt(j);
            selectedAckList = selectedAckList + "," + iQ.seqnum;
            if (iQ.seqnum == ackSeqn + 1) {
                ackSeqn = iQ.seqnum;
            }
            if (!iQ.ackd) {
                iQ.ackd = true;
                nToAck = true;
            }
            ++j;
        }
        this.sendACK(ackSeqn, selectedAckList);
    }

    private void sendACK(int seqnum, String sackList) {
        block4: {
            String names = "jxtatls:ack=" + seqnum;
            byte[] data = sackList == null ? ACKText : sackList.getBytes();
            MessageImpl ACKMsg = new MessageImpl();
            MessageElement elt = ACKMsg.newMessageElement(names, null, data, 0, data.length);
            ACKMsg.addElement(elt);
            try {
                this.conn.transport.sendToRemoteTls(this.conn.destAddr, ACKMsg);
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("SENT ACK, SEQN = " + seqnum));
                    if (sackList != null) {
                        LOG.info((Object)("    SACK, SEQN = " + sackList));
                    }
                }
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.INFO)) break block4;
                LOG.info((Object)"sendACK caught IOException:", (Throwable)e);
            }
        }
    }

    private MessageElement validateElement(IQElt iQ) {
        if (iQ.seqnum > this.sequenceNumber) {
            this.inputElements.add(iQ.elt);
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("validateElement: queue elt: seq# = " + iQ.seqnum + " expected = " + this.sequenceNumber));
            }
            this.triggerRetransmission(iQ.seqnum);
            return null;
        }
        if (iQ.seqnum < this.sequenceNumber) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("validateElement: duplicate, seq# = " + iQ.seqnum + " expected = " + this.sequenceNumber));
            }
            return null;
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("validateElement: elt in sequence = " + iQ.seqnum));
        }
        return iQ.elt;
    }

    private MessageElement getVectorElement() {
        int size = this.inputElements.size();
        int i = 0;
        while (i < size) {
            MessageElement elt = (MessageElement)this.inputElements.elementAt(i);
            int seqN = JTlsUtil.getSequenceNumber(elt);
            if (seqN == this.sequenceNumber) {
                this.inputElements.removeElementAt(i);
                return elt;
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void queueIncomingMessage(Message msg) {
        i = 0;
        ackSeqn = 0;
        msgSeqn = 0;
        e = ((MessageImpl)msg).getElementsInFifoOrder();
        elt = null;
        while (e.hasMoreElements()) {
            elt = (MessageElement)e.nextElement();
            ackSeqn = this.rcvdACK(elt);
            if (ackSeqn != 0) {
                data = elt.getBytesOffset();
                sackStr = new String(data);
                sackList = null;
                if (sackStr.indexOf("sack=") != -1) {
                    sackList = new String(data, "sack=".length(), data.length - "sack=".length());
                }
                if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO)) {
                    JTlsInputStream.LOG.info((Object)("SACKLIST = " + sackList));
                }
                this.conn.jout.ackReceived(ackSeqn, sackList);
                msg = null;
                this.notifyAll();
                return;
            }
            try {
                msgSeqn = JTlsUtil.getSequenceNumber(elt);
                if (msgSeqn == 0) continue;
                if (msgSeqn >= this.mrrSequenceNumber) break;
                if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO)) {
                    JTlsInputStream.LOG.info((Object)("RCVD DUPLICATE MSG: Discard seq# " + msgSeqn));
                }
                msgSeqn = -1;
                break;
            }
            catch (NumberFormatException n) {
                // empty catch block
            }
        }
        if (msgSeqn > 0) ** GOTO lbl46
        if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO) && msgSeqn == 0) {
            JTlsInputStream.LOG.info((Object)"TLS!! Received DUPLICATE or NON-TLS msg");
        }
        msg = null;
        this.notifyAll();
        return;
lbl-1000:
        // 1 sources

        {
            try {
                if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO) && i++ % 10 == 0) {
                    JTlsInputStream.LOG.info((Object)("NotifyAll(): enqueue WAIT, size = " + this.inputQueue.size()));
                }
                this.notifyAll();
                this.wait();
                continue;
            }
            catch (InterruptedException iex) {
                // empty catch block
            }
lbl46:
            // 3 sources

            ** while (this.inputQueue.size() >= JTlsInputStream.MAXQUEUESIZE)
        }
lbl47:
        // 1 sources

        if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO)) {
            JTlsInputStream.LOG.info((Object)"QUEUE incoming message:");
        }
        i = this.inputQueue.size();
        qIndex = -1;
        duplicate = false;
        j = 0;
        while (j < i) {
            iq = (IQElt)this.inputQueue.elementAt(j);
            if (msgSeqn < iq.seqnum) {
                qIndex = j;
                break;
            }
            if (msgSeqn == iq.seqnum) {
                duplicate = true;
                break;
            }
            ++j;
        }
        if (!duplicate && msgSeqn > this.mrrSequenceNumber) {
            iq = new IQElt();
            iq.seqnum = msgSeqn;
            iq.msg = msg;
            iq.elt = elt;
            iq.ackd = false;
            if (qIndex == -1) {
                qIndex = this.inputQueue.size();
            }
            this.inputQueue.add(qIndex, iq);
            if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO)) {
                JTlsInputStream.LOG.info((Object)("Enqueued msg with seq# " + msgSeqn + " At index " + qIndex));
            }
        } else {
            msg = null;
            if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO)) {
                JTlsInputStream.LOG.info((Object)("TLS!! Discarded duplicate msg, seq# = " + msgSeqn));
            }
        }
        this.notifyAll();
        if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO) && SSLDebug.getDebug((int)128)) {
            JTlsInputStream.LOG.info((Object)("NotifyAll(): N TLS Records queued = " + this.inputQueue.size()));
        }
    }

    private IQElt dequeueMessage() {
        IQElt iQ = null;
        int wct = 0;
        while (this.inputQueue.size() == 0) {
            try {
                ++wct;
                this.notifyAll();
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.inputQueue.size() > 0) {
            iQ = (IQElt)this.inputQueue.elementAt(0);
            this.inputQueue.removeElementAt(0);
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("DEQUEUED a TLS Record to process, seq# = " + iQ.seqnum));
                LOG.info((Object)("DEQUEUE waited " + wct + " times on empty input queue"));
            }
        }
        this.notifyAll();
        return iQ;
    }

    private synchronized int local_read(byte[] a, int offset, int length) throws IOException {
        int left;
        if (this.jtrec.size == 0 || this.jtrec.nextByte == this.jtrec.size) {
            this.jtrec.resetRecord();
            ++this.sequenceNumber;
            this.currentElt = this.getVectorElement();
            if (this.currentElt == null) {
                try {
                    while (this.currentElt == null) {
                        IQElt iQ = null;
                        iQ = this.dequeueMessage();
                        if (iQ == null) continue;
                        this.currentElt = this.validateElement(iQ);
                        JTlsUtil.removeElements(iQ.msg);
                    }
                }
                catch (Exception e) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("TLSInputStream exception: " + e));
                    }
                    return -1;
                }
            }
            this.mrrSequenceNumber = this.sequenceNumber;
            this.sendACK(0);
            this.jtrec.size = this.currentElt.getLength();
            if (this.tlsInputDebug && LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("local_read: seq#" + this.sequenceNumber + ", bytes = " + this.jtrec.size + "\n"));
            }
            this.jtrec.tlsRecord = this.currentElt.getBytesOffset();
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Rcvd TLS Record[" + this.jtrec.size + " bytes]" + " Seq# = " + this.sequenceNumber));
                if (this.sequenceNumber < 6) {
                    String hex = JTlsUtil.toHex(this.jtrec.tlsRecord, 0, this.jtrec.size);
                    LOG.info((Object)("HexDump:\n" + hex));
                }
            }
        }
        int copyLen = (left = this.jtrec.size - this.jtrec.nextByte) < length ? left : length;
        System.arraycopy(this.jtrec.tlsRecord, this.jtrec.nextByte, a, offset, copyLen);
        this.jtrec.nextByte += copyLen;
        if (this.tlsInputDebug && LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("\nRequested " + length + ", Read " + copyLen + " bytes"));
        }
        return copyLen;
    }

    public int read() throws IOException {
        byte[] a = new byte[1];
        int i = this.local_read(a, 0, 1);
        if (i != -1) {
            if (LOG.isEnabledFor(Priority.INFO) && SSLDebug.getDebug((int)128)) {
                LOG.info((Object)("Read() " + i));
            }
            i = a[0] & 0xFF;
        }
        return i;
    }

    public int read(byte[] a, int offset, int length) throws IOException {
        int i = this.local_read(a, offset, length);
        if (LOG.isEnabledFor(Priority.INFO) && SSLDebug.getDebug((int)128)) {
            LOG.info((Object)("Read(byte[], int, " + length + "), bytes read = " + i));
        }
        return i;
    }

    public int read(byte[] a) throws IOException {
        int i = this.local_read(a, 0, a.length);
        return i;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class IQElt {
        int seqnum;
        Message msg;
        MessageElement elt;
        boolean ackd;

        private IQElt() {
        }
    }
}

