/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.net.URL;
import net.jxta.id.ID;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.PeerGroupID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public final class PeerID
extends net.jxta.peer.PeerID {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$id$UUID$IDFormat == null ? (class$net$jxta$impl$id$UUID$IDFormat = PeerID.class$("net.jxta.impl.id.UUID.IDFormat")) : class$net$jxta$impl$id$UUID$IDFormat).getName());
    static final int groupIdOffset = 0;
    static final int idOffset = 16;
    static final int padOffset = 32;
    static final int padSize = 31;
    protected IDBytes id;
    static /* synthetic */ Class class$net$jxta$impl$id$UUID$IDFormat;

    private PeerID() {
        this.id = new IDBytes();
        this.id.bytes[63] = 3;
    }

    PeerID(IDBytes id) {
        this.id = id;
    }

    public PeerID(PeerGroupID groupID) {
        this();
        UUID groupUUID = new UUID(groupID.id.bytesIntoLong(0), groupID.id.bytesIntoLong(8));
        UUID idUUID = UUIDFactory.newUUID();
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, idUUID.getMostSignificantBits());
        this.id.longIntoBytes(24, idUUID.getLeastSignificantBits());
    }

    PeerID(UUID groupUUID, UUID peerUUID) {
        this();
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, peerUUID.getMostSignificantBits());
        this.id.longIntoBytes(24, peerUUID.getLeastSignificantBits());
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof String) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"string compared against id!");
            }
            return ((String)target).equalsIgnoreCase(this.toString());
        }
        if (target instanceof PeerID) {
            PeerID peerTarget = (PeerID)target;
            if (this.id == peerTarget.id) {
                return true;
            }
            boolean result = this.id.equals(peerTarget.id);
            if (result) {
                peerTarget.id = this.id;
            }
            return result;
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public URL getURL() {
        return IDFormat.getURL((String)this.getUniqueValue());
    }

    public ID getPeerGroupID() {
        UUID groupUUID = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        PeerGroupID groupID = new PeerGroupID(groupUUID);
        return IDFormat.translateToWellKnown(groupID);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

