/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership;

import java.util.Enumeration;
import java.util.Vector;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.service.Service;

public class NullMembershipService
extends MembershipService {
    private ModuleImplAdvertisement implAdvertisement = null;
    PeerGroup peergroup = null;
    Vector current = null;

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.peergroup = group;
        this.resign();
    }

    public Service getInterface() {
        return this;
    }

    public int startApp(String[] arg) {
        return 0;
    }

    public void stopApp() {
    }

    public PeerGroup getPeerGroup() {
        return this.peergroup;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public Authenticator apply(AuthenticationCredential application) throws PeerGroupException, ProtocolNotSupportedException {
        String method = application.getMethod();
        if (null != method && !"NullAuthentication".equals(method)) {
            throw new ProtocolNotSupportedException("Authentication method not recognized");
        }
        return new NullAuthenticator(this, application);
    }

    public synchronized Enumeration getCurrentCredentials() throws PeerGroupException {
        return this.current.elements();
    }

    public Enumeration getAuthCredentials() throws PeerGroupException {
        Vector none = new Vector();
        return none.elements();
    }

    public synchronized Credential join(Authenticator authenticated) throws PeerGroupException {
        if (!(authenticated instanceof NullAuthenticator)) {
            throw new ClassCastException("This is not my authenticator!");
        }
        if (!authenticated.isReadyForJoin()) {
            throw new PeerGroupException("Not Ready to join!");
        }
        NullCredential newCred = new NullCredential(this, ((NullAuthenticator)authenticated).getAuth1Identity());
        this.current.addElement(newCred);
        return newCred;
    }

    public synchronized void resign() throws PeerGroupException {
        this.current = new Vector();
        this.current.addElement(new NullCredential(this, "nobody"));
    }

    public Credential makeCredential(Element element) throws PeerGroupException, Exception {
        Object rootIs = element.getKey();
        Attribute type = ((Attributable)rootIs).getAttribute("type");
        if (!("jxta:Cred".equals(rootIs) && null != type && type.getValue().equals("jxta:NullCred") || "jxta:NullCred".equals(rootIs))) {
            throw new PeerGroupException("Element does not contain a recognized credential format");
        }
        Enumeration children = element.getChildren("PeerGroupID");
        if (!children.hasMoreElements()) {
            throw new RuntimeException("Missing PeerGroupID Element");
        }
        PeerGroupID peergroup = (PeerGroupID)IDFactory.fromURL(IDFactory.jxtaURL((String)((Element)children.nextElement()).getValue()));
        if (children.hasMoreElements()) {
            throw new RuntimeException("Extra PeerGroupID Elements");
        }
        children = element.getChildren("PeerID");
        if (!children.hasMoreElements()) {
            throw new RuntimeException("Missing PeerID Element");
        }
        PeerID peer = (PeerID)IDFactory.fromURL(IDFactory.jxtaURL((String)((Element)children.nextElement()).getValue()));
        if (children.hasMoreElements()) {
            throw new RuntimeException("Extra PeerID Elements");
        }
        children = element.getChildren("Identity");
        if (!children.hasMoreElements()) {
            throw new RuntimeException("Missing Identity Element");
        }
        String whoami = (String)((Element)children.nextElement()).getValue();
        if (children.hasMoreElements()) {
            throw new RuntimeException("Extra Identity Elements");
        }
        return new NullCredential(this, peergroup, peer, whoami);
    }

    public class NullAuthenticator
    implements Authenticator {
        MembershipService source;
        AuthenticationCredential application;
        String whoami = "nobody";

        NullAuthenticator(MembershipService source, AuthenticationCredential application) {
            this.source = source;
            this.application = application;
        }

        public MembershipService getSourceService() {
            return this.source;
        }

        public synchronized boolean isReadyForJoin() {
            return true;
        }

        public String getMethodName() {
            return "NullAuthentication";
        }

        public AuthenticationCredential getAuthenticationCredential() {
            return this.application;
        }

        public void setAuth1Identity(String who) {
            this.whoami = who;
        }

        public String getAuth1Identity() {
            return this.whoami;
        }
    }

    class NullCredential
    implements Credential {
        NullMembershipService source;
        String whoami;
        ID peerid;

        protected NullCredential(NullMembershipService source, String whoami) {
            this.source = source;
            this.whoami = whoami;
            this.peerid = source.getPeerGroup().getPeerID();
        }

        protected NullCredential(NullMembershipService source, PeerGroupID peergroup, PeerID peer, String whoami) throws PeerGroupException {
            this.source = source;
            if (!source.getPeerGroup().getPeerGroupID().equals(peergroup)) {
                throw new PeerGroupException("Cannot credential for a different peer group.");
            }
            this.whoami = whoami;
            this.peerid = peer;
        }

        public MembershipService getSourceService() {
            return this.source;
        }

        public ID getPeerGroupID() {
            return this.source.getPeerGroup().getPeerGroupID();
        }

        public ID getPeerID() {
            return this.peerid;
        }

        public StructuredDocument getDocument(MimeMediaType as) throws Exception {
            StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(as, "jxta:Cred");
            ((Attributable)((Object)doc)).addAttribute("type", "jxta:NullCred");
            Element e = doc.createElement("PeerGroupID", NullMembershipService.this.peergroup.getPeerGroupID().toString());
            doc.appendChild(e);
            e = doc.createElement("PeerID", this.peerid.toString());
            doc.appendChild(e);
            e = doc.createElement("Identity", this.whoami);
            doc.appendChild(e);
            return doc;
        }

        public String getIdentity() {
            return this.whoami;
        }
    }
}

