/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.exception.ViolationException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.loader.RefJxtaLoader;
import net.jxta.impl.peergroup.PeerGroupInterface;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.protocol.PeerGroupAdv;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeService;
import net.jxta.platform.JxtaLoader;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public abstract class GenericPeerGroup
implements RefPeerGroup {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$peergroup$GenericPeerGroup == null ? (class$net$jxta$impl$peergroup$GenericPeerGroup = GenericPeerGroup.class$("net.jxta.impl.peergroup.GenericPeerGroup")) : class$net$jxta$impl$peergroup$GenericPeerGroup).getName());
    private EndpointService endpoint;
    private ResolverService resolver;
    private DiscoveryService discovery;
    private PipeService pipe;
    private MembershipService membership;
    private RendezVousService rendezvous;
    private PeerInfoService peerinfo;
    private static JxtaLoader loader = new RefJxtaLoader("./Downloaded");
    private PeerAdvertisement peerAdvertisement = null;
    private PeerGroupAdvertisement peerGroupAdvertisement = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private PeerAdvertisement configAdvertisement = null;
    private RefPeerGroup parentGroup = null;
    private Hashtable services = new Hashtable();
    private boolean stopping = false;
    private boolean published = false;
    private int masterRefCount = 0;
    static /* synthetic */ Class class$net$jxta$impl$peergroup$GenericPeerGroup;
    static /* synthetic */ Class class$net$jxta$protocol$ModuleImplAdvertisement;
    static /* synthetic */ Class class$net$jxta$protocol$PeerGroupAdvertisement;

    public static JxtaLoader getJxtaLoader() {
        return loader;
    }

    public static void setJxtaLoader(JxtaLoader newLoader) {
        loader = newLoader;
    }

    private Enumeration discoverSome(int type, String attr, String value, int seconds, Class thisClass) {
        return this.discoverSome(this.discovery, type, attr, value, seconds, thisClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Enumeration discoverSome(DiscoveryService discovery, int type, String attr, String value, int seconds, Class thisClass) {
        Vector<Advertisement> results = new Vector<Advertisement>();
        try {
            int count = 0;
            do {
                Enumeration res = discovery.getLocalAdvertisements(type, attr, value);
                while (res.hasMoreElements()) {
                    Advertisement a = (Advertisement)res.nextElement();
                    if (!thisClass.isInstance(a)) continue;
                    results.add(a);
                }
                if (results.size() > 0) return results.elements();
                if (count % 30 == 0) {
                    discovery.getRemoteAdvertisements(null, type, attr, value, 20);
                }
                Thread.sleep(1000L);
            } while (count++ < seconds);
            return results.elements();
        }
        catch (Exception whatever) {
            whatever.printStackTrace();
        }
        return results.elements();
    }

    private Advertisement discoverOne(int type, String attr, String value, int seconds, Class thisClass) {
        Enumeration res = this.discoverSome(type, attr, value, seconds, thisClass);
        if (!res.hasMoreElements()) {
            return null;
        }
        return (Advertisement)res.nextElement();
    }

    private void setShortCut(ID name, Service service) {
        if (PeerGroup.endpointClassID.equals(name)) {
            this.endpoint = (EndpointService)service;
            return;
        }
        if (PeerGroup.resolverClassID.equals(name)) {
            this.resolver = (ResolverService)service;
            return;
        }
        if (PeerGroup.discoveryClassID.equals(name)) {
            this.discovery = (DiscoveryService)service;
            return;
        }
        if (PeerGroup.pipeClassID.equals(name)) {
            this.pipe = (PipeService)service;
            return;
        }
        if (PeerGroup.membershipClassID.equals(name)) {
            this.membership = (MembershipService)service;
            return;
        }
        if (PeerGroup.peerinfoClassID.equals(name)) {
            this.peerinfo = (PeerInfoService)service;
            return;
        }
        if (PeerGroup.rendezvousClassID.equals(name)) {
            this.rendezvous = (RendezVousService)service;
            return;
        }
    }

    private void clearShortCut(ModuleClassID name) {
        if (PeerGroup.endpointClassID.equals(name)) {
            this.endpoint = null;
            return;
        }
        if (PeerGroup.resolverClassID.equals(name)) {
            this.resolver = null;
            return;
        }
        if (PeerGroup.discoveryClassID.equals(name)) {
            this.discovery = null;
            return;
        }
        if (PeerGroup.pipeClassID.equals(name)) {
            this.pipe = null;
            return;
        }
        if (PeerGroup.membershipClassID.equals(name)) {
            this.membership = null;
            return;
        }
        if (PeerGroup.peerinfoClassID.equals(name)) {
            this.peerinfo = null;
            return;
        }
        if (PeerGroup.rendezvousClassID.equals(name)) {
            this.rendezvous = null;
            return;
        }
    }

    private synchronized Service addServiceSync(ID name, Service service) {
        if (this.stopping) {
            return null;
        }
        Service p = (Service)this.services.remove(name);
        this.services.put(name, service);
        return p;
    }

    protected void addService(ID name, Service service) {
        Service oldp = this.addServiceSync(name, service);
        this.setShortCut(name, service);
    }

    public synchronized Service lookupService(ID name) throws ServiceNotFoundException {
        Service p = (Service)this.services.get(name);
        if (p == null) {
            throw new ServiceNotFoundException(name.toString());
        }
        return p.getInterface();
    }

    protected void checkServices() throws ServiceNotFoundException {
        Service ignored = this.lookupService(PeerGroup.endpointClassID);
        ignored = this.lookupService(PeerGroup.resolverClassID);
        ignored = this.lookupService(PeerGroup.discoveryClassID);
        ignored = this.lookupService(PeerGroup.pipeClassID);
        ignored = this.lookupService(PeerGroup.rendezvousClassID);
        ignored = this.lookupService(PeerGroup.membershipClassID);
        Service service = this.lookupService(PeerGroup.peerinfoClassID);
    }

    private synchronized void removeAllServicesSync() {
        this.stopping = true;
        Hashtable myTable = this.services;
        this.services = new Hashtable();
        Enumeration allServices = myTable.elements();
        while (allServices.hasMoreElements()) {
            Service s = (Service)allServices.nextElement();
            s.stopApp();
        }
    }

    private synchronized void removeServiceSync(ModuleClassID name, Service service) throws ServiceNotFoundException, ViolationException {
        Service p = (Service)this.services.get(name);
        if (p == null) {
            throw new ServiceNotFoundException(name.toString());
        }
        if (p != service) {
            throw new ViolationException(name.toString());
        }
        this.services.remove(name);
    }

    protected void removeService(ModuleClassID name, Service service) throws ServiceNotFoundException, ViolationException {
        this.removeServiceSync(name, service);
        this.clearShortCut(name);
    }

    public abstract boolean compatible(Element var1);

    public Module loadModule(ID assigned, Advertisement impl) throws ProtocolNotSupportedException, PeerGroupException {
        return this.loadModule(assigned, impl, false);
    }

    protected Module loadModule(ID assigned, Advertisement impl, boolean privileged) throws ProtocolNotSupportedException, PeerGroupException {
        Module newMod;
        ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)impl;
        StructuredDocument compat = implAdv.getCompat();
        if (!this.compatible(compat)) {
            throw new ProtocolNotSupportedException("Incompatible Module");
        }
        try {
            newMod = (Module)loader.loadClass(implAdv.getCode(), implAdv.getUri(), true).newInstance();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PeerGroupException("Loader can't load class " + implAdv.getCode() + " from " + implAdv.getUri());
        }
        newMod.init(privileged ? this : (PeerGroup)this.getInterface(), assigned, implAdv);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Loaded. class : " + implAdv.getCode()));
        }
        try {
            if (this.discovery != null) {
                this.discovery.publish(impl, 2, 1471228928L, 1209600000L);
            }
        }
        catch (Exception notCritical) {
            // empty catch block
        }
        return newMod;
    }

    public Module loadModule(ID assigned, ModuleSpecID specID, int where) {
        return this.loadModule(assigned, specID, where, false);
    }

    protected Module loadModule(ID assigned, ModuleSpecID specID, int where, boolean privileged) {
        Advertisement found;
        Enumeration all;
        boolean fromParent;
        boolean here = where == 0 || where == 2;
        boolean bl = fromParent = where == 1 || where == 2;
        if (here && this.discovery != null) {
            all = this.discoverSome(2, "MSID", specID.toString(), 120, class$net$jxta$protocol$ModuleImplAdvertisement == null ? (class$net$jxta$protocol$ModuleImplAdvertisement = GenericPeerGroup.class$("net.jxta.protocol.ModuleImplAdvertisement")) : class$net$jxta$protocol$ModuleImplAdvertisement);
            while (all.hasMoreElements()) {
                try {
                    found = (Advertisement)all.nextElement();
                    if (!((ModuleImplAdvertisement)found).getModuleSpecID().equals(specID)) continue;
                    Module newMod = this.loadModule(assigned, found, privileged);
                    return newMod;
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.INFO)) continue;
                    LOG.info((Object)"Not a valid impl adv: ", (Throwable)e);
                }
            }
        }
        if (fromParent) {
            if (this.parentGroup == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Loading module from SpecID without discovery is not yet supported.");
                }
                return null;
            }
            all = this.discoverSome(this.parentGroup.getDiscoveryService(), 2, "MSID", specID.toString(), 120, class$net$jxta$protocol$ModuleImplAdvertisement == null ? (class$net$jxta$protocol$ModuleImplAdvertisement = GenericPeerGroup.class$("net.jxta.protocol.ModuleImplAdvertisement")) : class$net$jxta$protocol$ModuleImplAdvertisement);
            while (all.hasMoreElements()) {
                try {
                    found = (Advertisement)all.nextElement();
                    if (!((ModuleImplAdvertisement)found).getModuleSpecID().equals(specID)) continue;
                    Module newMod = this.loadModule(assigned, found, privileged);
                    try {
                        this.parentGroup.getDiscoveryService().publish(found, 2, 1471228928L, 1209600000L);
                    }
                    catch (Exception notCritical) {
                        // empty catch block
                    }
                    return newMod;
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.WARN)) continue;
                    LOG.warn((Object)"Bad impl adv: ", (Throwable)e);
                }
            }
        }
        return null;
    }

    public RefPeerGroup getParentGroup() {
        return this.parentGroup;
    }

    public Advertisement getConfigAdvertisement() {
        if (this.configAdvertisement == null) {
            return null;
        }
        return (Advertisement)this.configAdvertisement.clone();
    }

    protected void setConfigAdvertisement(Advertisement config) {
        this.configAdvertisement = (PeerAdvertisement)config;
    }

    public void init(PeerGroup homeGroup, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.parentGroup = (RefPeerGroup)homeGroup;
        this.peerAdvertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(PeerAdvertisement.getAdvertisementType());
        if (this.configAdvertisement != null) {
            this.peerAdvertisement.putServiceParam(PeerGroup.peerGroupClassID, this.configAdvertisement.getServiceParam(PeerGroup.peerGroupClassID));
            this.peerAdvertisement.setPeerID(this.configAdvertisement.getPeerID());
            this.peerAdvertisement.setName(this.configAdvertisement.getName());
        }
        try {
            String sGID;
            PeerGroupID myGID;
            if (assignedID == null || assignedID.equals(ID.nullID)) {
                myGID = IDFactory.newPeerGroupID();
                sGID = myGID.toString();
            } else {
                sGID = assignedID.toString();
                myGID = (PeerGroupID)IDFactory.fromURL(IDFactory.jxtaURL(sGID));
            }
            this.peerAdvertisement.setPeerGroupID(myGID);
            if (homeGroup == null) {
                if (this.peerAdvertisement.getPeerID() == null || this.peerAdvertisement.getPeerID().equals(ID.nullID)) {
                    this.peerAdvertisement.setPeerID(IDFactory.newPeerID(myGID));
                }
                if (this.peerAdvertisement.getName() == null) {
                    this.peerAdvertisement.setName("Anonymous Coward");
                }
            } else {
                DiscoveryService disco;
                Enumeration found;
                this.peerAdvertisement.setPeerID(homeGroup.getPeerID());
                this.peerAdvertisement.setName(homeGroup.getPeerName());
                if (assignedID != null && !assignedID.equals(ID.nullID) && (found = (disco = this.parentGroup.getDiscoveryService()).getLocalAdvertisements(1, "GID", sGID)).hasMoreElements()) {
                    this.peerGroupAdvertisement = (PeerGroupAdvertisement)found.nextElement();
                }
            }
            if (this.peerGroupAdvertisement == null) {
                this.peerGroupAdvertisement = new PeerGroupAdv();
                this.peerGroupAdvertisement.setName("Anonymous Group");
                this.peerGroupAdvertisement.setDescription("Nondescript Group");
                this.peerGroupAdvertisement.setPeerGroupID(myGID);
                this.peerGroupAdvertisement.setModuleSpecID(this.implAdvertisement.getModuleSpecID());
            } else {
                this.published = true;
            }
            if (!PeerGroup.globalRegistry.registerInstance(myGID, this)) {
                throw new PeerGroupException("Group already instantiated");
            }
        }
        catch (Exception any) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Group init failed.", (Throwable)any);
            }
            throw new PeerGroupException(any.getMessage());
        }
    }

    public int startApp(String[] arg) {
        return 0;
    }

    public void stopApp() {
        PeerGroup.globalRegistry.unRegisterInstance(this.peerGroupAdvertisement.getPeerGroupID(), this);
        this.removeAllServicesSync();
        if (this.parentGroup != null) {
            this.parentGroup.unref();
        }
    }

    public void unref() {
    }

    protected void decRefCount() {
        GenericPeerGroup genericPeerGroup = this;
        synchronized (genericPeerGroup) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("GROUP " + this.getPeerGroupID().toString() + " REF COUNT DECREMENTED TO: " + (this.masterRefCount - 1)));
            }
            if (--this.masterRefCount != 0) {
                return;
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("STOPPING UNREFERENCED GROUP " + this.getPeerGroupID().toString()));
        }
        this.stopApp();
    }

    public Service getInterface() {
        GenericPeerGroup genericPeerGroup = this;
        synchronized (genericPeerGroup) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("GROUP " + this.getPeerGroupID().toString() + " REF COUNT INCREMENTED TO: " + (this.masterRefCount + 1)));
            }
            ++this.masterRefCount;
        }
        return new PeerGroupInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return (Advertisement)this.implAdvertisement.clone();
    }

    public void publishGroup(String name, String description) throws IOException {
        if (this.published) {
            return;
        }
        this.peerGroupAdvertisement.setName(name);
        this.peerGroupAdvertisement.setDescription(description);
        if (this.parentGroup == null) {
            return;
        }
        this.parentGroup.getDiscoveryService().publish(this.peerGroupAdvertisement, 1, 1471228928L, 1209600000L);
        this.published = true;
    }

    public PeerGroup newGroup(Advertisement pgAdv) throws PeerGroupException {
        PeerGroup theNewGroup;
        block4: {
            PeerGroupAdvertisement adv = (PeerGroupAdvertisement)pgAdv;
            PeerGroupID gid = adv.getPeerGroupID();
            theNewGroup = PeerGroup.globalRegistry.lookupInstance(gid);
            if (theNewGroup != null) {
                return theNewGroup;
            }
            theNewGroup = (PeerGroup)this.loadModule(adv.getPeerGroupID(), adv.getModuleSpecID(), 0, false);
            if (theNewGroup == null) {
                throw new PeerGroupException("Could not find all implementations.");
            }
            try {
                theNewGroup.publishGroup(adv.getName(), adv.getDescription());
            }
            catch (Exception any) {
                if (!LOG.isEnabledFor(Priority.INFO)) break block4;
                LOG.info((Object)("Could not publish the group advertisement: " + any.getMessage()));
            }
        }
        return (PeerGroup)theNewGroup.getInterface();
    }

    public PeerGroup newGroup(PeerGroupID gid, Advertisement impl, String name, String description) throws PeerGroupException {
        PeerGroup theNewGroup;
        block5: {
            theNewGroup = PeerGroup.globalRegistry.lookupInstance(gid);
            if (theNewGroup != null) {
                return theNewGroup;
            }
            try {
                theNewGroup = (PeerGroup)this.loadModule((ID)gid, impl, false);
            }
            catch (Exception any) {
                throw new PeerGroupException(any.getMessage());
            }
            try {
                theNewGroup.publishGroup(name, description);
            }
            catch (Exception any) {
                if (!LOG.isEnabledFor(Priority.INFO)) break block5;
                LOG.info((Object)("Could not publish group or implementation:" + any.toString()));
            }
        }
        return (PeerGroup)theNewGroup.getInterface();
    }

    public PeerGroup newGroup(PeerGroupID gid) throws PeerGroupException {
        PeerGroupAdvertisement adv;
        PeerGroup result = PeerGroup.globalRegistry.lookupInstance(gid);
        if (result != null) {
            return result;
        }
        try {
            adv = (PeerGroupAdvertisement)this.discoverOne(1, "GID", gid.toString(), 120, class$net$jxta$protocol$PeerGroupAdvertisement == null ? (class$net$jxta$protocol$PeerGroupAdvertisement = GenericPeerGroup.class$("net.jxta.protocol.PeerGroupAdvertisement")) : class$net$jxta$protocol$PeerGroupAdvertisement);
        }
        catch (Exception any) {
            throw new PeerGroupException(any.getMessage());
        }
        if (adv == null) {
            throw new PeerGroupException("Could not find group advertisement");
        }
        result = (PeerGroup)this.loadModule(gid, adv.getModuleSpecID(), 0, false);
        try {
            result.publishGroup(adv.getName(), adv.getDescription());
        }
        catch (Exception notCritical) {
            // empty catch block
        }
        if (result == null) {
            throw new PeerGroupException("Could not find all implementations.");
        }
        return (PeerGroup)result.getInterface();
    }

    public JxtaLoader getLoader() {
        return loader;
    }

    public String getPeerName() {
        return this.peerAdvertisement.getName();
    }

    public String getPeerGroupName() {
        return this.peerGroupAdvertisement.getName();
    }

    public PeerGroupID getPeerGroupID() {
        return this.peerGroupAdvertisement.getPeerGroupID();
    }

    public PeerID getPeerID() {
        return this.peerAdvertisement.getPeerID();
    }

    public PeerAdvertisement getPeerAdvertisement() {
        return this.peerAdvertisement;
    }

    public PeerGroupAdvertisement getPeerGroupAdvertisement() {
        return this.peerGroupAdvertisement;
    }

    public boolean isRendezvous() {
        return this.rendezvous != null && this.rendezvous.isRendezVous();
    }

    public EndpointService getEndpointService() {
        return this.endpoint;
    }

    public ResolverService getResolverService() {
        return this.resolver;
    }

    public DiscoveryService getDiscoveryService() {
        return this.discovery;
    }

    public PeerInfoService getPeerInfoService() {
        return this.peerinfo;
    }

    public MembershipService getMembershipService() {
        return this.membership;
    }

    public PipeService getPipeService() {
        return this.pipe;
    }

    public RendezVousService getRendezVousService() {
        return this.rendezvous;
    }

    public abstract ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() throws Exception;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

