/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class NonBlockingOutputPipe
implements OutputPipe {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$pipe$NonBlockingOutputPipe == null ? (class$net$jxta$impl$pipe$NonBlockingOutputPipe = NonBlockingOutputPipe.class$("net.jxta.impl.pipe.NonBlockingOutputPipe")) : class$net$jxta$impl$pipe$NonBlockingOutputPipe).getName());
    private String pipeId = null;
    private PeerGroup myGroup = null;
    private EndpointService endpoint = null;
    private PipeResolver myPipeResolver = null;
    private EndpointAddress destAddress = null;
    private EndpointMessenger destMessenger = null;
    private String peer = null;
    private static final long RetryDelay = 5000L;
    private boolean closed = false;
    private PipeAdvertisement pAdv = null;
    static /* synthetic */ Class class$net$jxta$impl$pipe$NonBlockingOutputPipe;

    private EndpointAddress mkAddress(String destPeer, String pipeId) {
        try {
            PeerID asID = (PeerID)IDFactory.fromURL(IDFactory.jxtaURL(destPeer));
            String asString = "jxta://" + asID.getUniqueValue().toString();
            EndpointAddress addr = this.endpoint.newEndpointAddress(asString);
            addr.setServiceName("PipeService");
            addr.setServiceParameter(pipeId);
            return addr;
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)("invalid PeerID string: " + destPeer));
            }
            return null;
        }
    }

    public NonBlockingOutputPipe(PeerGroup g, PipeResolver r, PipeAdvertisement pAdv, String destPeer, long timeout) throws IOException {
        this.myGroup = g;
        this.endpoint = g.getEndpointService();
        this.pAdv = pAdv;
        ID opId = pAdv.getPipeID();
        this.pipeId = opId.toString();
        this.myPipeResolver = r;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Constructor for " + opId));
        }
        this.peer = null;
        if (destPeer == null) {
            this.peer = this.myPipeResolver.find(pAdv, timeout, false);
            if (this.peer == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("NonBlockingOutputPipe: unable to resolve InputPipe " + opId + " within " + timeout + " milli seconds"));
                }
                throw new IOException("NonBlockingOutputPipe: unable to resolve InputPipe " + opId + " within " + timeout + " milli seconds");
            }
        } else {
            this.peer = destPeer;
        }
        this.myPipeResolver.sendVerify(this.peer, this.pipeId, "JxtaUnicast");
        this.destMessenger = this.endpoint.getMessenger(this.mkAddress(this.peer, this.pipeId));
        if (this.destMessenger == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("NonBlockingOutputPipe: unable to create EndpointService Messenger for " + opId));
            }
            throw new IOException("NonBlockingOutputPipe: unable to create EndpointService Messenger for " + opId);
        }
    }

    protected NonBlockingOutputPipe(PeerGroup g, PipeResolver r, PipeAdvertisement pAdv, String destPeer) throws IOException {
        this.myGroup = g;
        this.pAdv = pAdv;
        this.endpoint = g.getEndpointService();
        ID opId = pAdv.getPipeID();
        this.pipeId = opId.toString();
        this.peer = destPeer;
        this.myPipeResolver = r;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Constructor for " + opId));
        }
        this.destMessenger = this.endpoint.getMessenger(this.mkAddress(destPeer, this.pipeId));
        if (this.destMessenger == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Constructor: no EndpointService Messenger for " + opId));
            }
            throw new IOException("Constructor: no EndpointService Messenger for " + opId);
        }
    }

    public void send(Message msg) throws IOException {
        String cachedPeer;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"send");
        }
        if ((cachedPeer = this.myPipeResolver.findLocal(this.pipeId)) == null) {
            cachedPeer = this.myPipeResolver.find(this.pAdv, 5000L, true);
            if (this.peer == null) {
                throw new IOException("null dest peer");
            }
        }
        if (!cachedPeer.equals(this.peer)) {
            this.peer = cachedPeer;
            this.destMessenger.close();
            this.destMessenger = this.endpoint.getMessenger(this.mkAddress(this.peer, this.pipeId));
            if (this.destMessenger == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("sendMessage: no EndpointService Messenger for " + this.pipeId));
                }
                throw new IOException("sendMessage: no EndpointService Messenger for " + this.pipeId);
            }
        }
        this.destMessenger.sendMessage(msg);
    }

    public synchronized void close() {
        this.destMessenger.close();
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

