/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.EndpointReceiveQueue;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class SecureInputPipeImpl
implements InputPipe,
EndpointListener {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$pipe$SecureInputPipeImpl == null ? (class$net$jxta$impl$pipe$SecureInputPipeImpl = SecureInputPipeImpl.class$("net.jxta.impl.pipe.SecureInputPipeImpl")) : class$net$jxta$impl$pipe$SecureInputPipeImpl).getName());
    private EndpointReceiveQueue queue;
    private String pipeId;
    private RefPeerGroup myGroup;
    private PipeResolver myPipeResolver;
    private boolean closed;
    private boolean lflag;
    PipeMsgListener listener;
    private PipeID pID;
    static /* synthetic */ Class class$net$jxta$impl$pipe$SecureInputPipeImpl;

    public SecureInputPipeImpl(PeerGroup g, PipeResolver r, PipeID ipId) {
        block4: {
            this.queue = null;
            this.pipeId = null;
            this.myGroup = null;
            this.myPipeResolver = null;
            this.closed = false;
            this.lflag = false;
            this.listener = null;
            this.pID = null;
            this.pID = ipId;
            this.myGroup = (RefPeerGroup)g;
            this.pipeId = ipId.toString();
            this.myPipeResolver = r;
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Constructor:");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("    pipeId = " + ipId));
            }
            this.queue = new EndpointReceiveQueue();
            try {
                this.myGroup.getEndpointService().addListener("PipeService" + ipId, this);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block4;
                LOG.debug((Object)("Constructor failed with " + e));
            }
        }
        this.myPipeResolver.register(this.pipeId, this);
    }

    public SecureInputPipeImpl(PeerGroup g, PipeResolver r, PipeID ipId, PipeMsgListener listener) {
        block5: {
            this.queue = null;
            this.pipeId = null;
            this.myGroup = null;
            this.myPipeResolver = null;
            this.closed = false;
            this.lflag = false;
            this.listener = null;
            this.pID = null;
            this.pID = ipId;
            this.lflag = true;
            this.listener = listener;
            this.myGroup = (RefPeerGroup)g;
            this.pipeId = ipId.toString();
            this.myPipeResolver = r;
            if (LOG.isDebugEnabled()) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Constructor:");
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("    pipeId = " + ipId));
                }
            }
            try {
                this.myGroup.getEndpointService().addListener("PipeService" + ipId, this);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block5;
                LOG.debug((Object)("Constructor failed with " + e));
            }
        }
        this.myPipeResolver.register(this.pipeId, this);
    }

    public Message waitForMessage() throws InterruptedException {
        if (!this.lflag) {
            return this.queue.waitForMessage();
        }
        return null;
    }

    public Message poll(int timeout) throws InterruptedException {
        if (!this.lflag) {
            return this.queue.poll(timeout);
        }
        return null;
    }

    public synchronized void close() {
        boolean res = this.myGroup.getEndpointService().removeListener("PipeService" + this.pipeId, this);
        this.myPipeResolver.forget(this.pipeId);
        if (!this.lflag) {
            this.queue.close();
        }
        this.closed = true;
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        String proto;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Receive message from " + srcAddr.toString()));
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("                  to " + dstAddr.toString()));
        }
        if (!(proto = dstAddr.getProtocolName()).equals("jxtatls") && !srcAddr.getProtocolAddress().equals(dstAddr.getProtocolAddress())) {
            return;
        }
        if (this.lflag) {
            PipeMsgEvent event = new PipeMsgEvent(this, msg, this.pID);
            this.listener.pipeMsgEvent(event);
        } else {
            this.queue.push(msg);
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

