/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeResolverMessage;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class PipeResolverMsg
extends PipeResolverMessage {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$protocol$PipeResolverMsg == null ? (class$net$jxta$impl$protocol$PipeResolverMsg = PipeResolverMsg.class$("net.jxta.impl.protocol.PipeResolverMsg")) : class$net$jxta$impl$protocol$PipeResolverMsg).getName());
    private static final String MsgTypeTag = "MsgType";
    private static final String PipeIdTag = "PipeId";
    private static final String PipeTypeTag = "Type";
    private static final String PeerIdTag = "Peer";
    private static final String CachedTag = "Cached";
    private static final String PeerAdvTag = "PeerAdv";
    private static final String FoundTag = "Found";
    private static final String QueryMsgType = "Query";
    private static final String AnswerMsgType = "Answer";
    static /* synthetic */ Class class$net$jxta$impl$protocol$PipeResolverMsg;
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public PipeResolverMsg() {
    }

    public PipeResolverMsg(Element root) {
        this.initialize(root);
    }

    public void initialize(Element root) {
        Serializable pipeID;
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = PipeResolverMsg.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        String docName = doc.getName();
        if (!docName.equals(PipeResolverMessage.getMessageType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + docName);
        }
        Enumeration enumeration = doc.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement elem = (TextElement)enumeration.nextElement();
            if (elem.getName().equals(MsgTypeTag)) {
                String msgtype = elem.getTextValue();
                if (msgtype.equals(QueryMsgType)) {
                    this.setMsgType(PipeResolverMessage.MessageType.QUERY);
                    continue;
                }
                if (msgtype.equals(AnswerMsgType)) {
                    this.setMsgType(PipeResolverMessage.MessageType.ANSWER);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected Message Type in parsing.");
            }
            if (elem.getName().equals(PipeIdTag)) {
                try {
                    pipeID = IDFactory.jxtaURL(elem.getTextValue());
                    this.setPipeID(IDFactory.fromURL((URL)pipeID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad pipe ID in message");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable pipe ID in message");
                }
            }
            if (elem.getName().equals(PipeTypeTag)) {
                this.setPipeType(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(PeerIdTag)) {
                try {
                    URL peerID = IDFactory.jxtaURL(elem.getTextValue());
                    this.addPeerID(IDFactory.fromURL(peerID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad peer ID in message");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable peerID in message");
                }
            }
            if (elem.getName().equals(FoundTag)) {
                this.setFound(Boolean.valueOf(elem.getTextValue()));
                continue;
            }
            if (elem.getName().equals(CachedTag)) {
                this.setCachedLookup(Boolean.valueOf(elem.getTextValue()));
                continue;
            }
            if (!elem.getName().equals(PeerAdvTag)) continue;
            String peerAdv = elem.getTextValue();
            try {
                this.setInputPeerAdv((PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new StringReader(peerAdv)));
            }
            catch (IOException caught) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Malformed peer adv in message", (Throwable)caught);
                }
                throw new IllegalArgumentException("Malformed peer adv in message : " + caught.getMessage());
            }
        }
        PipeResolverMessage.MessageType msgType = this.getMsgType();
        if (null == msgType) {
            throw new IllegalArgumentException("Message type was never set!");
        }
        pipeID = this.getPipeID();
        if (null == pipeID || ID.nullID.equals(pipeID) || !(pipeID instanceof PipeID)) {
            throw new IllegalArgumentException("Input Pipe ID not set or invalid");
        }
        if (null == this.getPipeType()) {
            throw new IllegalArgumentException("Pipe type was never set!");
        }
        if (PipeResolverMessage.MessageType.ANSWER.equals(msgType) && !this.getPeerIDs().hasMoreElements()) {
            throw new IllegalArgumentException("An answer without responses is invalid");
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, PipeResolverMessage.getMessageType());
        PipeResolverMessage.MessageType msgType = this.getMsgType();
        if (null == msgType) {
            throw new IllegalStateException("Message type was never set!");
        }
        if (null == this.getPipeType()) {
            throw new IllegalStateException("Pipe type was never set!");
        }
        ID pipeID = this.getPipeID();
        if (null == pipeID || ID.nullID.equals(pipeID) || !(pipeID instanceof PipeID)) {
            throw new IllegalStateException("Input Pipe ID not set or invalid");
        }
        TextElement e = null;
        if (PipeResolverMessage.MessageType.QUERY.equals(msgType)) {
            e = doc.createElement(MsgTypeTag, QueryMsgType);
        } else if (PipeResolverMessage.MessageType.ANSWER.equals(msgType)) {
            e = doc.createElement(MsgTypeTag, AnswerMsgType);
        } else {
            throw new IllegalStateException("Unknown message type :" + msgType.toString());
        }
        doc.appendChild((Element)e);
        e = doc.createElement(PipeIdTag, pipeID.toString());
        doc.appendChild((Element)e);
        String pipeType = this.getPipeType();
        if (null != pipeType && 0 != pipeType.length()) {
            e = doc.createElement(PipeTypeTag, pipeType);
            doc.appendChild((Element)e);
        }
        Enumeration peers = this.getPeerIDs();
        while (peers.hasMoreElements()) {
            ID aPeer = (ID)peers.nextElement();
            if (aPeer instanceof PeerID) {
                e = doc.createElement(PeerIdTag, aPeer.toString());
                doc.appendChild((Element)e);
                continue;
            }
            if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
            LOG.debug((Object)("Malformed peer id in list : " + aPeer));
        }
        if (PipeResolverMessage.MessageType.QUERY.equals(msgType)) {
            boolean cachedLookup = this.isCachedLookup();
            if (cachedLookup) {
                e = doc.createElement(CachedTag, Boolean.TRUE.toString());
                doc.appendChild((Element)e);
            }
        } else if (PipeResolverMessage.MessageType.ANSWER.equals(msgType)) {
            e = doc.createElement(FoundTag, (this.isFound() ? Boolean.TRUE : Boolean.FALSE).toString());
            doc.appendChild((Element)e);
            PeerAdvertisement peerAdv = this.getInputPeerAdv();
            if (null == peerAdv) {
                throw new IllegalStateException("Peer Advertisement must be present if respoinding with found");
            }
            StringWriter stringWriter = new StringWriter();
            try {
                StructuredTextDocument asDoc = (StructuredTextDocument)peerAdv.getDocument(new MimeMediaType("text/xml"));
                asDoc.sendToWriter(stringWriter);
                e = doc.createElement(PeerAdvTag, ((Object)stringWriter).toString());
                doc.appendChild((Element)e);
            }
            catch (IOException caught) {
                throw new IllegalStateException("Malformed Peer Advertisement :" + caught.getMessage());
            }
        } else {
            throw new IllegalStateException("Unknown message type :" + msgType.toString());
        }
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

