/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.ResolverQueryMsg;
import org.apache.log4j.Category;

public class ResolverQuery
extends ResolverQueryMsg {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$protocol$ResolverQuery == null ? (class$net$jxta$impl$protocol$ResolverQuery = ResolverQuery.class$("net.jxta.impl.protocol.ResolverQuery")) : class$net$jxta$impl$protocol$ResolverQuery).getName());
    private static final String handlernameTag = "HandlerName";
    private static final String credentialTag = "jxta:Cred";
    private static final String queryIdTag = "QueryID";
    private static final String srcPeerIdTag = "SrcPeerID";
    private static final String queryTag = "Query";
    static /* synthetic */ Class class$net$jxta$impl$protocol$ResolverQuery;

    public ResolverQuery(InputStream stream) throws IOException {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), stream);
        this.readIt(doc);
    }

    public ResolverQuery(TextElement doc) {
        if (!ResolverQueryMsg.getAdvertisementType().equals(doc.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.readIt(doc);
    }

    public void readIt(TextElement doc) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(handlernameTag)) {
                this.setHandlerName(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(credentialTag)) {
                this.setCredential(StructuredDocumentUtils.copyAsDocument(elem));
                continue;
            }
            if (elem.getName().equals(queryIdTag)) {
                this.queryid = Integer.parseInt(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(srcPeerIdTag)) {
                this.setSrc(elem.getTextValue());
                continue;
            }
            if (!elem.getName().equals(queryTag)) continue;
            this.setQuery(elem.getTextValue());
        }
    }

    public ResolverQuery(String HandlerName, StructuredDocument Credential2, String pId, String Query, int qid) {
        this.setHandlerName(HandlerName);
        this.setCredential(Credential2);
        this.setQueryId(qid);
        this.setSrc(pId);
        this.setQuery(Query);
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, ResolverQueryMsg.getAdvertisementType());
        TextElement e = adv.createElement(handlernameTag, this.getHandlerName());
        adv.appendChild((Element)e);
        if (this.getCredential() != null) {
            StructuredDocumentUtils.copyElements(adv, adv, this.getCredential());
        }
        e = adv.createElement(queryIdTag, Integer.toString(this.queryid));
        adv.appendChild((Element)e);
        e = adv.createElement(srcPeerIdTag, this.getSrc());
        adv.appendChild((Element)e);
        e = adv.createElement(queryTag, this.getQuery());
        adv.appendChild((Element)e);
        return adv;
    }

    public String toString() {
        try {
            StringWriter out = new StringWriter();
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(new MimeMediaType("text/xml"));
            doc.sendToWriter(out);
            String result = out.toString();
            return result;
        }
        catch (Exception e) {
            LOG.debug((Object)"Could not generate ResolverQuery");
            return "";
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

