/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.relay;

import java.util.TimerTask;
import net.jxta.impl.util.BoundedQueue;

public class RelayLease {
    private int leaseLength = 0;
    private String leaseId = null;
    private String peerId = null;
    private long issueTime = 0L;
    private TimerTask currTimerTask = null;
    private BoundedQueue queue = new BoundedQueue(32);

    public RelayLease(String peerId, String leaseId, int leaseLength) {
        this.peerId = peerId;
        this.leaseId = leaseId;
        this.leaseLength = leaseLength;
        this.issueTime = System.currentTimeMillis();
    }

    public void setTimerTask(TimerTask currTimerTask) {
        this.currTimerTask = currTimerTask;
    }

    public void refresh() {
        this.issueTime = System.currentTimeMillis();
    }

    public boolean isValid() {
        long elapsedTime = System.currentTimeMillis() - this.issueTime;
        return elapsedTime < (long)this.leaseLength;
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    public int getLeaseLength() {
        return this.leaseLength;
    }

    public long getTimeLeft() {
        return this.issueTime + (long)this.leaseLength - System.currentTimeMillis();
    }

    public String getPeerId() {
        return this.peerId;
    }

    public TimerTask getTimerTask() {
        return this.currTimerTask;
    }

    public BoundedQueue getQueue() {
        return this.queue;
    }

    public void close() {
        BoundedQueue oldQueue;
        RelayLease relayLease = this;
        synchronized (relayLease) {
            oldQueue = this.queue;
            this.queue = null;
        }
        if (oldQueue != null) {
            oldQueue.clear();
        }
    }
}

