/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.util.Enumeration;
import net.jxta.discovery.DiscoveryService;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.EndpointReceiveQueue;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class PeerConnection
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$rendezvous$PeerConnection == null ? (class$net$jxta$impl$rendezvous$PeerConnection = PeerConnection.class$("net.jxta.impl.rendezvous.PeerConnection")) : class$net$jxta$impl$rendezvous$PeerConnection).getName());
    public static final int MaxNbOfMessages = 40;
    private String peer = null;
    private String peerName = null;
    private long lease = 0L;
    private boolean connected = false;
    private EndpointService endpoint = null;
    private DiscoveryService discovery = null;
    private EndpointReceiveQueue queue = null;
    private Thread thread = null;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$PeerConnection;

    public PeerConnection(PeerGroup group, String p, long l) {
        this.peer = p;
        this.endpoint = group.getEndpointService();
        this.discovery = group.getDiscoveryService();
        this.connected = true;
        this.lease = System.currentTimeMillis() + l < 0L ? l : System.currentTimeMillis() + l;
    }

    public synchronized void connect() {
        this.connected = true;
        if (this.queue == null) {
            this.queue = new EndpointReceiveQueue();
            this.queue.setMaxNbOfMessages(40);
        }
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "RDV Connection to " + this.getPeerName());
        this.thread.start();
        Thread.currentThread();
        Thread.yield();
    }

    private synchronized void setThreadName() {
        block3: {
            if (this.thread != null) {
                try {
                    this.thread.setName("RDV Connection [queue = " + this.queue.getNbOfQueuedMessages() + " ] to " + this.getPeerName());
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) break block3;
                    LOG.error((Object)"Cannot change thread name", (Throwable)ez1);
                }
            }
        }
    }

    public synchronized String getPeerName() {
        if (this.peerName != null) {
            return this.peerName;
        }
        try {
            Enumeration enumeration = this.discovery.getLocalAdvertisements(0, "PID", this.peer);
            if (enumeration != null && enumeration.hasMoreElements()) {
                PeerAdvertisement adv = (PeerAdvertisement)enumeration.nextElement();
                this.peerName = adv.getName();
            }
        }
        catch (Exception ez1) {
            this.peerName = null;
            return this.peer;
        }
        return this.peerName;
    }

    public synchronized void setLease(long lease) {
        this.lease = lease;
    }

    public synchronized long getLease() {
        return this.lease;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized void setPeer(String peer) {
        this.peer = peer;
    }

    public synchronized String getPeer() {
        return this.peer;
    }

    private EndpointMessenger getMessenger(String pName, String pParam) {
        EndpointMessenger tmpMessenger = null;
        try {
            tmpMessenger = this.endpoint.getMessenger(this.mkAddress(this.peer, pName, pParam));
            return tmpMessenger;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void doSendMessage(Message msg) {
        String pParam;
        if (!this.isConnected()) {
            return;
        }
        EndpointAddress dstAddress = msg.getDestinationAddress();
        String pName = dstAddress.getServiceName();
        EndpointMessenger messenger = this.getMessenger(pName, pParam = dstAddress.getServiceParameter());
        if (messenger == null) {
            this.notifyFailure();
            return;
        }
        try {
            messenger.sendMessage(msg);
        }
        catch (Exception e) {
            this.notifyFailure();
        }
    }

    public void sendMessage(Message msg, String pName, String pParam) {
        if (!this.isConnected()) {
            return;
        }
        EndpointAddress dstAddress = msg.getDestinationAddress();
        if (dstAddress != null) {
            dstAddress.setServiceName(pName);
            dstAddress.setServiceParameter(pParam);
        } else {
            dstAddress = this.mkAddress(this.peer, pName, pParam);
        }
        msg.setDestinationAddress(dstAddress);
        PeerConnection peerConnection = this;
        synchronized (peerConnection) {
            this.queue.push(msg);
            this.setThreadName();
        }
    }

    private EndpointAddress mkAddress(String destPeer) {
        try {
            PeerID asID = (PeerID)IDFactory.fromURL(IDFactory.jxtaURL(destPeer));
            String asString = "jxta://" + asID.getUniqueValue().toString();
            EndpointAddress addr = this.endpoint.newEndpointAddress(asString);
            return addr;
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Invalid peerID string " + destPeer));
            }
            return null;
        }
    }

    private EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        EndpointAddress addr = this.mkAddress(destPeer);
        addr.setServiceName(serv);
        addr.setServiceParameter(parm);
        return addr;
    }

    public boolean equals(Object obj) {
        return this.peer.equals(((PeerConnection)obj).peer);
    }

    public void run() {
        Message msg = null;
        while (true) {
            if (!this.isConnected()) {
                this.close();
                return;
            }
            try {
                msg = this.queue.waitForMessage();
                this.setThreadName();
            }
            catch (InterruptedException e) {
                if (!this.isConnected()) {
                    this.close();
                    return;
                }
                this.notifyFailure();
                continue;
            }
            this.doSendMessage(msg);
        }
    }

    private synchronized void notifyFailure() {
        this.close();
        this.connected = false;
    }

    public synchronized void close() {
        block4: {
            this.connected = false;
            if (this.queue != null) {
                this.queue.close();
                this.queue = null;
            }
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                    this.thread = null;
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                    LOG.warn((Object)("Cannot interrupt RDV thread for " + this.getPeerName()), (Throwable)ez1);
                }
            }
        }
    }

    public void finalize() {
        this.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

