/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.IOException;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.util.JxtaTimer;
import net.jxta.impl.util.JxtaTimerHandler;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.rendezvous.RendezVousMonitor;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class RdvMonitor
implements JxtaTimerHandler,
RendezVousMonitor {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$rendezvous$RdvMonitor == null ? (class$net$jxta$impl$rendezvous$RdvMonitor = RdvMonitor.class$("net.jxta.impl.rendezvous.RdvMonitor")) : class$net$jxta$impl$rendezvous$RdvMonitor).getName());
    private static final long LeaseMargin = 600000L;
    private static final long LeaseRenewalDelay = 120000L;
    private PeerGroup group = null;
    private DiscoveryService discovery = null;
    private long lease = 0L;
    private JxtaTimer timer = null;
    private Vector rdvs = new Vector();
    private RendezVousServiceImpl rendezvous = null;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$RdvMonitor;

    public RdvMonitor(PeerGroup g, RendezVousServiceImpl rendezvous) {
        this.group = g;
        this.rendezvous = rendezvous;
        this.discovery = this.group.getDiscoveryService();
        if (this.group.isRendezvous()) {
            this.publishAdv(this.group.getPeerID(), 240000L);
        }
        this.timer = new JxtaTimer(this, 120000L, true);
    }

    public void connected(PeerID peer, long lease) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("connected: new connection to a RendezVous\n  group = " + this.group.getPeerGroupID() + "\n   peer = " + peer + "\n  lease = " + lease));
        }
        this.addRendezVous(peer.toString(), lease);
        this.publishAdv(peer, lease);
    }

    public void disconnected(PeerID peer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("disconnected from RendezVous\n  group = " + this.group.getPeerGroupID() + "\n peerId = " + peer.toString()));
        }
    }

    public void discovered(Advertisement adv) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"discovered: got new RendezVousService advertisement.");
        }
        if (this.discovery != null) {
            try {
                this.discovery.publish(adv, 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void signal(JxtaTimer timer) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("monitor daemon awakes for " + this.group.getPeerGroupID()));
        }
        if (this.group.isRendezvous()) {
            this.publishAdv(this.group.getPeerID(), 240000L);
        }
        int i = 0;
        while (i < this.rdvs.size()) {
            block6: {
                RdV rdv = null;
                try {
                    rdv = (RdV)this.rdvs.elementAt(i);
                    long leaseRemaining = rdv.lease - System.currentTimeMillis();
                    if (leaseRemaining < 600000L) {
                        this.rendezvous.reconnectToRendezVous(rdv.peer);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block6;
                    LOG.debug((Object)"rdv renewal failed.", (Throwable)e);
                }
            }
            ++i;
        }
    }

    private synchronized void addRendezVous(String peer, long lease) {
        RdV rdv = new RdV(peer);
        if (this.rdvs.contains(rdv)) {
            try {
                int index = this.rdvs.indexOf(rdv);
                if (index == -1) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"addRendezVous cannot access RdV object");
                    }
                    return;
                }
                rdv = (RdV)this.rdvs.elementAt(index);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("addRendez failed [1] " + e));
                }
            }
        } else {
            this.rdvs.addElement(rdv);
        }
        if (lease < 0L) {
            lease = 3600000L;
        }
        rdv.lease = System.currentTimeMillis() + lease;
    }

    private RdvAdvertisement createRdvAdv(PeerGroupID gid, PeerID rdvid, long timeout) {
        RdvAdvertisement adv = null;
        try {
            adv = (RdvAdvertisement)AdvertisementFactory.newAdvertisement(RdvAdvertisement.getAdvertisementType());
        }
        catch (Exception all) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Advertisement document could not be created");
            }
            return null;
        }
        adv.setGroupID(gid);
        adv.setPeerID(rdvid);
        return adv;
    }

    protected void startRdv() {
        this.publishAdv(this.group.getPeerID(), 120000L);
    }

    private void publishAdv(PeerID pid, long lease) {
        block8: {
            DiscoveryService parentDiscovery;
            RdvAdvertisement rdv = this.createRdvAdv(this.group.getPeerGroupID(), pid, lease);
            if (rdv == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"could not construct advertisement");
                }
                return;
            }
            PeerGroup parent = ((RefPeerGroup)this.group).getParentGroup();
            if (parent == null) {
                parent = this.group;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Publish RdvAdvertisement into group : " + parent.getPeerGroupID().toString() + "\n        gid = " + this.group.getPeerGroupID().toString() + "\n        pid = " + pid.toString() + "\n      lease = " + lease / 1000L + " secs"));
            }
            if ((parentDiscovery = parent.getDiscoveryService()) == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Cannot access parent's Discovery Service");
                }
                return;
            }
            try {
                parentDiscovery.publish(rdv, 2, lease, lease);
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block8;
                LOG.warn((Object)"Could not locally publish advertisement", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RdV {
        protected String peer;
        protected long lease;

        public RdV(String peer) {
            this.peer = peer;
            this.lease = 0L;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof RdV) {
                RdV rdv = (RdV)obj;
                return rdv.peer.equals(this.peer);
            }
            return false;
        }
    }
}

