/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.util.LinkedList;
import org.apache.log4j.Category;

public class BoundedQueue {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$util$BoundedQueue == null ? (class$net$jxta$impl$util$BoundedQueue = BoundedQueue.class$("net.jxta.impl.util.BoundedQueue")) : class$net$jxta$impl$util$BoundedQueue).getName());
    private LinkedList list = new LinkedList();
    private int maxSize = -1;
    private static final int DEFAULT_MAX_SIZE = -1;
    public static final int BLOCK_FOREVER = 0;
    public static final int DO_NOT_BLOCK = -1;
    public static final int DROP_OLDEST = -2;
    static /* synthetic */ Class class$net$jxta$impl$util$BoundedQueue;

    public BoundedQueue() {
    }

    public BoundedQueue(int maxSize) {
        this.maxSize = maxSize;
    }

    public synchronized void clear() {
        this.list.clear();
        this.notifyAll();
    }

    public synchronized boolean enqueue(Object obj, long waitTimeout) throws InterruptedException {
        if (this.maxSize != -1) {
            if (this.list.size() >= this.maxSize) {
                if (waitTimeout == -1L) {
                    return false;
                }
                if (waitTimeout == -2L) {
                    this.list.removeLast();
                    this.list.addLast(obj);
                    this.notifyAll();
                    return true;
                }
            }
            if (waitTimeout == 0L) {
                while (this.list.size() >= this.maxSize) {
                    this.wait();
                }
            } else {
                long deadLine = System.currentTimeMillis() + waitTimeout;
                while (this.list.size() >= this.maxSize) {
                    long timeLeft = deadLine - System.currentTimeMillis();
                    if (timeLeft < 0L) {
                        return false;
                    }
                    this.wait(timeLeft);
                }
            }
        }
        this.list.addLast(obj);
        this.notifyAll();
        return true;
    }

    public boolean enqueue(Object obj) throws InterruptedException {
        return this.enqueue(obj, 0L);
    }

    public synchronized Object dequeue(long waitTimeout) throws InterruptedException {
        if (waitTimeout == -1L && this.list.isEmpty()) {
            return null;
        }
        if (waitTimeout == 0L) {
            while (this.list.isEmpty()) {
                this.wait();
            }
        } else {
            long deadLine = System.currentTimeMillis() + waitTimeout;
            while (this.list.isEmpty()) {
                long timeLeft = deadLine - System.currentTimeMillis();
                if (timeLeft < 0L) {
                    return null;
                }
                this.wait(timeLeft);
            }
        }
        Object retval = this.list.removeFirst();
        this.notifyAll();
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

