/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import net.jxta.endpoint.Message;
import net.jxta.impl.util.Timer;
import org.apache.log4j.Category;

class OutgoingMessageQueue {
    private static final Category LOG = Category.getInstance((Class)(class$net$jxta$impl$util$OutgoingMessageQueue == null ? (class$net$jxta$impl$util$OutgoingMessageQueue = OutgoingMessageQueue.class$("net.jxta.impl.util.OutgoingMessageQueue")) : class$net$jxta$impl$util$OutgoingMessageQueue));
    Message[] arr;
    int head;
    int tail;
    int total = 0;
    static /* synthetic */ Class class$net$jxta$impl$util$OutgoingMessageQueue;

    OutgoingMessageQueue(int size) {
        this.arr = new Message[size];
    }

    synchronized void enqueue(Message msg) throws InterruptedException {
        while (this.isFull()) {
            this.wait();
        }
        this.arr[this.tail] = msg;
        this.tail = (this.tail + 1) % this.arr.length;
        ++this.total;
        LOG.debug((Object)("WATCH: Total messages on queue = " + this.total));
        this.notifyAll();
    }

    synchronized void slide(long n) {
        int i = 0;
        while ((long)i < n) {
            this.arr[this.head] = null;
            --this.total;
            this.head = (this.head + 1) % this.arr.length;
            ++i;
        }
    }

    synchronized Message get(int i, long maxTimeout) throws InterruptedException {
        Timer t = new Timer();
        while (this.total < i) {
            t.start();
            this.wait(maxTimeout);
            if (t.elapsed() < maxTimeout) continue;
            return null;
        }
        return this.arr[(this.head + i) % this.arr.length];
    }

    synchronized Message dequeue(long maxTimeout) throws InterruptedException {
        Timer t = new Timer();
        while (this.isEmpty()) {
            t.start();
            this.wait(maxTimeout);
            if (t.elapsed() < maxTimeout) continue;
            return null;
        }
        Message m = this.arr[this.head];
        this.arr[this.head] = null;
        this.head = (this.head + 1) % this.arr.length;
        --this.total;
        LOG.debug((Object)("WATCH Total messages in outgoing queue is " + this.total));
        return m;
    }

    boolean isEmpty() {
        return this.total == 0;
    }

    boolean isFull() {
        return this.total == this.arr.length;
    }

    int getMessageCount() {
        return this.total;
    }

    int getFreeSlots() {
        return this.arr.length - this.total;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

