/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.util.BidirectionalPipeService;
import net.jxta.impl.util.IncomingMessageQueue;
import net.jxta.impl.util.OutgoingMessageQueue;
import net.jxta.impl.util.SchedulerService;
import net.jxta.impl.util.Timer;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Category;

public class ReliablePipeService {
    private static final Category LOG = Category.getInstance((Class)(class$net$jxta$impl$util$ReliablePipeService == null ? (class$net$jxta$impl$util$ReliablePipeService = ReliablePipeService.class$("net.jxta.impl.util.ReliablePipeService")) : class$net$jxta$impl$util$ReliablePipeService));
    BidirectionalPipeService bidirPipeService;
    SchedulerService schedulerService;
    static final String RELIABLE_HEADER = "RELIABLE_HEADER";
    static final int SYN = 1;
    static final int SYN_ACK = 2;
    static final int MSG = 3;
    static final int ACK = 4;
    static final int FIN1 = 5;
    static final int FIN2 = 6;
    static final int ESTABLISHING = 1;
    static final int CONNECTED = 2;
    static final int TIMED_OUT = 3;
    static final int CLOSE_WAIT = 4;
    static final int CLOSED = 5;
    static final int MAX_RETRANSMITS = 5;
    static final int MSG_TIMEOUT = 30000;
    static final int RETRANSMIT_TIMEOUT = 1000;
    static final int WINDOW_FLUSH_TIMEOUT = 500;
    static /* synthetic */ Class class$net$jxta$impl$util$ReliablePipeService;

    public ReliablePipeService(BidirectionalPipeService bidirPipeService) {
        this.bidirPipeService = bidirPipeService;
        this.schedulerService = new SchedulerService();
        new Thread(this.schedulerService).start();
    }

    public Pipe connect(PipeAdvertisement adv, int maxTimeout) throws IOException {
        LOG.debug((Object)"WATCH: REALLY Connecting...");
        Timer t = new Timer();
        t.start();
        BidirectionalPipeService.Pipe bidirPipe = this.bidirPipeService.connect(adv, maxTimeout);
        LOG.debug((Object)"WATCH: got bidirPipe");
        maxTimeout = (int)((long)maxTimeout - t.elapsed());
        if (maxTimeout > 0) {
            LOG.debug((Object)"WATCH: creating new Pipe");
            return new Pipe(bidirPipe, maxTimeout);
        }
        throw new IOException("Connect timed out.");
    }

    public AcceptPipe bind(String pipeName) throws IOException {
        return new AcceptPipe(this.bidirPipeService.bind(pipeName));
    }

    public AcceptPipe bind(PipeAdvertisement inputPipeAdv) throws IOException {
        return new AcceptPipe(this.bidirPipeService.bind(inputPipeAdv));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Pipe
    implements InputPipe,
    OutputPipe {
        IncomingMessageQueue incomingQueue;
        IncomingMessageQueue incomingQueue2;
        OutgoingMessageQueue outgoingQueue;
        HashMap pendingRetransmits;
        long outgoingSeq;
        long highestInSeq;
        long lastAckedSeq;
        long synSeq = -1L;
        InputPipe inputPipe;
        OutputPipe outputPipe;
        Receiver receiver;
        Sender sender;
        int outgoingWindow;
        int state;
        boolean running = false;
        Object lock = new Object();
        Vector listeners = new Vector();

        Pipe(BidirectionalPipeService.Pipe bidirPipe, long maxTimeout) throws IOException {
            LOG.debug((Object)"WATCH: Pipe constructor");
            this.inputPipe = bidirPipe.getInputPipe();
            this.outputPipe = bidirPipe.getOutputPipe();
            this.incomingQueue = new IncomingMessageQueue(512);
            this.incomingQueue2 = new IncomingMessageQueue(512);
            this.outgoingQueue = new OutgoingMessageQueue(512);
            this.pendingRetransmits = new HashMap();
            this.state = 1;
            LOG.debug((Object)"WATCH: starting receiver");
            this.running = true;
            this.receiver = new Receiver();
            new Thread(this.receiver).start();
            this.establish(maxTimeout);
        }

        public InputPipe getInputPipe() {
            return this;
        }

        public OutputPipe getOutputPipe() {
            return this;
        }

        void establish(long maxTimeout) throws IOException {
            LOG.debug((Object)"WATCH: sending SYN...");
            this.sendMsg(1, this.synSeq, 0);
            try {
                while (this.state == 1) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait(maxTimeout);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while establishing connection.");
            }
            if (this.state != 2) {
                throw new IOException("Connect timed out.");
            }
            LOG.debug((Object)"WATCH: starting sender...");
            this.sender = new Sender();
            new Thread(this.sender).start();
        }

        public void close() {
            if (this.state != 4) {
                this.state = 4;
                try {
                    this.sendMsg(5, -1L, 0);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public synchronized void send(Message msg) throws IOException {
            switch (this.state) {
                case 1: {
                    throw new Error("Should never be here.  Theis state is only while the contructor is running.");
                }
                case 2: {
                    LOG.debug((Object)"WATCH: enqueuing message...");
                    try {
                        this.outgoingQueue.enqueue(msg);
                        break;
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Thread was interrupted while in send(): " + e.getMessage());
                    }
                }
                case 3: {
                    throw new IOException("The peer at the other end has dropped the connection.");
                }
                case 4: {
                    throw new IOException("Shutdown in progress.");
                }
                case 5: {
                    throw new IOException("Connection has closed.");
                }
            }
        }

        public synchronized Message waitForMessage() throws InterruptedException {
            return this.poll(-1);
        }

        public synchronized Message poll(int msgTimeout) throws InterruptedException {
            return this.incomingQueue.pop(msgTimeout);
        }

        public synchronized void addPipeMsgListener(PipeMsgListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        public synchronized void removePipeMsgListener(PipeMsgListener listener) {
            this.listeners.remove(listener);
        }

        void notifyListeners() {
            Message msg = this.incomingQueue.popNext();
            while (msg != null) {
                PipeMsgEvent pipeMsgEvent = new PipeMsgEvent(this, msg, null);
                Iterator iter = ((AbstractList)this.listeners).iterator();
                while (iter.hasNext()) {
                    PipeMsgListener listener = (PipeMsgListener)iter.next();
                    listener.pipeMsgEvent(pipeMsgEvent);
                }
                msg = this.incomingQueue.popNext();
            }
        }

        void process(Message msg) throws IOException {
            DataInputStream header = new DataInputStream(msg.getElement(ReliablePipeService.RELIABLE_HEADER).getStream());
            long seq = header.readLong();
            int type = header.readInt();
            int window = header.readInt();
            if (type != 1 && type != 2 && type != 4) {
                this.incomingQueue2.put(msg, seq);
                this.highestInSeq = this.incomingQueue2.popUntilBreakInSequence(this.highestInSeq);
                LOG.debug((Object)("WATCH: Sending ACK " + this.highestInSeq));
                LOG.debug((Object)("WATCH: Free Slots = " + this.incomingQueue.getFreeSlots()));
                this.sendMsg(4, this.highestInSeq, this.incomingQueue.getFreeSlots());
            }
            block2 : switch (this.state) {
                case 1: {
                    switch (type) {
                        case 1: {
                            LOG.debug((Object)"WATCH: Received SYN, Sending SYN_ACK");
                            this.outgoingSeq = new Random().nextLong();
                            this.sendMsg(2, this.outgoingSeq++, 1);
                            break block2;
                        }
                        case 2: {
                            LOG.debug((Object)"WATCH: Received SYN_ACK");
                            Object pendingRetransmit = this.pendingRetransmits.get(new Long(this.synSeq));
                            if (pendingRetransmit != null) {
                                LOG.debug((Object)("Canceling retransmit for " + this.synSeq));
                                ReliablePipeService.this.schedulerService.cancelAction(pendingRetransmit);
                                this.pendingRetransmits.remove(new Long(this.synSeq));
                            } else {
                                LOG.debug((Object)("No retransmit scheduled for " + this.synSeq));
                            }
                            this.lastAckedSeq = this.highestInSeq = seq;
                            this.state = 2;
                            this.incomingQueue.setNextExpected(seq + 1L);
                            this.outgoingWindow = window;
                            Object object = this.lock;
                            synchronized (object) {
                                this.lock.notifyAll();
                                break block2;
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    switch (type) {
                        case 3: {
                            LOG.debug((Object)("WATCH: putting msg " + seq + " on incoming queue *****"));
                            this.incomingQueue.put(msg, seq);
                            this.notifyListeners();
                            break;
                        }
                        case 4: {
                            LOG.debug((Object)("WATCH: got ACK " + seq));
                            Object pendingRetransmit = this.pendingRetransmits.get(new Long(seq));
                            if (pendingRetransmit != null) {
                                LOG.debug((Object)("Canceling retransmit for " + seq));
                                ReliablePipeService.this.schedulerService.cancelAction(pendingRetransmit);
                                this.pendingRetransmits.remove(new Long(seq));
                                LOG.debug((Object)("WATCH: seq = " + seq + " lastAckedSeq = " + this.lastAckedSeq));
                                this.lastAckedSeq = seq;
                            } else {
                                LOG.debug((Object)("No retransmit scheduled for " + seq));
                            }
                            this.outgoingWindow = window;
                            break;
                        }
                        case 5: {
                            this.state = 4;
                        }
                    }
                }
                case 4: {
                    switch (type) {
                        case 6: {
                            this.state = 5;
                        }
                    }
                }
            }
        }

        void sendMsg(int type, long seq, int window) throws IOException {
            Message msg = ReliablePipeService.this.bidirPipeService.pipeService.createMessage();
            this.setHeader(msg, type, seq, window);
            this.outputPipe.send(msg);
            if (type != 4 && type != 2) {
                Object pendingRetransmit = ReliablePipeService.this.schedulerService.scheduleAction(new RetransmitAction(msg), 1000L);
                this.pendingRetransmits.put(new Long(seq), pendingRetransmit);
            }
        }

        void sendMsg(Message msg, long seq) throws IOException {
            this.setHeader(msg, 3, seq, 0);
            this.outputPipe.send(msg);
            Object pendingRetransmit = ReliablePipeService.this.schedulerService.scheduleAction(new RetransmitAction(msg), 1000L);
            this.pendingRetransmits.put(new Long(seq), pendingRetransmit);
        }

        void setHeader(Message msg, int type, long seq, int window) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream(12);
            DataOutputStream dout = new DataOutputStream(out);
            dout.writeLong(seq);
            dout.writeInt(type);
            dout.writeInt(window);
            MessageElement msgElem = msg.newMessageElement(ReliablePipeService.RELIABLE_HEADER, null, out.toByteArray());
            msg.addElement(msgElem);
        }

        class RetransmitAction
        implements SchedulerService.Action {
            Message msg;
            int retransmits;

            RetransmitAction(Message msg) {
                this.msg = msg;
            }

            public void perform(SchedulerService ss) {
                long seq = 0L;
                try {
                    DataInputStream header = new DataInputStream(this.msg.getElement(ReliablePipeService.RELIABLE_HEADER).getStream());
                    seq = header.readLong();
                    int type = header.readInt();
                    int window = header.readInt();
                    LOG.debug((Object)("Retransmitting " + seq + " type " + type));
                    Pipe.this.outputPipe.send(this.msg);
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (this.retransmits < 5) {
                    Object pendingRetransmit = ss.scheduleAction(this, 1000L);
                    Pipe.this.pendingRetransmits.put(new Long(seq), pendingRetransmit);
                    ++this.retransmits;
                } else {
                    Pipe.this.state = 3;
                    Object object = Pipe.this.lock;
                    synchronized (object) {
                        Pipe.this.lock.notifyAll();
                    }
                }
            }
        }

        class Sender
        implements Runnable {
            Sender() {
            }

            public void run() {
                LOG.debug((Object)"WATCH: sending messages on queue");
                block6: while (Pipe.this.state != 4) {
                    Timer t = new Timer();
                    t.start();
                    LOG.debug((Object)("WATCH: outgoingWindow = " + Pipe.this.outgoingWindow));
                    int i = 0;
                    while (i < Pipe.this.outgoingWindow) {
                        try {
                            Message m;
                            LOG.debug((Object)("WATCH: getting message off the queue, i = " + i));
                            LOG.debug((Object)("WATCH: elapsed time = " + t.elapsed()));
                            long timeLeft = 500L - t.elapsed();
                            if (timeLeft > 0L) {
                                m = Pipe.this.outgoingQueue.dequeue(timeLeft);
                            } else {
                                if (Pipe.this.outgoingQueue.isEmpty()) continue block6;
                                m = Pipe.this.outgoingQueue.dequeue(0L);
                            }
                            if (m == null) {
                                LOG.debug((Object)"WATCH: No message :-(");
                                continue block6;
                            }
                            try {
                                LOG.debug((Object)("WATCH: sending message " + Pipe.this.outgoingSeq + " ping = " + m.getString("count")));
                                Pipe.this.sendMsg(m, Pipe.this.outgoingSeq++);
                            }
                            catch (IOException e) {}
                        }
                        catch (InterruptedException e) {
                            continue block6;
                        }
                        ++i;
                    }
                }
                if (Pipe.this.state == 4) {
                    try {
                        Pipe.this.sendMsg(6, Pipe.this.outgoingSeq++, 0);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        class Receiver
        implements Runnable {
            Receiver() {
            }

            public void run() {
                while (Pipe.this.state != 5) {
                    try {
                        Message msg = Pipe.this.inputPipe.poll(30000);
                        LOG.debug((Object)("WATCH: got message " + msg));
                        if (!Pipe.this.running) break;
                        if (msg == null) continue;
                        LOG.debug((Object)"WATCH: message not null, processing");
                        Pipe.this.process(msg);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public class AcceptPipe {
        BidirectionalPipeService.AcceptPipe acceptPipe;

        AcceptPipe(BidirectionalPipeService.AcceptPipe acceptPipe) {
            this.acceptPipe = acceptPipe;
        }

        public PipeAdvertisement getAdvertisement() {
            return this.acceptPipe.getAdvertisement();
        }

        public Pipe accept(int maxTimeout) throws IOException, InterruptedException {
            LOG.debug((Object)"WATCH: REALLY waiting for connections....");
            Timer t = new Timer();
            t.start();
            BidirectionalPipeService.Pipe bidirPipe = this.acceptPipe.accept(maxTimeout);
            LOG.debug((Object)("WATCH: got bidirPipe..." + bidirPipe));
            maxTimeout = (int)((long)maxTimeout - t.elapsed());
            LOG.debug((Object)("WATCH: maxTimeout = " + maxTimeout));
            if (maxTimeout > 0) {
                LOG.debug((Object)"WATCH: creating new Pipe...");
                return new Pipe(bidirPipe, maxTimeout);
            }
            throw new IOException("Connect timed out.");
        }
    }
}

