/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.util.ArrayList;
import java.util.List;
import net.jxta.impl.util.TimeUtils;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class UnbiasedQueue {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$util$UnbiasedQueue == null ? (class$net$jxta$impl$util$UnbiasedQueue = UnbiasedQueue.class$("net.jxta.impl.util.UnbiasedQueue")) : class$net$jxta$impl$util$UnbiasedQueue).getName());
    protected static final int DEFAULT_MAX_OBJECTS = 100;
    protected static final boolean DROP_OLDEST_OBJECT = true;
    protected static final long DROPPED_OBJECT_WARNING_INTERVAL = 10000L;
    protected List queue = null;
    protected int maxObjects;
    protected volatile boolean closeFlag = false;
    protected boolean dropOldestObject = true;
    protected long numEnqueued = 0L;
    protected long sumOfQueueSizesEnqueue = 0L;
    protected long numDequeued = 0L;
    protected long sumOfQueueSizesDequeue = 0L;
    protected long numDropped = 0L;
    protected long nextDroppedWarn = 0L;
    static /* synthetic */ Class class$net$jxta$impl$util$UnbiasedQueue;

    public static UnbiasedQueue synchronizedQueue(UnbiasedQueue queue) {
        return new SynchronizedQueue(queue);
    }

    public UnbiasedQueue() {
        this(100, true);
    }

    public UnbiasedQueue(int size, boolean dropOldest) {
        this(size, dropOldest, new ArrayList());
    }

    protected UnbiasedQueue(int size, boolean dropOldest, List queue) {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be > 0");
        }
        if (null == queue) {
            throw new IllegalArgumentException("queue must be non-null");
        }
        this.maxObjects = size;
        this.queue = queue;
        this.closeFlag = false;
        this.dropOldestObject = dropOldest;
    }

    public boolean isClosed() {
        return this.closeFlag;
    }

    public void close() {
        this.closeFlag = true;
    }

    public void clear() {
        this.numDropped += (long)this.queue.size();
        this.queue.clear();
    }

    public boolean push(Object obj, long timeout) throws InterruptedException {
        if (0L == timeout) {
            timeout = Long.MAX_VALUE;
        }
        long absoluteTimeOut = TimeUtils.toAbsoluteTimeMillis(timeout);
        List list = this.queue;
        synchronized (list) {
            do {
                if (this.isClosed()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.queue.size() < this.maxObjects) break;
                timeout = TimeUtils.toRelativeTimeMillis(absoluteTimeOut);
                if (timeout > 0L) {
                    this.queue.wait(timeout);
                    continue;
                }
                if (this.dropOldestObject) {
                    while (this.queue.size() >= this.maxObjects) {
                        ++this.numDropped;
                        this.queue.remove(0);
                    }
                    long now = TimeUtils.timeNow();
                    if (now <= this.nextDroppedWarn || !LOG.isEnabledFor(Priority.WARN)) continue;
                    LOG.warn((Object)("Queue full, dropped one or more elements. Now dropped " + this.numDropped + " elements."));
                    this.nextDroppedWarn = now + 10000L;
                    continue;
                }
                boolean bl = false;
                return bl;
            } while (!this.isClosed());
            ++this.numEnqueued;
            this.sumOfQueueSizesEnqueue += (long)this.queue.size();
            this.queue.add(obj);
            this.queue.notify();
        }
        return true;
    }

    public Object pop() {
        Object result = null;
        if (this.queue.isEmpty()) {
            return null;
        }
        this.sumOfQueueSizesDequeue += (long)this.queue.size();
        ++this.numDequeued;
        result = this.queue.remove(0);
        return result;
    }

    public Object pop(long timeout) throws InterruptedException {
        if (0L == timeout) {
            timeout = Long.MAX_VALUE;
        }
        long absoluteTimeOut = TimeUtils.toAbsoluteTimeMillis(timeout);
        Object result = null;
        List list = this.queue;
        synchronized (list) {
            while (null == (result = this.pop()) && !this.isClosed() && (timeout = TimeUtils.toRelativeTimeMillis(absoluteTimeOut)) > 0L) {
                this.queue.wait(timeout);
                if (!this.isClosed()) continue;
            }
            this.queue.notify();
        }
        return result;
    }

    public Object[] popMulti(int maxObjs) {
        if (maxObjs <= 0) {
            throw new IllegalArgumentException("maxObjs must be > 0");
        }
        maxObjs = Math.min(maxObjs, this.queue.size());
        Object[] result = new Object[maxObjs];
        int eachElement = 0;
        while (eachElement < maxObjs) {
            this.sumOfQueueSizesDequeue += (long)this.queue.size();
            ++this.numDequeued;
            result[eachElement] = this.queue.remove(0);
            ++eachElement;
        }
        return result;
    }

    public int getMaxQueueSize() {
        return this.maxObjects;
    }

    public void setMaxQueueSize(int maxObjs) {
        this.maxObjects = maxObjs;
    }

    public int getCurrentInQueue() {
        return this.queue.size();
    }

    public long getNumEnqueued() {
        return this.numEnqueued;
    }

    public double getAvgInQueueAtEnqueue() {
        if (this.numEnqueued > 0L) {
            return (double)this.sumOfQueueSizesEnqueue / (double)this.numEnqueued;
        }
        return Double.NaN;
    }

    public long getNumDequeued() {
        return this.numDequeued;
    }

    public double getAvgInQueueAtDequeue() {
        if (this.numDequeued > 0L) {
            return (double)this.sumOfQueueSizesDequeue / (double)this.numDequeued;
        }
        return Double.NaN;
    }

    public long getNumDropped() {
        return this.numDropped;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class SynchronizedQueue
    extends UnbiasedQueue {
        UnbiasedQueue innerqueue;

        public SynchronizedQueue(UnbiasedQueue queue) {
            this.innerqueue = queue;
        }

        public synchronized void clear() {
            this.innerqueue.clear();
        }

        public synchronized boolean push(Object obj, long timeout) throws InterruptedException {
            return this.innerqueue.push(obj, timeout);
        }

        public synchronized Object pop() {
            return this.innerqueue.pop();
        }

        public synchronized Object pop(long timeout) throws InterruptedException {
            return this.innerqueue.pop(timeout);
        }

        public synchronized Object[] popMulti(int maxObjs) {
            return this.innerqueue.popMulti(maxObjs);
        }

        public synchronized int getMaxQueueSize() {
            return this.innerqueue.getMaxQueueSize();
        }

        public synchronized void setMaxQueueSize(int maxObjs) {
            this.innerqueue.setMaxQueueSize(maxObjs);
        }

        public synchronized int getCurrentInQueue() {
            return this.innerqueue.getCurrentInQueue();
        }

        public synchronized long getNumEnqueued() {
            return this.innerqueue.getNumEnqueued();
        }

        public synchronized double getAvgInQueueAtEnqueue() {
            return this.innerqueue.getAvgInQueueAtEnqueue();
        }

        public synchronized long getNumDequeued() {
            return this.innerqueue.getNumDequeued();
        }

        public synchronized double getAvgInQueueAtDequeue() {
            return this.innerqueue.getAvgInQueueAtDequeue();
        }

        public synchronized long getNumDropped() {
            return this.innerqueue.getNumDropped();
        }
    }
}

