/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;

public abstract class PeerInfoResponseMessage {
    private ID spid = ID.nullID;
    private ID tpid = ID.nullID;
    private StructuredDocument response = null;
    private long uptime = 0L;
    private long timestamp = 0L;
    private long lastIncomingMessageTime = 0L;
    private long lastOutgoingMessageTime = 0L;
    private Hashtable incomingTraffic = new Hashtable();
    private Hashtable outgoingTraffic = new Hashtable();

    public static String getMessageType() {
        return "jxta:PeerInfoResponseMessage";
    }

    public ID getSourcePid() {
        return this.spid;
    }

    public void setSourcePid(ID pid) {
        this.spid = pid;
    }

    public ID getTargetPid() {
        return this.tpid;
    }

    public void setTargetPid(ID pid) {
        this.tpid = pid;
    }

    public Element getResponse() {
        if (null != this.response) {
            return StructuredDocumentUtils.copyAsDocument(this.response);
        }
        return null;
    }

    public void setResponse(Element response) {
        this.response = null != response ? StructuredDocumentUtils.copyAsDocument(response) : null;
    }

    public long getUptime() {
        return this.uptime;
    }

    public void setUptime(long milliseconds) {
        this.uptime = milliseconds;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long milliseconds) {
        this.timestamp = milliseconds;
    }

    public long getLastIncomingMessageTime() {
        return this.lastIncomingMessageTime;
    }

    public void setLastIncomingMessageTime(long t) {
        this.lastIncomingMessageTime = t;
    }

    public long getLastOutgoingMessageTime() {
        return this.lastOutgoingMessageTime;
    }

    public void setLastOutgoingMessageTime(long t) {
        this.lastOutgoingMessageTime = t;
    }

    public Enumeration getIncomingTrafficChannels() {
        return this.incomingTraffic.keys();
    }

    public long getIncomingTrafficOnChannel(String channel) {
        Long ret = (Long)this.incomingTraffic.get(channel);
        if (ret != null) {
            return ret;
        }
        return 0L;
    }

    public void setIncomingTrafficElement(String channel, long bytes) {
        this.incomingTraffic.put(channel, new Long(bytes));
    }

    public Enumeration getOutgoingTrafficChannels() {
        return this.outgoingTraffic.keys();
    }

    public long getOutgoingTrafficOnChannel(String channel) {
        Long ret = (Long)this.outgoingTraffic.get(channel);
        if (ret != null) {
            return ret;
        }
        return 0L;
    }

    public void setOutgoingTrafficElement(String channel, long bytes) {
        this.outgoingTraffic.put(channel, new Long(bytes));
    }

    public abstract Document getDocument(MimeMediaType var1);
}

