/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.id.ID;
import net.jxta.peer.PeerID;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PeerAdvertisement;

public abstract class PipeResolverMessage {
    MessageType msgType = null;
    ID pipeid = ID.nullID;
    String pipeType = null;
    boolean cachedLookup = false;
    Vector peerids = new Vector();
    boolean found = true;
    PeerAdvertisement inputPeerAdv = null;

    public static String getMessageType() {
        return "jxta:PipeResolver";
    }

    public MessageType getMsgType() {
        return this.msgType;
    }

    public void setMsgType(MessageType type) {
        this.msgType = type;
    }

    public ID getPipeID() {
        return this.pipeid;
    }

    public void setPipeID(ID id) {
        if (!(id instanceof PipeID)) {
            throw new IllegalArgumentException("can only set to pipe ids.");
        }
        this.pipeid = id;
    }

    public String getPipeType() {
        return this.pipeType;
    }

    public void setPipeType(String type) {
        this.pipeType = type;
    }

    public boolean isCachedLookup() {
        return this.cachedLookup;
    }

    public void setCachedLookup(boolean cacheLookup) {
        this.cachedLookup = cacheLookup;
    }

    public Enumeration getPeerIDs() {
        return this.peerids.elements();
    }

    public void addPeerID(ID id) {
        if (!(id instanceof PeerID)) {
            throw new IllegalArgumentException("can only add peer ids");
        }
        this.peerids.add(id);
    }

    public boolean isFound() {
        return this.found;
    }

    public void setFound(boolean isFound) {
        this.found = isFound;
    }

    public PeerAdvertisement getInputPeerAdv() {
        return this.inputPeerAdv;
    }

    public void setInputPeerAdv(PeerAdvertisement peerAdv) {
        this.inputPeerAdv = peerAdv;
    }

    public abstract Document getDocument(MimeMediaType var1);

    public static class MessageType {
        public static final MessageType QUERY = new MessageType(){

            public String toString() {
                return "Pipe Resolver Query Message";
            }
        };
        public static final MessageType ANSWER = new MessageType(){

            public String toString() {
                return "Pipe Resolver Answer Message";
            }
        };

        private MessageType() {
        }

        public Object clone() {
            return this;
        }

        public boolean equals(Object target) {
            return this == target;
        }
    }
}

