/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.test.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.impl.util.BidirectionalPipeService;
import net.jxta.impl.util.ReliablePipeService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Application;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.test.util.Util;

public class ReliablePipeTestApp
implements Application {
    PeerGroup peerGroup;
    ReliablePipeService rps;

    public void init(PeerGroup peerGroup, ID id, Advertisement adv) {
        this.peerGroup = peerGroup;
        this.rps = new ReliablePipeService(new BidirectionalPipeService(peerGroup));
    }

    public int startApp(String[] argv) {
        String filename = argv == null || argv.length == 0 ? "TestPipe.xml" : argv[0];
        try {
            ReliablePipeService.Pipe pipe = this.rps.connect((PipeAdvertisement)Util.getAdvFromFile(new File(filename)), 30000);
            int i = 0;
            while (i < 1000) {
                Message msg = this.peerGroup.getPipeService().createMessage();
                msg.setBytes("Test", String.valueOf(i).getBytes());
                pipe.getOutputPipe().send(msg);
                ++i;
            }
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void stopApp() {
    }
}

