/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private transient long bytesWritten = 0L;
    private transient boolean alreadycounting = false;

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    public synchronized void write(byte[] b) throws IOException {
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        super.write(b);
        this.alreadycounting = wascounting;
        if (!this.alreadycounting) {
            this.bytesWritten += (long)b.length;
        }
    }

    public synchronized void write(int b) throws IOException {
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        super.write(b);
        this.alreadycounting = wascounting;
        if (!this.alreadycounting) {
            ++this.bytesWritten;
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        super.write(b, off, len);
        this.alreadycounting = wascounting;
        if (!this.alreadycounting) {
            this.bytesWritten += (long)len;
        }
    }

    public synchronized long getBytesWritten() {
        return this.bytesWritten;
    }
}

