/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitInputStream
extends FilterInputStream {
    private transient long limit;
    private transient long read;
    private transient long mark;
    private transient boolean fatalUnderflow;
    private transient boolean alreadycounting;

    public LimitInputStream(InputStream in, long limit) {
        this(in, limit, false);
    }

    public LimitInputStream(InputStream in, long limit, boolean underflowThrows) {
        super(in);
        this.limit = limit;
        this.mark = -1L;
        this.read = 0L;
        this.fatalUnderflow = underflowThrows;
        this.alreadycounting = false;
    }

    public void close() throws IOException {
        super.close();
        this.in = null;
    }

    public int available() throws IOException {
        return (int)Math.min((long)super.available(), this.limit - this.read);
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.read;
    }

    public void reset() throws IOException {
        if (-1L == this.mark) {
            throw new IOException("reset() without mark(), or I dont know where mark is");
        }
        super.reset();
        this.read = this.mark;
    }

    public synchronized long skip(long n) throws IOException {
        long skipLen = Math.min(n, this.limit - this.read);
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        long result = super.skip(skipLen);
        this.alreadycounting = wascounting;
        if (-1L != result && !this.alreadycounting) {
            this.read += result;
        }
        return result;
    }

    public synchronized int read() throws IOException {
        if (this.read >= this.limit) {
            return -1;
        }
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        int result = super.read();
        this.alreadycounting = wascounting;
        if (-1 != result && !this.alreadycounting) {
            ++this.read;
        } else if (this.fatalUnderflow && this.read != this.limit) {
            throw new IOException("Underflow in read, stream EOFed at " + this.read + " before limit of " + this.limit);
        }
        return result;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.read >= this.limit) {
            return -1;
        }
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        int readLen = (int)Math.min((long)len, this.limit - this.read);
        int result = super.read(b, off, readLen);
        this.alreadycounting = wascounting;
        if (-1 != result && !this.alreadycounting) {
            this.read += (long)result;
        } else if (this.fatalUnderflow && this.read != this.limit) {
            throw new IOException("Underflow in read, stream EOFed at " + this.read + " before limit of " + this.limit);
        }
        return result;
    }
}

