/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.urn;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public final class Handler
extends URLStreamHandler {
    public static Handler handler = new Handler();
    static final String needsEncoding = "%/?#\\\"&<>[]^`{|}~";
    static final byte[] encodesTo = new byte[]{37, 47, 63, 35, 92, 34, 38, 60, 62, 91, 93, 94, 96, 123, 124, 125, 126};

    public URLConnection openConnection(URL connect) throws IOException {
        return null;
    }

    private static String toHexDigits(byte theByte) {
        char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer result = new StringBuffer(2);
        result.append(HEXDIGITS[theByte >>> 4 & 0xF]);
        result.append(HEXDIGITS[theByte & 0xF]);
        return result.toString();
    }

    public static String encodeURN(String source) {
        String asISO8559_1 = null;
        try {
            byte[] asBytes = source.getBytes("UTF8");
            asISO8559_1 = new String(asBytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException never) {
            // empty catch block
        }
        StringBuffer result = new StringBuffer(asISO8559_1.length());
        int eachChar = 0;
        while (eachChar < asISO8559_1.length()) {
            char aChar = asISO8559_1.charAt(eachChar);
            if ('\u0000' == aChar) {
                throw new IllegalArgumentException("URN string cannot contain null char");
            }
            if (aChar <= ' ' || aChar >= '\u007f') {
                result.append('%');
                result.append(Handler.toHexDigits((byte)aChar));
            } else {
                int inSpecials = needsEncoding.indexOf(aChar);
                if (-1 != inSpecials) {
                    result.append('%');
                    result.append(Handler.toHexDigits(encodesTo[inSpecials]));
                } else {
                    result.append(aChar);
                }
            }
            ++eachChar;
        }
        return result.toString();
    }

    public static String decodeURN(String source) {
        StringBuffer result = new StringBuffer(source.length());
        int eachChar = 0;
        while (eachChar < source.length()) {
            char aChar = source.charAt(eachChar);
            if ('%' != aChar) {
                result.append(aChar);
            } else {
                String twoChars = source.substring(eachChar + 1, eachChar + 3);
                result.append((char)Integer.parseInt(twoChars, 16));
                eachChar += 2;
            }
            ++eachChar;
        }
        String fromUTF8 = null;
        try {
            byte[] asBytes = result.toString().getBytes("ISO-8859-1");
            fromUTF8 = new String(asBytes, "UTF8");
        }
        catch (UnsupportedEncodingException never) {
            // empty catch block
        }
        return fromUTF8;
    }
}

