/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt8;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Size;
import com.jniwrapper.win32.gdi.BitmapFileHeader;
import com.jniwrapper.win32.gdi.BitmapInfo;
import com.jniwrapper.win32.gdi.BitmapInfoHeader;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.DIBitmap;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.RGBQuad;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilderFactory;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilderFactoryImpl;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class Bitmap
extends GdiObject {
    protected static final BitmapBuilderFactory _builderFactory = new BitmapBuilderFactoryImpl();
    private static final String FUNCTION_CREATE_DIBSECTION = "CreateDIBSection";
    protected static final String FUNCTION_GET_DIBITS = "GetDIBits";
    protected static final String FUNCTION_SET_DIBITS = "SetDIBits";
    protected static final String FUNCTION_CREATEDIBITMAP = "CreateDIBitmap";
    protected static final int DIB_RGB_COLORS = 0;
    protected static final int DIB_PAL_COLORS = 1;
    protected static final int CBM_INIT = 4;
    private Dimension _size;
    private DIBitmap _transparentMask;

    public Bitmap() {
    }

    public Bitmap(long value) {
        super(value);
    }

    public long setDIBits(DC dc, int startScan, int scanLines, Pointer bits, BitmapInfo bitmapInfo, int colorModelType) {
        Int result = new Int();
        Function function = Gdi32.get(FUNCTION_SET_DIBITS);
        function.invoke((Parameter)result, new Parameter[]{dc, this, new UInt((long)startScan), new UInt((long)scanLines), bits, new Pointer((Parameter)bitmapInfo), new UInt((long)colorModelType)});
        return result.getValue();
    }

    public long getDIBits(DC dc, int startScan, int scanLines, Pointer bits, BitmapInfo bitmapInfo, int colorModelType) {
        Int result = new Int();
        Function function = Gdi32.get(FUNCTION_GET_DIBITS);
        function.invoke((Parameter)result, new Parameter[]{dc, this, new UInt((long)startScan), new UInt((long)scanLines), bits, new Pointer((Parameter)bitmapInfo), new UInt((long)colorModelType)});
        return result.getValue();
    }

    protected void setSize(int width, int height) {
        this._size = new Dimension(width, height);
    }

    public Size getSize() {
        return new Size(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        return (int)this._size.getWidth();
    }

    public int getHeight() {
        return (int)this._size.getHeight();
    }

    private int readByte(PrimitiveArray bits, int offset) {
        return (int)((UInt8)bits.getElement(offset)).getValue();
    }

    public void createDIBSection(DIBitmap result, Pointer ppvBits, BitmapInfo bitmapInfo) {
        this.createDIBSection(result, new DC(), bitmapInfo, 0, ppvBits, new Handle(), 0);
    }

    public void createDIBSection(DIBitmap result, DC hdc, BitmapInfo bitmapInfo, int colorModel, Pointer ppvBits, Handle hSection, int dwOffset) {
        Function function = Gdi32.get(FUNCTION_CREATE_DIBSECTION);
        function.invoke((Parameter)result, new Parameter[]{hdc, new Pointer((Parameter)bitmapInfo), new UInt16(colorModel), ppvBits, hSection, new UInt((long)dwOffset)});
    }

    public int getBitCount() {
        return (int)this.getBitmapInfoHeader().getBitCount();
    }

    protected void setTransparentMask(Image transparentMask) {
        this._transparentMask = new DIBitmap(transparentMask);
    }

    public Bitmap getTransparentMask() {
        return this._transparentMask;
    }

    public boolean isTransparent() {
        return this.getBitCount() == 32 || this._transparentMask != null;
    }

    public void deleteObject() {
        super.deleteObject();
        if (this._transparentMask != null) {
            this._transparentMask.deleteObject();
        }
    }

    public BufferedImage toImage() {
        int bitCount = this.getBitCount();
        int width = this.getWidth();
        int height = this.getHeight();
        PrimitiveArray bits = this.getDIBytes();
        BufferedImage result = bitCount >= 4 ? this.transformBitmap(this.getBitmapInfo().getColors(), width, height, bitCount, bits) : this.transformMonochromeBitmap(width, height, bitCount, bits);
        return result;
    }

    private BufferedImage transformMonochromeBitmap(int width, int height, int bitCount, PrimitiveArray bits) {
        int foregroundColor = -16777216;
        BufferedImage result = new BufferedImage(width, height, 2);
        int bitIndex = 0;
        int byteIndex = 0;
        int bytesPerLine = (width * bitCount + 31) / 32 * 4;
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                byteIndex = (height - 1 - y) * bytesPerLine + x * bitCount / 8;
                bitIndex = x * bitCount % 8;
                int byteValue = this.readByte(bits, byteIndex);
                FlagSet bitset = new FlagSet((long)byteValue);
                boolean isSet = bitset.getBit(7 - bitIndex);
                int rgb = !isSet ? foregroundColor : 0;
                result.setRGB(x, y, rgb);
            }
        }
        return result;
    }

    private BufferedImage transformBitmap(PrimitiveArray colors, int width, int height, int bitCount, PrimitiveArray bits) {
        BufferedImage result = new BufferedImage(width, height, 1);
        int index = 0;
        int bitIndex = 0;
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                int rgb = 0;
                switch (bitCount) {
                    case 4: {
                        index = bitIndex / 8;
                        int byte1 = this.readByte(bits, index);
                        byte1 = bitIndex % 8 != 0 ? (byte1 &= 0xF) : (byte1 >>= 4);
                        RGBQuad color = (RGBQuad)colors.getElement(byte1);
                        bitIndex += 4;
                        rgb = color.getRGB();
                        break;
                    }
                    case 8: {
                        int byte1 = this.readByte(bits, index++);
                        RGBQuad color = (RGBQuad)colors.getElement(byte1);
                        rgb = color.getRGB();
                        break;
                    }
                    case 16: {
                        int byte1 = this.readByte(bits, index++);
                        int byte2 = this.readByte(bits, index++);
                        int word = byte2 << 8 | byte1;
                        int b = (word & 0x1F) << 3;
                        int g = (word & 0x3E0) << 6;
                        int r = (word & 0x7C00) << 9;
                        rgb = b | g | r;
                        break;
                    }
                    case 24: 
                    case 32: {
                        int alpha;
                        int b = this.readByte(bits, index++);
                        int g = this.readByte(bits, index++);
                        int r = this.readByte(bits, index++);
                        rgb = b | g << 8 | r << 16;
                        if (bitCount != 32) break;
                        if ((alpha = this.readByte(bits, index++)) == 0) {
                            alpha = 255;
                        }
                        rgb |= alpha << 24;
                    }
                }
                result.setRGB(x, y, rgb);
            }
            if (bitCount != 4) {
                int extrabytes = (int)(4.0 * (Math.ceil((double)(width * bitCount) / 32.0) - (double)(width * bitCount) / 32.0));
                index += extrabytes;
                continue;
            }
            double extrabytes = 4.0 * (Math.ceil((double)(width * bitCount) / 32.0) - (double)(width * bitCount) / 32.0);
            bitIndex += (int)(extrabytes * 8.0);
        }
        return result;
    }

    public void saveToFile(String fileName) throws IOException {
        if (this.isNull()) {
            throw new RuntimeException("No bitmap was specified.");
        }
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        BitmapFileHeader fileHeader = new BitmapFileHeader();
        BitmapInfoHeader infoHeader = this.getBitmapInfo().getBitmapInfoHeader();
        PrimitiveArray rgbHeader = this.getBitmapInfo().getColors();
        FileOutputStream out = new FileOutputStream(file);
        if (infoHeader.getBitCount() == 1L) {
            rgbHeader = new PrimitiveArray(new Parameter[]{new RGBQuad(0, 0, 0), new RGBQuad(255, 255, 255)});
        }
        fileHeader.setOffBits(fileHeader.getLength() + infoHeader.getLength() + rgbHeader.getLength());
        fileHeader.setSize(fileHeader.getLength() + infoHeader.getLength() + rgbHeader.getLength() + this.getDIBytes().getLength());
        ((OutputStream)out).write(BitmapFileHeader.toByteArray((Parameter)fileHeader));
        ((OutputStream)out).write(BitmapFileHeader.toByteArray((Parameter)infoHeader));
        ((OutputStream)out).write(BitmapFileHeader.toByteArray((Parameter)rgbHeader));
        ((OutputStream)out).write(BitmapFileHeader.toByteArray((Parameter)this.getDIBytes()));
        ((OutputStream)out).close();
    }

    public abstract BitmapInfoHeader getBitmapInfoHeader();

    public abstract BitmapInfo getBitmapInfo();

    public abstract void loadFromFile(String var1);

    public abstract PrimitiveArray getDIBytes();

    public abstract void setDIBytes(PrimitiveArray var1);

    public static class PredefinedBitmap
    extends EnumItem {
        public static final PredefinedBitmap BTNCORNERS = new PredefinedBitmap(32758);
        public static final PredefinedBitmap BTSIZE = new PredefinedBitmap(32761);
        public static final PredefinedBitmap CHECK = new PredefinedBitmap(32760);
        public static final PredefinedBitmap CHECKBOXES = new PredefinedBitmap(32759);
        public static final PredefinedBitmap CLOSE = new PredefinedBitmap(32754);
        public static final PredefinedBitmap COMBO = new PredefinedBitmap(32738);
        public static final PredefinedBitmap DNARROW = new PredefinedBitmap(32752);
        public static final PredefinedBitmap DNARROWD = new PredefinedBitmap(32742);
        public static final PredefinedBitmap DNARROWI = new PredefinedBitmap(32736);
        public static final PredefinedBitmap LFARROW = new PredefinedBitmap(32750);
        public static final PredefinedBitmap LFARROWD = new PredefinedBitmap(32740);
        public static final PredefinedBitmap LFARROWI = new PredefinedBitmap(32734);
        public static final PredefinedBitmap MNARROW = new PredefinedBitmap(32739);
        public static final PredefinedBitmap REDUCE = new PredefinedBitmap(32749);
        public static final PredefinedBitmap REDUCED = new PredefinedBitmap(32746);
        public static final PredefinedBitmap RESTORE = new PredefinedBitmap(32747);
        public static final PredefinedBitmap RESTORED = new PredefinedBitmap(32744);
        public static final PredefinedBitmap RGARROW = new PredefinedBitmap(32751);
        public static final PredefinedBitmap RGARROWD = new PredefinedBitmap(32741);
        public static final PredefinedBitmap RGARROWI = new PredefinedBitmap(32735);
        public static final PredefinedBitmap SIZE = new PredefinedBitmap(32766);
        public static final PredefinedBitmap UPARROW = new PredefinedBitmap(32753);
        public static final PredefinedBitmap UPARROWD = new PredefinedBitmap(32743);
        public static final PredefinedBitmap UPARROWI = new PredefinedBitmap(32737);
        public static final PredefinedBitmap ZOOM = new PredefinedBitmap(32748);
        public static final PredefinedBitmap ZOOMD = new PredefinedBitmap(32745);

        private PredefinedBitmap(int value) {
            super(value);
        }
    }

    public static class Compression
    extends EnumItem {
        public static final Compression RGB = new Compression(0);
        public static final Compression RLE8 = new Compression(1);
        public static final Compression RLE4 = new Compression(2);
        public static final Compression BITFIELDS = new Compression(3);
        public static final Compression JPEG = new Compression(4);
        public static final Compression PNG = new Compression(5);

        protected Compression(int value) {
            super(value);
        }
    }
}

