/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.transform.SourceLocator;

public class TransformerException
extends Exception {
    SourceLocator locator;
    Throwable containedException;

    public TransformerException(String message) {
        super(message);
        this.containedException = null;
        this.locator = null;
    }

    public TransformerException(String message, Throwable e) {
        super(message == null || message.length() == 0 ? e.toString() : message);
        this.containedException = e;
        this.locator = null;
    }

    public TransformerException(String message, SourceLocator locator) {
        super(message);
        this.containedException = null;
        this.locator = locator;
    }

    public TransformerException(String message, SourceLocator locator, Throwable e) {
        super(message);
        this.containedException = e;
        this.locator = locator;
    }

    public TransformerException(Throwable e) {
        super(e.toString());
        this.containedException = e;
        this.locator = null;
    }

    public Throwable getCause() {
        return this.containedException == this ? null : this.containedException;
    }

    public Throwable getException() {
        return this.containedException;
    }

    public String getLocationAsString() {
        if (this.locator != null) {
            StringBuffer sbuffer = new StringBuffer();
            String systemID = this.locator.getSystemId();
            int line = this.locator.getLineNumber();
            int column = this.locator.getColumnNumber();
            if (systemID != null) {
                sbuffer.append("; SystemID: ");
                sbuffer.append(systemID);
            }
            if (line != 0) {
                sbuffer.append("; Line#: ");
                sbuffer.append(line);
            }
            if (column != 0) {
                sbuffer.append("; Column#: ");
                sbuffer.append(column);
            }
            return sbuffer.toString();
        }
        return null;
    }

    public SourceLocator getLocator() {
        return this.locator;
    }

    public String getMessageAndLocation() {
        StringBuffer sbuffer = new StringBuffer();
        String message = super.getMessage();
        if (message != null) {
            sbuffer.append(message);
        }
        if (this.locator != null) {
            String systemID = this.locator.getSystemId();
            int line = this.locator.getLineNumber();
            int column = this.locator.getColumnNumber();
            if (systemID != null) {
                sbuffer.append("; SystemID: ");
                sbuffer.append(systemID);
            }
            if (line != 0) {
                sbuffer.append("; Line#: ");
                sbuffer.append(line);
            }
            if (column != 0) {
                sbuffer.append("; Column#: ");
                sbuffer.append(column);
            }
        }
        return sbuffer.toString();
    }

    public synchronized Throwable initCause(Throwable cause) {
        if (this.containedException != null) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (cause == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.containedException = cause;
        return this;
    }

    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err, true));
    }

    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new PrintWriter(s));
    }

    public void printStackTrace(PrintWriter s) {
        if (s == null) {
            s = new PrintWriter(System.err, true);
        }
        try {
            String locInfo = this.getLocationAsString();
            if (locInfo != null) {
                s.println(locInfo);
            }
            super.printStackTrace(s);
        }
        catch (Throwable throwable) {}
        Throwable exception = this.getException();
        int i = 0;
        while (i < 10 && exception != null) {
            s.println("---------");
            try {
                String locInfo;
                if (exception instanceof TransformerException && (locInfo = ((TransformerException)exception).getLocationAsString()) != null) {
                    s.println(locInfo);
                }
                exception.printStackTrace(s);
            }
            catch (Throwable throwable) {
                s.println("Could not print stack trace...");
            }
            try {
                Method meth = exception.getClass().getMethod("getException", null);
                if (meth != null) {
                    Throwable prev = exception;
                    if (prev == (exception = (Throwable)meth.invoke((Object)exception, null))) {
                        break;
                    }
                } else {
                    exception = null;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                exception = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                exception = null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                exception = null;
            }
            ++i;
        }
        s.flush();
    }

    public void setLocator(SourceLocator location) {
        this.locator = location;
    }
}

