/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.sampled.AudioFileFormat;
import com.sun.jmfsound.sampled.AudioFormat;

class AuFileFormat
extends AudioFileFormat {
    static final int AU_SUN_MAGIC = 779316836;
    static final int AU_SUN_INV_MAGIC = 1684960046;
    static final int AU_DEC_MAGIC = 779314176;
    static final int AU_DEC_INV_MAGIC = 6583086;
    static final int AU_ULAW_8 = 1;
    static final int AU_LINEAR_8 = 2;
    static final int AU_LINEAR_16 = 3;
    static final int AU_LINEAR_24 = 4;
    static final int AU_LINEAR_32 = 5;
    static final int AU_FLOAT = 6;
    static final int AU_DOUBLE = 7;
    static final int AU_ADPCM_G721 = 23;
    static final int AU_ADPCM_G722 = 24;
    static final int AU_ADPCM_G723_3 = 25;
    static final int AU_ADPCM_G723_5 = 26;
    static final int AU_ALAW_8 = 27;
    static final int AU_HEADERSIZE = 24;
    int auType;

    AuFileFormat(AudioFileFormat aff) {
        this(aff.getType(), aff.getByteLength(), aff.getFormat(), aff.getFrameLength());
    }

    AuFileFormat(AudioFileFormat.Type type, int lengthInBytes, AudioFormat format, int lengthInFrames) {
        super(type, lengthInBytes, format, lengthInFrames);
        AudioFormat.Encoding encoding = format.getEncoding();
        this.auType = -1;
        if (encoding == AudioFormat.Encoding.ALAW) {
            if (format.getSampleSizeInBits() == 8) {
                this.auType = 27;
            }
        } else if (encoding == AudioFormat.Encoding.ULAW) {
            if (format.getSampleSizeInBits() == 8) {
                this.auType = 1;
            }
        } else if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
            if (format.getSampleSizeInBits() == 8) {
                this.auType = 2;
            } else if (format.getSampleSizeInBits() == 16) {
                this.auType = 3;
            } else if (format.getSampleSizeInBits() == 24) {
                this.auType = 4;
            } else if (format.getSampleSizeInBits() == 32) {
                this.auType = 5;
            }
        }
    }

    public int getAuType() {
        return this.auType;
    }
}

