/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.AbstractDataLine;
import com.sun.jmfsound.imp.HeadspaceMixer;
import com.sun.jmfsound.imp.Platform;
import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.imp.Toolkit;
import com.sun.jmfsound.sampled.AudioFormat;
import com.sun.jmfsound.sampled.AudioInputStream;
import com.sun.jmfsound.sampled.BooleanControl;
import com.sun.jmfsound.sampled.Clip;
import com.sun.jmfsound.sampled.Control;
import com.sun.jmfsound.sampled.DataLine;
import com.sun.jmfsound.sampled.FloatControl;
import com.sun.jmfsound.sampled.LineUnavailableException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MixerClip
extends AbstractDataLine
implements Clip {
    private int id;
    private int waveformId;
    private int frameLength = -1;
    private long microsecondLength = -1L;
    int position = 0;
    int loopCount = 0;
    int currentLoop = 0;
    int loopStart;
    int loopEnd;
    private boolean resettingFramePosition = false;
    private boolean stopping = false;
    MixerClipSampleRateControl rateControl;
    MixerClipGainControl gainControl;
    MixerClipMuteControl muteControl;
    MixerClipPanControl panControl;
    MixerClipApplyReverbControl applyReverbControl;

    MixerClip(DataLine.Info info, HeadspaceMixer mixer, AudioFormat format, int bufferSize) throws LineUnavailableException {
        super(info, mixer, new Control[5], format, bufferSize);
        if (Printer.trace) {
            Printer.trace("> MixerClip: constructor: format: " + format + " bufferSize: " + bufferSize);
        }
        this.gainControl = new MixerClipGainControl();
        this.controls[0] = this.gainControl;
        this.muteControl = new MixerClipMuteControl();
        this.controls[1] = this.muteControl;
        this.panControl = new MixerClipPanControl();
        this.controls[2] = this.panControl;
        this.rateControl = new MixerClipSampleRateControl();
        this.controls[3] = this.rateControl;
        this.applyReverbControl = new MixerClipApplyReverbControl();
        this.controls[4] = this.applyReverbControl;
        if (Printer.trace) {
            Printer.trace("< MixerClip: constructor completed");
        }
    }

    public synchronized void open(AudioFormat format, byte[] data, int offset, int bufferSize) throws LineUnavailableException {
        if (!this.isOpen()) {
            this.mixer.open(this, format, bufferSize);
            try {
                this.implOpen(format, data, offset, bufferSize);
                this.setOpen(true);
            }
            catch (LineUnavailableException e) {
                this.mixer.close(this);
                throw e;
            }
        } else {
            throw new IllegalStateException("Line is already open with " + this.getBufferSize() + " bytes of " + this.getFormat() + " data");
        }
    }

    public void open(AudioInputStream stream) throws LineUnavailableException, IOException {
        byte[] streamData;
        int lengthInFrames = (int)stream.getFrameLength();
        int lengthInBytes = lengthInFrames * stream.getFormat().getFrameSize();
        if (Printer.debug) {
            Printer.debug("HeadspaceMixer: getClip: lengthInFrames: " + lengthInFrames);
        }
        if (lengthInFrames != -1) {
            streamData = new byte[lengthInBytes];
            int bytesRemaining = lengthInBytes;
            int bytesRead = 0;
            while (bytesRemaining > 0) {
                int temp = stream.read(streamData, bytesRead, bytesRemaining);
                if (temp > 0) {
                    bytesRead += temp;
                    bytesRemaining -= temp;
                    continue;
                }
                if (temp != 0) break;
                Thread.yield();
            }
            if (bytesRead != lengthInBytes) {
                lengthInBytes = bytesRead;
                lengthInFrames = bytesRead / stream.getFormat().getFrameSize();
            }
        } else {
            lengthInBytes = 0;
            int bytesRead = 0;
            int MAX_READ_LIMIT = 2048;
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(ba);
            byte[] tmp = new byte[MAX_READ_LIMIT];
            while (true) {
                if ((bytesRead = stream.read(tmp, 0, tmp.length)) == -1) {
                    if (lengthInBytes != 0) break;
                    throw new IOException("No data found in stream");
                }
                dos.write(tmp, 0, bytesRead);
                lengthInBytes += bytesRead;
                Thread.currentThread();
                Thread.yield();
            }
            streamData = ba.toByteArray();
            lengthInFrames = streamData.length / stream.getFormat().getFrameSize();
            if (Printer.debug) {
                Printer.debug("Read to end of stream.  lengthInBytes: " + lengthInBytes + " streamData.length: " + streamData.length + " lengthInFrames: " + lengthInFrames);
            }
        }
        this.open(stream.getFormat(), streamData, 0, streamData.length);
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public long getMicrosecondLength() {
        return this.microsecondLength;
    }

    public synchronized void setFramePosition(int frames) {
        if (Printer.trace) {
            Printer.trace("> MixerClip: setFramePosition: " + frames);
        }
        int lengthInFrames = this.bufferSize / this.format.getFrameSize();
        if (Printer.debug) {
            Printer.debug("    MixerClip: bufferSize: " + this.bufferSize + " lengthInFrames: " + lengthInFrames);
        }
        if (Printer.debug) {
            Printer.debug("    getFramePosition(): " + this.getFramePosition());
        }
        if (!this.isStartedRunning() && frames == this.position) {
            return;
        }
        this.resettingFramePosition = true;
        boolean wasRunning = this.isStartedRunning();
        if (this.id != 0) {
            this.implStop();
        }
        if (frames < 0) {
            frames = 0;
        } else if (frames > lengthInFrames) {
            frames = lengthInFrames;
        }
        this.position = frames;
        if (this.loopStart < this.position) {
            if (Printer.debug) {
                Printer.debug("Adjusting loopStart to new position value " + this.position);
            }
            this.loopStart = this.position;
        }
        if (this.loopEnd < this.position) {
            if (Printer.debug) {
                Printer.debug("Adjusting loopEnd to end of sample " + lengthInFrames);
            }
            this.loopStart = lengthInFrames;
        }
        if (wasRunning) {
            this.implStart();
        }
        this.resettingFramePosition = false;
        if (Printer.trace) {
            Printer.trace("< MixerClip: setFramePosition: set position to " + this.position);
        }
    }

    public synchronized void setMicrosecondPosition(long microseconds) {
        if (Printer.trace) {
            Printer.trace("> MixerClip: setMicrosecondPosition: " + microseconds);
        }
        int frames = (int)((double)((float)microseconds * this.getFormat().getFrameRate()) / 1000000.0);
        if (Printer.debug) {
            Printer.debug("    frame rate: " + this.format.getFrameRate());
        }
        if (Printer.debug) {
            Printer.debug("    frames: " + frames);
        }
        this.setFramePosition(frames);
    }

    public void setLoopPoints(int start, int end) {
        if (Printer.trace) {
            Printer.trace("> MixerClip: setLoopPoints: start: " + start + " end: " + end);
        }
        int lengthInFrames = this.bufferSize / this.format.getFrameSize();
        if (Printer.debug) {
            Printer.debug("    > MixerClip: setLoopPoints: lengthInFrames: " + lengthInFrames);
        }
        if (start < 0) {
            start = 0;
        }
        if (end > lengthInFrames) {
            end = lengthInFrames;
        }
        if (end < start) {
            throw new IllegalArgumentException("End position " + end + "  preceeds start position " + start);
        }
        if (start < this.position) {
            if (Printer.debug) {
                Printer.debug("Adjusting start to new position value " + this.position);
            }
            start = this.position;
        }
        if (end < this.position) {
            if (Printer.debug) {
                Printer.debug("Adjusting end to end of sample " + lengthInFrames);
            }
            end = lengthInFrames;
        }
        this.loopStart = start;
        this.loopEnd = end;
        if (Printer.trace) {
            Printer.trace("< MixerClip: setLoopPoints completed: loopStart: " + this.loopStart + " loopEnd: " + this.loopEnd);
        }
    }

    public void loop(int count) {
        if (count != 0) {
            this.stop();
        }
        this.loopCount = count;
        this.start();
    }

    void implOpen(AudioFormat format, int bufferSize) throws LineUnavailableException {
        throw new IllegalArgumentException("This method should not have been invoked!");
    }

    void implOpen(AudioFormat format, byte[] data, int offset, int lengthInBytes) throws LineUnavailableException {
        this.rateControl.update(format.getFrameRate());
        boolean convertSign = false;
        boolean convertByteOrder = false;
        if (format.getSampleSizeInBits() == 8 && format.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            convertSign = true;
        }
        if (format.getSampleSizeInBits() > 8 && format.isBigEndian() != Platform.isBigEndian()) {
            convertByteOrder = true;
        }
        if (convertSign) {
            Toolkit.getUnsigned8(data, offset, lengthInBytes);
        } else if (convertByteOrder) {
            Toolkit.getByteSwapped(data, offset, lengthInBytes);
        }
        int lengthInFrames = lengthInBytes / format.getFrameSize();
        HeadspaceMixer cfr_ignored_0 = (HeadspaceMixer)this.mixer;
        if (lengthInFrames > 0x100000) {
            throw new LineUnavailableException("Failed to allocate clip data: Requested buffer too large.");
        }
        this.waveformId = this.nOpen(format.getSampleSizeInBits(), format.getChannels(), format.getSampleRate(), data, offset, lengthInFrames);
        if (this.waveformId == 0) {
            throw new LineUnavailableException("Failed to allocate clip data.");
        }
        this.format = format;
        this.bufferSize = lengthInBytes;
        this.frameLength = this.bufferSize / format.getFrameSize();
        this.microsecondLength = (long)((float)this.frameLength / format.getFrameRate());
        this.loopStart = 0;
        this.loopEnd = lengthInFrames;
        this.position = 0;
        this.id = this.getValidVoiceId();
    }

    synchronized int getValidVoiceId() throws LineUnavailableException {
        int currentRate;
        float currentPan;
        if (this.id != 0) {
            return this.id;
        }
        float currentGain = this.muteControl.getValue() ? 0.0f : Toolkit.dBToLinear(this.gainControl.getValue());
        int newId = this.nSetup(this.waveformId, this.position, this.loopStart, this.loopEnd, currentGain, (currentPan = this.panControl.getValue()) * -1.0f, currentRate = (int)this.rateControl.getValue());
        if (newId == 0) {
            throw new LineUnavailableException("Failed to allocate sample voice");
        }
        return newId;
    }

    void implClose() {
        this.nClose(this.id, this.waveformId);
        this.id = 0;
        this.waveformId = 0;
    }

    void implStart() {
        block5: {
            int lengthInFrames = this.bufferSize / this.format.getFrameSize();
            if (this.position >= lengthInFrames) {
                if (Printer.debug) {
                    Printer.debug("MixerClip: implStart: already at end of sample; returning.");
                }
                return;
            }
            try {
                this.id = this.getValidVoiceId();
                if (this.nStart(this.id)) {
                    this.setActive(true);
                    this.setStarted(true);
                }
            }
            catch (LineUnavailableException e) {
                if (!Printer.err) break block5;
                Printer.err("ERROR: LineUnavailableException in implStart: " + e);
            }
        }
    }

    void implStop() {
        if (Printer.debug) {
            Printer.debug("> MixerClip: implStop: id: " + this.id);
        }
        this.position = this.getFramePosition();
        this.loopCount = 0;
        this.currentLoop = 0;
        this.stopping = true;
        this.nStop(this.id);
        while (this.id != 0) {
            MixerClip mixerClip = this;
            synchronized (mixerClip) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.stopping = false;
        this.setStarted(false);
        if (Printer.debug) {
            Printer.debug("< MixerClip: implStop: id: " + this.id + " position: " + this.position);
        }
    }

    public int getFramePosition() {
        return this.id != 0 ? this.position + (int)this.nGetPosition(this.id) : this.position;
    }

    boolean callbackSampleLoop() {
        boolean keepLooping;
        if (Printer.trace) {
            Printer.trace(">> MixerClip: callbackSampleLoop()");
        }
        boolean bl = keepLooping = this.loopCount == -1 || this.currentLoop < this.loopCount;
        if (Printer.debug) {
            Printer.debug("currentLoop: " + this.currentLoop + " loopCount: " + this.loopCount + " keepLooping: " + keepLooping);
        }
        ++this.currentLoop;
        if (!keepLooping) {
            this.loopCount = 0;
            this.currentLoop = 0;
        }
        if (Printer.trace) {
            Printer.trace("<< MixerClip: callbackSampleLoop() returning: " + keepLooping);
        }
        return keepLooping;
    }

    void callbackSampleEnd() {
        if (Printer.trace) {
            Printer.trace(">> MixerClip: callbackSampleEnd()");
        }
        this.id = 0;
        if (!this.resettingFramePosition) {
            this.setActive(false);
            if (!this.stopping) {
                this.setEOM();
            }
        }
        if (Printer.trace) {
            Printer.trace("<< MixerClip: callbackSampleEnd() completed");
        }
    }

    private native boolean nStart(int var1);

    private native int nSetup(int var1, int var2, int var3, int var4, float var5, float var6, int var7) throws LineUnavailableException, IllegalArgumentException;

    private native void nDrain(int var1);

    private native void nFlush(int var1);

    private native long nGetPosition(int var1);

    private native float nGetLevel(int var1);

    private native int nOpen(int var1, int var2, float var3, byte[] var4, int var5, int var6) throws LineUnavailableException;

    private native void nClose(int var1, int var2);

    private native void nStop(int var1);

    protected native float nSetLinearGain(int var1, float var2);

    protected native float nSetPan(int var1, float var2);

    protected native int nSetSampleRate(int var1, int var2);

    private class MixerClipApplyReverbControl
    extends BooleanControl {
        private MixerClipApplyReverbControl() {
            super(BooleanControl.Type.APPLY_REVERB, false, "Yes", "No");
        }

        public void setValue(boolean newValue) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            if (newValue == this.getValue() || MixerClip.this.id != 0) {
                // empty if block
            }
            super.setValue(newValue);
        }
    }

    private class MixerClipMuteControl
    extends BooleanControl {
        private MixerClipMuteControl() {
            super(BooleanControl.Type.MUTE, false, "Mute", "Not Mute");
        }

        public void setValue(boolean newValue) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            if (newValue && !this.getValue() && MixerClip.this.id != 0) {
                MixerClip.this.nSetLinearGain(MixerClip.this.id, 0.0f);
            } else if (!newValue && this.getValue() && MixerClip.this.id != 0) {
                float linearGain = Toolkit.dBToLinear(MixerClip.this.gainControl.getValue());
                MixerClip.this.nSetLinearGain(MixerClip.this.id, linearGain);
            }
            super.setValue(newValue);
        }
    }

    private class MixerClipSampleRateControl
    extends FloatControl {
        private MixerClipSampleRateControl() {
            super(FloatControl.Type.SAMPLE_RATE, 0.0f, 48000.0f, 1.0f, -1, MixerClip.this.getFormat().getFrameRate(), "FPS", "Minimum", "", "Maximum");
        }

        public void setValue(float newValue) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            newValue = Math.min(newValue, this.getMaximum());
            if ((newValue = Math.max(newValue, this.getMinimum())) != this.getValue() && MixerClip.this.id != 0) {
                newValue = MixerClip.this.nSetSampleRate(MixerClip.this.id, (int)newValue);
            }
            super.setValue(newValue);
        }

        private void update(float frameRate) {
            super.setValue(frameRate);
        }
    }

    private class MixerClipPanControl
    extends FloatControl {
        private MixerClipPanControl() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.015625f, -1, 0.0f, "", "Left", "Center", "Right");
        }

        public void setValue(float newValue) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            newValue = Math.min(newValue, this.getMaximum());
            if ((newValue = Math.max(newValue, this.getMinimum())) != this.getValue() && MixerClip.this.id != 0) {
                newValue = -1.0f * MixerClip.this.nSetPan(MixerClip.this.id, -1.0f * newValue);
            }
            super.setValue(newValue);
        }
    }

    private class MixerClipGainControl
    extends FloatControl {
        private float linearGain = 1.0f;

        private MixerClipGainControl() {
            super(FloatControl.Type.MASTER_GAIN, Toolkit.linearToDB(0.0f), Toolkit.linearToDB(5.0f), Toolkit.linearToDB(0.0078125f), -1, 0.0f, "dB", "Minimum", "", "Maximum");
        }

        public void setValue(float newValue) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            newValue = Math.min(newValue, this.getMaximum());
            float newLinearGain = Toolkit.dBToLinear(newValue = Math.max(newValue, this.getMinimum()));
            if (newLinearGain != this.linearGain && MixerClip.this.id != 0) {
                newLinearGain = MixerClip.this.nSetLinearGain(MixerClip.this.id, newLinearGain);
            }
            this.linearGain = newLinearGain;
            super.setValue(Toolkit.linearToDB(this.linearGain));
        }
    }
}

