/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.AbstractDataLine;
import com.sun.jmfsound.imp.CircularBuffer;
import com.sun.jmfsound.imp.HeadspaceMixer;
import com.sun.jmfsound.imp.Platform;
import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.imp.Toolkit;
import com.sun.jmfsound.sampled.AudioFormat;
import com.sun.jmfsound.sampled.BooleanControl;
import com.sun.jmfsound.sampled.Control;
import com.sun.jmfsound.sampled.DataLine;
import com.sun.jmfsound.sampled.FloatControl;
import com.sun.jmfsound.sampled.LineUnavailableException;
import com.sun.jmfsound.sampled.SourceDataLine;

public class MixerSourceLine
extends AbstractDataLine
implements SourceDataLine {
    private CircularBuffer circularBuffer = null;
    private byte[] dataBuffer = null;
    private int id;
    private int finalPosition = 0;
    private boolean implStarted = false;
    MixerSourceLineGainControl gainControl;

    MixerSourceLine(DataLine.Info info, HeadspaceMixer mixer, AudioFormat format, int bufferSize) throws LineUnavailableException {
        super(info, mixer, new Control[5], format, bufferSize);
        if (Printer.trace) {
            Printer.trace("MixerSourceLine: constructor: format: " + format + " bufferSize: " + bufferSize);
        }
        this.gainControl = new MixerSourceLineGainControl();
        this.controls[0] = this.gainControl;
        this.controls[1] = new MixerSourceLineMuteControl();
        this.controls[2] = new MixerSourceLinePanControl();
        this.controls[3] = new MixerSourceLineSampleRateControl();
        this.controls[4] = new MixerSourceLineApplyReverbControl();
    }

    public int write(byte[] b, int off, int len) {
        if (b == null) {
            if (Printer.verbose) {
                Printer.verbose("> MixerSourceLine.write: b: " + b);
            }
            this.circularBuffer.markEnd();
            return 0;
        }
        if (Printer.verbose) {
            Printer.verbose("> MixerSourceLine.write(b.length: " + b.length + " off: " + off + " len: " + len);
        }
        int totalBytesToWrite = len;
        if (len % this.getFormat().getFrameSize() != 0) {
            throw new IllegalArgumentException("Illegal request to write non-integral number of frames (" + len + " bytes )");
        }
        int totalBytesWritten = 0;
        int currentBytesWritten = 0;
        while (this.isOpen() && this.isStartedRunning() && totalBytesWritten < totalBytesToWrite) {
            currentBytesWritten = this.circularBuffer.write(b, off, totalBytesToWrite - totalBytesWritten);
            off += currentBytesWritten;
            if ((totalBytesWritten += currentBytesWritten) >= totalBytesToWrite) continue;
            MixerSourceLine mixerSourceLine = this;
            synchronized (mixerSourceLine) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (Printer.trace) {
            Printer.trace("< MixerSourceLine.write write: " + totalBytesWritten + " bytes or " + totalBytesWritten / this.getFormat().getFrameSize() + " frames");
        }
        return totalBytesWritten;
    }

    public int available() {
        return this.circularBuffer.bytesAvailableToWrite();
    }

    synchronized void implOpen(AudioFormat format, int bufferSize) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: implOpen");
        }
        if (format.getSampleRate() == -1.0f) {
            format = new AudioFormat(format.getEncoding(), this.mixer.getFormat().getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), format.getFrameSize(), format.getFrameRate(), format.isBigEndian());
        }
        if (bufferSize == -1) {
            bufferSize = MixerSourceLine.calculateBufferSizeInBytes(format);
        }
        HeadspaceMixer cfr_ignored_0 = (HeadspaceMixer)this.mixer;
        int maxBufferSize = 0x100000 * format.getFrameSize() * 2;
        while (bufferSize > maxBufferSize) {
            bufferSize /= 2;
        }
        boolean convertSign = false;
        boolean convertByteOrder = false;
        if (this.getFormat().getSampleSizeInBits() == 8 && this.getFormat().getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            convertSign = true;
        }
        if (this.getFormat().getSampleSizeInBits() > 8 && this.getFormat().isBigEndian() != Platform.isBigEndian()) {
            convertByteOrder = true;
        }
        if (this.circularBuffer == null || this.circularBuffer.getByteLength() != bufferSize) {
            this.circularBuffer = new CircularBuffer(bufferSize, convertSign, convertByteOrder);
        }
        if (this.dataBuffer == null || this.dataBuffer.length != bufferSize) {
            this.dataBuffer = new byte[bufferSize];
        }
        this.id = this.nOpen(this.getFormat().getSampleSizeInBits(), this.getFormat().getChannels(), this.getFormat().getSampleRate(), bufferSize);
        this.format = format;
        this.bufferSize = bufferSize;
        if (this.id == 0) {
            throw new LineUnavailableException("Failed to allocate native stream.");
        }
        if (Printer.debug) {
            Printer.debug("MixerSourceLine: constructor: id = " + this.id);
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: implOpen succeeded");
        }
    }

    synchronized void implClose() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: implClose");
        }
        this.nClose(this.id);
        while (this.id != 0) {
            MixerSourceLine mixerSourceLine = this;
            synchronized (mixerSourceLine) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: implClose succeeded");
        }
    }

    void implStart() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: implStart");
        }
        if (!this.implStarted) {
            if (Printer.debug) {
                Printer.debug("MixerSourceLine: implStart: starting the stream");
            }
            this.nStart(this.id);
            this.implStarted = true;
        } else {
            if (Printer.debug) {
                Printer.debug("MixerSourceLine: implStart: resuming the stream");
            }
            this.nResume(this.id);
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: implStart succeeded");
        }
    }

    void implStop() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: implStop");
        }
        this.nPause(this.id);
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: implStop succeeded");
        }
    }

    public float getLevel() {
        return this.id != 0 ? this.nGetLevel(this.id) : -1.0f;
    }

    public void drain() {
        this.circularBuffer.drain();
        while (this.isActive()) {
            MixerSourceLine mixerSourceLine = this;
            synchronized (mixerSourceLine) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void flush() {
        this.circularBuffer.flush();
        this.nFlush(this.id);
    }

    public int getFramePosition() {
        return this.id != 0 ? (int)this.nGetPosition(this.id) : this.finalPosition;
    }

    int getId() {
        return this.id;
    }

    private static int calculateBufferSizeInBytes(AudioFormat format) {
        int requestedBufferSizeInFrames = (int)format.getFrameRate() / 2;
        int actualBufferSizeInFrames = 1;
        while (requestedBufferSizeInFrames > actualBufferSizeInFrames) {
            actualBufferSizeInFrames *= 2;
        }
        return actualBufferSizeInFrames * format.getFrameSize();
    }

    private synchronized int callbackStreamGetData(byte[] dataArray, int frameLength) {
        if (Printer.verbose) {
            Printer.verbose("MixerSourceLine: callbackStreamGetData: dataArray.length: " + dataArray.length + " frameLength: " + frameLength);
        }
        int frameSize = this.getFormat().getFrameSize();
        int byteLength = frameLength * frameSize;
        int length = this.circularBuffer.read(dataArray, 0, byteLength = Math.min(byteLength, dataArray.length));
        length = length > 0 ? length / frameSize : length;
        this.notifyAll();
        if (Printer.verbose) {
            Printer.verbose("MixerSourceLine: callbackStreamGetData: returning length: " + length);
        }
        return length;
    }

    private void callbackStreamDestroy() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: callbackStreamDestroy()");
        }
        this.finalPosition = this.getFramePosition();
        this.id = 0;
        MixerSourceLine mixerSourceLine = this;
        synchronized (mixerSourceLine) {
            this.notifyAll();
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: callbackStreamDestroy() completed");
        }
    }

    private void callbackStreamStart() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: callbackStreamStart()");
        }
        this.setActive(true);
        this.setStarted(true);
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: callbackStreamStart() completed");
        }
    }

    private void callbackStreamStop() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: callbackStreamStop()");
        }
        this.setActive(false);
        this.setStarted(false);
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: callbackStreamStop() completed");
        }
    }

    private void callbackStreamEOM() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: callbackStreamEOM()");
        }
        this.setActive(false);
        this.setEOM();
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: callbackStreamEOM() completed");
        }
    }

    private void callbackStreamActive() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: callbackStreamActive()");
        }
        this.setActive(true);
        MixerSourceLine mixerSourceLine = this;
        synchronized (mixerSourceLine) {
            this.notifyAll();
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: callbackStreamActive() completed");
        }
    }

    private void callbackStreamInactive() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: callbackStreamInactive()");
        }
        this.setActive(false);
        MixerSourceLine mixerSourceLine = this;
        synchronized (mixerSourceLine) {
            this.notifyAll();
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: callbackStreamInactive() completed");
        }
    }

    private native void nDrain(int var1);

    private native void nFlush(int var1);

    private native long nGetPosition(int var1);

    private native float nGetLevel(int var1);

    private native int nOpen(int var1, int var2, float var3, int var4) throws LineUnavailableException;

    private native void nStart(int var1);

    private native void nResume(int var1);

    private native void nPause(int var1);

    private native void nClose(int var1);

    protected native float nSetLinearGain(int var1, float var2);

    protected native float nSetPan(int var1, float var2);

    protected native int nSetSampleRate(int var1, int var2);

    private class MixerSourceLineApplyReverbControl
    extends BooleanControl {
        private MixerSourceLineApplyReverbControl() {
            super(BooleanControl.Type.APPLY_REVERB, false, "Yes", "No");
        }

        public void setValue(boolean newValue) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            if (newValue == this.getValue() || MixerSourceLine.this.id != 0) {
                // empty if block
            }
            super.setValue(newValue);
        }
    }

    private class MixerSourceLineMuteControl
    extends BooleanControl {
        private MixerSourceLineMuteControl() {
            super(BooleanControl.Type.MUTE, false, "True", "False");
        }

        public void setValue(boolean newValue) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            if (newValue && !this.getValue() && MixerSourceLine.this.id != 0) {
                MixerSourceLine.this.nSetLinearGain(MixerSourceLine.this.id, 0.0f);
            } else if (!newValue && this.getValue() && MixerSourceLine.this.id != 0) {
                float linearGain = Toolkit.dBToLinear(MixerSourceLine.this.gainControl.getValue());
                MixerSourceLine.this.nSetLinearGain(MixerSourceLine.this.id, linearGain);
            }
            super.setValue(newValue);
        }
    }

    private class MixerSourceLineSampleRateControl
    extends FloatControl {
        private MixerSourceLineSampleRateControl() {
            super(FloatControl.Type.SAMPLE_RATE, 0.0f, 48000.0f, 1.0f, -1, MixerSourceLine.this.getFormat().getFrameRate(), "FPS", "Minimum", "", "Maximum");
        }

        public void setValue(float newValue) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            newValue = Math.min(newValue, this.getMaximum());
            if ((newValue = Math.max(newValue, this.getMinimum())) != this.getValue() && MixerSourceLine.this.id != 0) {
                newValue = MixerSourceLine.this.nSetSampleRate(MixerSourceLine.this.id, (int)newValue);
            }
            super.setValue(newValue);
        }

        private void update() {
            super.setValue(MixerSourceLine.this.getFormat().getFrameRate());
        }
    }

    private class MixerSourceLinePanControl
    extends FloatControl {
        private MixerSourceLinePanControl() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.015625f, -1, 0.0f, "", "Left", "Center", "Right");
        }

        public void setValue(float newValue) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            newValue = Math.min(newValue, this.getMaximum());
            if ((newValue = Math.max(newValue, this.getMinimum())) != this.getValue() && MixerSourceLine.this.id != 0) {
                newValue = -1.0f * MixerSourceLine.this.nSetPan(MixerSourceLine.this.id, -1.0f * newValue);
            }
            super.setValue(newValue);
        }
    }

    private class MixerSourceLineGainControl
    extends FloatControl {
        private float linearGain = 1.0f;

        private MixerSourceLineGainControl() {
            super(FloatControl.Type.MASTER_GAIN, Toolkit.linearToDB(0.0f), Toolkit.linearToDB(5.0f), Toolkit.linearToDB(0.0078125f), -1, 0.0f, "dB", "Minimum", "", "Maximum");
        }

        public void setValue(float newValue) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            newValue = Math.min(newValue, this.getMaximum());
            float newLinearGain = Toolkit.dBToLinear(newValue = Math.max(newValue, this.getMinimum()));
            if (newLinearGain != this.linearGain && MixerSourceLine.this.id != 0) {
                newLinearGain = MixerSourceLine.this.nSetLinearGain(MixerSourceLine.this.id, newLinearGain);
            }
            this.linearGain = newLinearGain;
            super.setValue(Toolkit.linearToDB(this.linearGain));
        }
    }
}

