/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.imp.SunMidiFileWriter;
import com.sun.jmfsound.midi.InvalidMidiDataException;
import com.sun.jmfsound.midi.MetaMessage;
import com.sun.jmfsound.midi.MidiEvent;
import com.sun.jmfsound.midi.Sequence;
import com.sun.jmfsound.midi.ShortMessage;
import com.sun.jmfsound.midi.SysexMessage;
import com.sun.jmfsound.midi.Track;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.SequenceInputStream;

public class StandardMidiFileWriter
extends SunMidiFileWriter {
    private static final int MThd_MAGIC = 1297377380;
    private static final int MTrk_MAGIC = 1297379947;
    private static final int ONE_BYTE = 1;
    private static final int TWO_BYTE = 2;
    private static final int SYSEX = 3;
    private static final int META = 4;
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private static final int MIDI_TYPE_2 = 2;
    private InputStream stream;
    private DataInputStream dis;
    private Sequence sequence;
    private short type;
    private short tracks;
    private long tick;
    private int status;
    private int bytesRemaining = 0;
    private static final int bufferSize = 16384;
    private DataOutputStream tddos;
    public static final int[] types = new int[]{0, 1};

    public int[] getMidiFileTypes() {
        int[] localArray = new int[types.length];
        System.arraycopy(types, 0, localArray, 0, types.length);
        return localArray;
    }

    public int[] getMidiFileTypes(Sequence sequence) {
        Track[] tracks = sequence.getTracks();
        int[] typesArray = tracks.length == 1 ? new int[]{0, 1} : new int[]{1};
        return typesArray;
    }

    public boolean isFileTypeSupported(int type) {
        int i = 0;
        while (i < types.length) {
            if (type == types[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int write(Sequence in, int type, OutputStream out) throws IOException {
        byte[] buffer = null;
        long bytesRead = 0L;
        long bytesWritten = 0L;
        if (!this.isFileTypeSupported(type, in)) {
            throw new IllegalArgumentException("Could not write MIDI file");
        }
        InputStream fileStream = this.getFileStream(type, in);
        if (fileStream == null) {
            throw new IllegalArgumentException("Could not write MIDI file");
        }
        buffer = new byte[16384];
        while ((bytesRead = (long)fileStream.read(buffer)) >= 0L) {
            out.write(buffer, 0, (int)bytesRead);
            bytesWritten += bytesRead;
        }
        return (int)bytesWritten;
    }

    public int write(Sequence in, int type, File out) throws IOException {
        FileOutputStream fos = null;
        Object bos = null;
        int bytesWritten = 0;
        fos = new FileOutputStream(out);
        bytesWritten = this.write(in, type, fos);
        fos.close();
        return bytesWritten;
    }

    private InputStream getFileStream(int type, Sequence sequence) throws IOException {
        int timeFormat;
        Track[] tracks = sequence.getTracks();
        int bytesBuilt = 0;
        int headerLength = 14;
        int length = 0;
        PipedOutputStream hpos = null;
        DataOutputStream hdos = null;
        PipedInputStream headerStream = null;
        InputStream[] trackStreams = null;
        InputStream trackStream = null;
        SequenceInputStream fStream = null;
        if (type == 0) {
            if (tracks.length != 1) {
                return null;
            }
        } else if (type == 1) {
            if (tracks.length < 1) {
                return null;
            }
        } else if (tracks.length == 1) {
            type = 0;
        } else if (tracks.length > 1) {
            type = 1;
        } else {
            return null;
        }
        trackStreams = new InputStream[tracks.length];
        int i = 0;
        while (i < tracks.length) {
            block29: {
                try {
                    trackStreams[i] = this.writeTrack(tracks[i], type);
                }
                catch (InvalidMidiDataException e) {
                    if (!Printer.err) break block29;
                    Printer.err("Exception in write: " + e.getMessage());
                }
            }
            ++i;
        }
        if (tracks.length == 1) {
            trackStream = trackStreams[0];
        } else if (tracks.length > 1) {
            trackStream = trackStreams[0];
            int i2 = 1;
            while (i2 < tracks.length) {
                trackStream = new SequenceInputStream(trackStream, trackStreams[i2]);
                ++i2;
            }
        }
        hpos = new PipedOutputStream();
        hdos = new DataOutputStream(hpos);
        headerStream = new PipedInputStream(hpos);
        hdos.writeInt(1297377380);
        hdos.writeInt(headerLength - 8);
        if (type == 0) {
            hdos.writeShort(0);
        } else {
            hdos.writeShort(1);
        }
        hdos.writeShort((short)tracks.length);
        float divtype = sequence.getDivisionType();
        if (divtype == 0.0f) {
            timeFormat = sequence.getResolution();
        } else if (divtype == 24.0f) {
            timeFormat = -6144;
            timeFormat += sequence.getResolution() & 0xFF;
        } else if (divtype == 25.0f) {
            timeFormat = -6400;
            timeFormat += sequence.getResolution() & 0xFF;
        } else if (divtype == 29.97f) {
            timeFormat = -7424;
            timeFormat += sequence.getResolution() & 0xFF;
        } else if (divtype == 30.0f) {
            timeFormat = -7680;
            timeFormat += sequence.getResolution() & 0xFF;
        } else {
            return null;
        }
        hdos.writeShort(timeFormat);
        fStream = new SequenceInputStream(headerStream, trackStream);
        hdos.close();
        length = bytesBuilt + headerLength;
        return fStream;
    }

    private int getType(int byteValue) throws InvalidMidiDataException {
        if ((byteValue & 0xF0) == 240) {
            switch (byteValue) {
                case 240: 
                case 247: {
                    return 3;
                }
                case 255: {
                    return 4;
                }
            }
            throw new InvalidMidiDataException("Invalid status byte: " + byteValue);
        }
        switch (byteValue & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        throw new InvalidMidiDataException("Invalid status byte: " + byteValue);
    }

    private int writeVarInt(int value) throws IOException, InvalidMidiDataException {
        int MAX_LENGTH = 6;
        byte[] bytes = new byte[MAX_LENGTH];
        int length = 0;
        boolean currentByte = false;
        int i = 0;
        while (i < MAX_LENGTH) {
            bytes[i] = 0;
            ++i;
        }
        int i2 = MAX_LENGTH - 1;
        while (i2 >= 0) {
            bytes[i2] = (byte)(value & 0x7F);
            value >>>= 7;
            if (++length > 1) {
                int n = i2;
                bytes[n] = (byte)(bytes[n] | 0x80);
            }
            if (value == 0) break;
            --i2;
        }
        if ((bytes[MAX_LENGTH - 1] & 0x80) != 0) {
            throw new InvalidMidiDataException("Unable to create variable-length integer");
        }
        this.tddos.write(bytes, MAX_LENGTH - length, length);
        return length;
    }

    private InputStream writeTrack(Track track, int type) throws IOException, InvalidMidiDataException {
        int bytesWritten = 0;
        boolean lastBytesWritten = false;
        int size = track.size();
        PipedOutputStream thpos = new PipedOutputStream();
        DataOutputStream thdos = new DataOutputStream(thpos);
        PipedInputStream thpis = new PipedInputStream(thpos);
        ByteArrayOutputStream tdbos = new ByteArrayOutputStream();
        this.tddos = new DataOutputStream(tdbos);
        ByteArrayInputStream tdbis = null;
        SequenceInputStream fStream = null;
        int currentTick = 0;
        int deltaTick = 0;
        int eventTick = 0;
        int runningStatus = -1;
        currentTick = 0;
        int i = 0;
        while (i < size) {
            MidiEvent event = track.get(i);
            byte[] data = null;
            ShortMessage shortMessage = null;
            MetaMessage metaMessage = null;
            SysexMessage sysexMessage = null;
            eventTick = (int)event.getTick();
            deltaTick = (int)event.getTick() - currentTick;
            currentTick = (int)event.getTick();
            int status = event.getMessage().getStatus();
            int eventtype = this.getType(status);
            switch (eventtype) {
                case 1: {
                    shortMessage = (ShortMessage)event.getMessage();
                    int data1 = shortMessage.getData1();
                    bytesWritten += this.writeVarInt(deltaTick);
                    if (status != runningStatus) {
                        runningStatus = status;
                        this.tddos.writeByte(status);
                        ++bytesWritten;
                    }
                    this.tddos.writeByte(data1);
                    ++bytesWritten;
                    break;
                }
                case 2: {
                    shortMessage = (ShortMessage)event.getMessage();
                    int data1 = shortMessage.getData1();
                    int data2 = shortMessage.getData2();
                    bytesWritten += this.writeVarInt(deltaTick);
                    if (status != runningStatus) {
                        runningStatus = status;
                        this.tddos.writeByte(status);
                        ++bytesWritten;
                    }
                    this.tddos.writeByte(data1);
                    ++bytesWritten;
                    this.tddos.writeByte(data2);
                    ++bytesWritten;
                    break;
                }
                case 3: {
                    sysexMessage = (SysexMessage)event.getMessage();
                    int length = sysexMessage.getLength();
                    data = sysexMessage.getMessage();
                    bytesWritten += this.writeVarInt(deltaTick);
                    runningStatus = status;
                    this.tddos.writeByte(data[0]);
                    ++bytesWritten;
                    bytesWritten += this.writeVarInt(data.length - 1);
                    this.tddos.write(data, 1, data.length - 1);
                    bytesWritten += data.length - 1;
                    break;
                }
                case 4: {
                    metaMessage = (MetaMessage)event.getMessage();
                    int length = metaMessage.getLength();
                    data = metaMessage.getMessage();
                    bytesWritten += this.writeVarInt(deltaTick);
                    runningStatus = status;
                    this.tddos.write(data, 0, data.length);
                    bytesWritten += data.length;
                    break;
                }
                default: {
                    throw new InvalidMidiDataException("Invalid midi event");
                }
            }
            ++i;
        }
        thdos.writeInt(1297379947);
        thdos.writeInt(bytesWritten);
        bytesWritten += 8;
        tdbis = new ByteArrayInputStream(tdbos.toByteArray());
        fStream = new SequenceInputStream(thpis, tdbis);
        thdos.close();
        this.tddos.close();
        return fStream;
    }
}

