/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.sampled.AudioFileFormat;
import com.sun.jmfsound.sampled.AudioInputStream;
import com.sun.jmfsound.sampled.UnsupportedAudioFileException;
import com.sun.jmfsound.sampled.spi.AudioFileReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

abstract class SunFileReader
extends AudioFileReader {
    private static SunFileReader[] fileReaders;
    protected static final int bisBufferSize = 4096;
    private static final String[] fileReaderClassNames;

    public abstract AudioFileFormat getAudioFileFormat(InputStream var1) throws UnsupportedAudioFileException, IOException;

    public abstract AudioFileFormat getAudioFileFormat(URL var1) throws UnsupportedAudioFileException, IOException;

    public abstract AudioFileFormat getAudioFileFormat(File var1) throws UnsupportedAudioFileException, IOException;

    public abstract AudioInputStream getAudioInputStream(InputStream var1) throws UnsupportedAudioFileException, IOException;

    public abstract AudioInputStream getAudioInputStream(URL var1) throws UnsupportedAudioFileException, IOException;

    public abstract AudioInputStream getAudioInputStream(File var1) throws UnsupportedAudioFileException, IOException;

    static int getNumFileReaders() {
        return fileReaders.length;
    }

    static SunFileReader getFileReader(int index) {
        SunFileReader[] sunFileReaderArray = fileReaders;
        synchronized (sunFileReaderArray) {
            block10: {
                try {
                    if (fileReaders[index] == null) {
                        Class<?> fileReaderClass = Class.forName(fileReaderClassNames[index]);
                        SunFileReader.fileReaders[index] = (SunFileReader)fileReaderClass.newInstance();
                    }
                }
                catch (ClassNotFoundException e) {
                    if (Printer.err) {
                        Printer.err("ClassNotFoundException: " + e);
                    }
                }
                catch (InstantiationException e2) {
                    if (Printer.err) {
                        Printer.err("InstantiationException: " + e2);
                    }
                }
                catch (IllegalAccessException e3) {
                    if (!Printer.err) break block10;
                    Printer.err("IllegalAccessException: " + e3);
                }
            }
        }
        return fileReaders[index];
    }

    protected int rllong(DataInputStream dis) throws IOException {
        int i = 0;
        i = dis.readInt();
        int b1 = (i & 0xFF) << 24;
        int b2 = (i & 0xFF00) << 8;
        int b3 = (i & 0xFF0000) >> 8;
        int b4 = (i & 0xFF000000) >>> 24;
        i = b1 | b2 | b3 | b4;
        return i;
    }

    protected int big2little(int i) {
        int b1 = (i & 0xFF) << 24;
        int b2 = (i & 0xFF00) << 8;
        int b3 = (i & 0xFF0000) >> 8;
        int b4 = (i & 0xFF000000) >>> 24;
        i = b1 | b2 | b3 | b4;
        return i;
    }

    protected short rlshort(DataInputStream dis) throws IOException {
        short s = 0;
        s = dis.readShort();
        short high = (short)((s & 0xFF) << 8);
        short low = (short)((s & 0xFF00) >>> 8);
        s = (short)(high | low);
        return s;
    }

    protected short big2littleShort(short i) {
        short high = (short)((i & 0xFF) << 8);
        short low = (short)((i & 0xFF00) >>> 8);
        i = (short)(high | low);
        return i;
    }

    static {
        fileReaderClassNames = new String[]{"com.sun.jmfsound.imp.AuFileReader", "com.sun.jmfsound.imp.WaveFileReader", "com.sun.jmfsound.imp.AiffFileReader"};
        fileReaders = new SunFileReader[fileReaderClassNames.length];
    }
}

