/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.sampled;

public class AudioFormat {
    protected Encoding encoding;
    protected float sampleRate;
    protected int sampleSizeInBits;
    protected int channels;
    protected int frameSize;
    protected float frameRate;
    protected boolean bigEndian;

    public AudioFormat(Encoding encoding, float sampleRate, int sampleSizeInBits, int channels, int frameSize, float frameRate, boolean bigEndian) {
        this.encoding = encoding;
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
        this.frameSize = frameSize;
        this.frameRate = frameRate;
        this.bigEndian = bigEndian;
    }

    public AudioFormat(float sampleRate, int sampleSizeInBits, int channels, boolean signed, boolean bigEndian) {
        this(signed ? Encoding.PCM_SIGNED : Encoding.PCM_UNSIGNED, sampleRate, sampleSizeInBits, channels, sampleSizeInBits * channels / 8, sampleRate, bigEndian);
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean matches(AudioFormat format) {
        return !(format.getEncoding() != this.getEncoding() || format.getSampleRate() != -1.0f && format.getSampleRate() != this.getSampleRate() || format.getSampleSizeInBits() != this.getSampleSizeInBits() || format.getChannels() != this.getChannels() || format.getFrameSize() != this.getFrameSize() || format.getFrameRate() != -1.0f && format.getFrameRate() != this.getFrameRate() || format.getSampleSizeInBits() > 8 && format.isBigEndian() != this.isBigEndian());
    }

    public String toString() {
        return this.getEncoding() + ", " + this.sampleRate + " Hz, " + this.sampleSizeInBits + " bit, " + (this.channels == 2 ? "stereo, " : "mono, ") + (this.sampleSizeInBits > 8 ? (this.bigEndian ? "big-endian, " : "little-endian, ") : "") + "audio data";
    }

    public static class Encoding {
        public static final Encoding PCM_SIGNED = new Encoding("PCM_SIGNED");
        public static final Encoding PCM_UNSIGNED = new Encoding("PCM_UNSIGNED");
        public static final Encoding ULAW = new Encoding("ULAW");
        public static final Encoding ALAW = new Encoding("ALAW");
        private String name;

        protected Encoding(String name) {
            this.name = name;
        }

        public final boolean equals(Object obj) {
            return super.equals(obj);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }
}

