/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.sampled;

import com.sun.jmfsound.sampled.AudioFormat;
import com.sun.jmfsound.sampled.TargetDataLine;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class AudioInputStream
extends InputStream {
    private PushbackInputStream stream;
    protected AudioFormat format;
    protected long frameLength;
    protected int frameSize;
    protected long framePos;
    private long markpos;

    public AudioInputStream(InputStream stream, AudioFormat format, long length) {
        this.format = format;
        this.frameLength = length;
        this.frameSize = format.getFrameSize();
        if (this.frameSize == -1) {
            this.frameSize = 1;
        }
        this.stream = this.frameSize > 1 ? new PushbackInputStream(stream, this.frameSize - 1) : new PushbackInputStream(stream, 1);
        this.framePos = 0L;
    }

    public AudioInputStream(TargetDataLine line) {
        TargetDataLineInputStream tstream = new TargetDataLineInputStream(line);
        this.format = line.getFormat();
        this.frameLength = -1L;
        this.frameSize = this.format.getFrameSize();
        if (this.frameSize == -1) {
            this.frameSize = 1;
        }
        this.stream = this.frameSize > 1 ? new PushbackInputStream(tstream, this.frameSize - 1) : new PushbackInputStream(tstream, 1);
        this.framePos = 0L;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    public int read() throws IOException {
        if (this.frameSize != 1) {
            throw new IOException("cannot read a single byte if frame size != 1");
        }
        if (this.frameLength != -1L && this.framePos >= this.frameLength) {
            return -1;
        }
        int temp = this.stream.read();
        if (temp >= 0) {
            ++this.framePos;
        }
        return temp;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int extraBytes;
        int bytesRead;
        if (len % this.frameSize != 0) {
            len -= len % this.frameSize;
        }
        if (this.frameLength != -1L) {
            if (this.framePos >= this.frameLength) {
                return -1;
            }
            if ((long)(len / this.frameSize) > this.frameLength - this.framePos) {
                len = (int)(this.frameLength - this.framePos) * this.frameSize;
            }
        }
        if ((bytesRead = this.stream.read(b, off, len)) > 0 && (extraBytes = bytesRead % this.frameSize) > 0) {
            this.stream.unread(b, off + bytesRead - extraBytes, extraBytes);
            bytesRead -= extraBytes;
        }
        return bytesRead;
    }

    public long skip(long n) throws IOException {
        long temp;
        if (n % (long)this.frameSize != 0L) {
            n -= n % (long)this.frameSize;
        }
        if (this.frameLength != -1L && n / (long)this.frameSize > this.frameLength - this.framePos) {
            n = (this.frameLength - this.framePos) * (long)this.frameSize;
        }
        if ((temp = this.stream.skip(n)) % (long)this.frameSize != 0L) {
            throw new IOException("Could not skip an integer number of frames.");
        }
        if (temp >= 0L) {
            this.framePos += temp / (long)this.frameSize;
        }
        return temp;
    }

    public int available() throws IOException {
        int temp = this.stream.available();
        if (this.frameLength != -1L && (long)(temp / this.frameSize) > this.frameLength - this.framePos) {
            return (int)(this.frameLength - this.framePos) * this.frameSize;
        }
        return temp;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void mark(int readlimit) {
        ((FilterInputStream)this.stream).mark(readlimit);
        if (this.stream.markSupported()) {
            this.markpos = this.framePos;
        }
    }

    public void reset() throws IOException {
        ((FilterInputStream)this.stream).reset();
        if (this.stream.markSupported()) {
            this.framePos = this.markpos;
        }
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }

    private class TargetDataLineInputStream
    extends InputStream {
        TargetDataLine line;

        TargetDataLineInputStream(TargetDataLine line) {
            this.line = line;
        }

        public int available() throws IOException {
            return this.line.available();
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            int value = this.read(b, 0, 1);
            if (value == -1) {
                return -1;
            }
            value = b[0];
            if (this.line.getFormat().getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
                value += 128;
            }
            return value;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return this.line.read(b, off, len);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

