/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio;

import com.sun.media.BasicCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class GainCodec
extends BasicCodec {
    private static String GainCodec = "GainCodec";
    public float gain = 2.0f;

    public void setGain(float f2) {
        this.gain = f2;
    }

    public String getName() {
        return GainCodec;
    }

    public GainCodec() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, -1, -1, -1, -1.0, Format.shortArray)};
        this.outputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, -1, -1, -1, -1.0, Format.shortArray)};
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (!(format instanceof AudioFormat)) {
            return this.outputFormats;
        }
        AudioFormat audioFormat = (AudioFormat)format;
        if (!audioFormat.getEncoding().equals("LINEAR") || audioFormat.getDataType() != Format.shortArray) {
            return new Format[0];
        }
        AudioFormat audioFormat2 = new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 0, 1, audioFormat.getFrameSizeInBits(), audioFormat.getFrameRate(), Format.shortArray);
        return new Format[]{audioFormat2};
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        short[] sArray = (short[])buffer.getData();
        int n2 = buffer.getLength();
        int n3 = buffer.getOffset();
        int n4 = n2;
        short[] sArray2 = this.validateShortArraySize(buffer2, n4);
        int n5 = 0;
        while (n5 < n4) {
            int n6 = sArray[n3 + n5];
            if ((n6 = (int)((float)n6 * this.gain)) > Short.MAX_VALUE) {
                n6 = Short.MAX_VALUE;
            } else if (n6 < Short.MIN_VALUE) {
                n6 = Short.MIN_VALUE;
            }
            sArray2[n5] = (short)n6;
            ++n5;
        }
        this.updateOutput(buffer2, this.outputFormat, n4, 0);
        return 0;
    }

    public static void main(String[] stringArray) {
        GainCodec gainCodec = new GainCodec();
        Format[] formatArray = gainCodec.getSupportedInputFormats();
        Format[] formatArray2 = gainCodec.getSupportedOutputFormats(null);
        Buffer buffer = new Buffer();
        Buffer buffer2 = new Buffer();
        short[] sArray = new short[100];
        int n2 = 0;
        while (n2 < 100) {
            sArray[n2] = (short)(n2 + 20500);
            ++n2;
        }
        buffer.setData(sArray);
        buffer.setLength(10);
        buffer.setOffset(0);
        gainCodec.setGain(1.6f);
        int n3 = gainCodec.process(buffer, buffer2);
        System.out.println("rc=" + n3);
        short[] sArray2 = (short[])buffer2.getData();
        System.out.println("length=" + buffer2.getLength());
        System.out.println("offset=" + buffer2.getOffset());
        int n4 = 0;
        while (n4 < sArray2.length) {
            System.out.println(n4 + " " + sArray2[n4]);
            ++n4;
        }
        buffer.setLength(0);
        buffer.setEOM(true);
        n3 = gainCodec.process(buffer, buffer2);
        System.out.println("rc=" + n3);
        sArray2 = (short[])buffer2.getData();
        System.out.println("length=" + buffer2.getLength());
        System.out.println("offset=" + buffer2.getOffset());
        int n5 = 0;
        while (n5 < sArray2.length) {
            System.out.println(n5 + " " + sArray2[n5]);
            ++n5;
        }
    }
}

