/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.dvi;

import com.ibm.media.codec.audio.AudioPacketizer;
import com.ibm.media.codec.audio.dvi.DVI;
import com.ibm.media.codec.audio.dvi.DVIState;
import com.ibm.media.codec.audio.dvi.PacketSizeAdapter;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaEncoder
extends AudioPacketizer {
    private Buffer pcmBuffer = new Buffer();
    private DVIState dviState = new DVIState();
    private long currentSeq = 0L;

    public JavaEncoder() {
        this.packetSize = 240;
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("dvi/rtp", -1.0, 4, 1, -1, -1, -1, -1.0, Format.byteArray)};
        this.PLUGIN_NAME = "DVI Encoder";
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("dvi/rtp", audioFormat.getSampleRate(), 4, 1, -1, -1, -1, -1.0, Format.byteArray)};
        return this.supportedOutputFormats;
    }

    public Format setOutputFormat(Format format) {
        Format format2 = super.setOutputFormat(format);
        AudioFormat audioFormat = (AudioFormat)format2;
        if (audioFormat.getSampleRate() == 8000.0) {
            this.packetSize = 240;
        } else if (audioFormat.getSampleRate() == 11025.0) {
            this.packetSize = 330;
        } else if (audioFormat.getSampleRate() == 22050.0) {
            this.packetSize = 660;
        } else if (audioFormat.getSampleRate() == 44100.0) {
            this.packetSize = 1320;
        }
        return format2;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n2 = super.process(buffer, this.pcmBuffer);
        if ((n2 & 4) != 0) {
            return n2;
        }
        byte[] byArray = (byte[])this.pcmBuffer.getData();
        int n3 = this.pcmBuffer.getLength();
        int n4 = this.pcmBuffer.getLength() / 4;
        byte[] byArray2 = this.validateByteArraySize(buffer2, n4 + 4);
        byArray2[0] = (byte)(this.dviState.valprev >> 8);
        byArray2[1] = (byte)this.dviState.valprev;
        byArray2[2] = (byte)this.dviState.index;
        byArray2[3] = 0;
        DVI.encode(byArray, 0, byArray2, 4, n3 >> 1, this.dviState);
        this.pcmBuffer.setOffset(0);
        this.pcmBuffer.setLength(0);
        buffer2.setSequenceNumber(this.currentSeq++);
        buffer2.setTimeStamp(this.pcmBuffer.getTimeStamp());
        this.updateOutput(buffer2, this.outputFormat, n4 + 4, 0);
        return n2;
    }

    public void open() throws ResourceUnavailableException {
        this.dviState = new DVIState();
        this.setPacketSize(this.packetSize);
        this.reset();
    }

    public void reset() {
        super.reset();
        this.dviState.valprev = 0;
        this.dviState.index = 0;
        this.pcmBuffer.setOffset(0);
        this.pcmBuffer.setLength(0);
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[2];
            this.controls[0] = new PacketSizeAdapter(this, this.packetSize, true);
            this.controls[1] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }

    public synchronized void setPacketSize(int n2) {
        this.packetSize = n2 * 4;
        this.sample_count = this.packetSize / 2;
        if (this.history == null) {
            this.history = new byte[this.packetSize];
            return;
        }
        if (this.packetSize > this.history.length) {
            byte[] byArray = new byte[this.packetSize];
            System.arraycopy(this.history, 0, byArray, 0, this.historyLength);
            this.history = byArray;
        }
    }
}

