/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.ulaw;

import com.ibm.media.codec.audio.AudioCodec;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    private static final byte[] lutTableL = new byte[256];
    private static final byte[] lutTableH = new byte[256];

    public JavaDecoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("ULAW")};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "Mu-Law Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 0, 1)};
        return this.supportedOutputFormats;
    }

    public void open() {
        this.initTables();
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        int n2 = this.outputFormat.getChannels();
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, byArray.length * 2);
        int n3 = buffer.getLength();
        int n4 = 2 * n3;
        int n5 = buffer.getOffset();
        int n6 = buffer2.getOffset();
        int n7 = 0;
        while (n7 < n3) {
            int n8 = byArray[n5++] & 0xFF;
            byArray2[n6++] = lutTableL[n8];
            byArray2[n6++] = lutTableH[n8];
            ++n7;
        }
        this.updateOutput(buffer2, this.outputFormat, n4, buffer2.getOffset());
        return 0;
    }

    private void initTables() {
        int n2 = 0;
        while (n2 < 256) {
            int n3 = ~n2;
            int n4 = ((n3 & 0xF) << 3) + 132;
            int n5 = (n3 & 0x70) >> 4;
            int n6 = n4 << n5;
            n6 -= 132;
            if ((n3 & 0x80) != 0) {
                n6 = -n6;
            }
            JavaDecoder.lutTableL[n2] = (byte)n6;
            JavaDecoder.lutTableH[n2] = (byte)(n6 >> 8);
            ++n2;
        }
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }
}

