/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicModule;
import com.sun.media.BasicPlugIn;
import com.sun.media.Connector;
import com.sun.media.CreateSourceThreadAction;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.MyOutputConnector;
import com.sun.media.PlaybackEngine;
import com.sun.media.SourceThread;
import com.sun.media.rtp.util.RTPTimeBase;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12PriorityAction;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.BadHeaderException;
import javax.media.Demultiplexer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.PlugInManager;
import javax.media.ResourceUnavailableException;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.Positionable;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.SourceStream;

public class BasicSourceModule
extends BasicModule
implements Duration,
Positionable {
    PlaybackEngine engine;
    protected DataSource source;
    protected Demultiplexer parser;
    protected Track[] tracks = new Track[0];
    protected SourceThread[] loops;
    protected String[] connectorNames;
    protected long bitsRead = 0L;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    Object resetSync = new Object();
    protected boolean started = false;
    protected SystemTimeBase systemTimeBase = new SystemTimeBase();
    protected long lastSystemTime = 0L;
    protected long originSystemTime = 0L;
    protected long currentSystemTime = 0L;
    protected Time lastPositionSet = new Time(0L);
    RTPTimeBase rtpMapperUpdatable = null;
    RTPTimeBase rtpMapper = null;
    long currentRTPTime = 0L;
    long oldOffset = 0L;
    boolean rtpOffsetInvalid = true;
    String cname = null;
    public String errMsg = null;
    int latencyTrack = -1;
    static /* synthetic */ Class class$com$sun$media$SourceThread;

    public static BasicSourceModule createModule(DataSource dataSource) throws IOException, IncompatibleSourceException {
        Demultiplexer demultiplexer = BasicSourceModule.createDemultiplexer(dataSource);
        if (demultiplexer == null) {
            return null;
        }
        return new BasicSourceModule(dataSource, demultiplexer);
    }

    protected BasicSourceModule(DataSource dataSource, Demultiplexer demultiplexer) {
        this.source = dataSource;
        this.parser = demultiplexer;
        SourceStream sourceStream = null;
        if (this.source instanceof PullDataSource) {
            sourceStream = ((PullDataSource)this.source).getStreams()[0];
        } else if (this.source instanceof PushDataSource) {
            sourceStream = ((PushDataSource)this.source).getStreams()[0];
        }
    }

    protected static Demultiplexer createDemultiplexer(DataSource dataSource) throws IOException, IncompatibleSourceException {
        ContentDescriptor contentDescriptor = new ContentDescriptor(dataSource.getContentType());
        Vector vector = PlugInManager.getPlugInList(contentDescriptor, null, 1);
        Demultiplexer demultiplexer = null;
        IOException iOException = null;
        IncompatibleSourceException incompatibleSourceException = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            block11: {
                try {
                    Class clazz = BasicPlugIn.getClassForName((String)vector.elementAt(n2));
                    Object t = clazz.newInstance();
                    if (!(t instanceof Demultiplexer)) break block11;
                    demultiplexer = (Demultiplexer)t;
                    try {
                        demultiplexer.setSource(dataSource);
                        break;
                    }
                    catch (IOException iOException2) {
                        demultiplexer = null;
                        iOException = iOException2;
                    }
                    catch (IncompatibleSourceException incompatibleSourceException2) {
                        demultiplexer = null;
                        incompatibleSourceException = incompatibleSourceException2;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        if (demultiplexer == null) {
            if (iOException != null) {
                throw iOException;
            }
            if (incompatibleSourceException != null) {
                throw incompatibleSourceException;
            }
        }
        return demultiplexer;
    }

    public boolean doRealize() {
        try {
            this.parser.open();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            this.errMsg = "Resource unavailable: " + resourceUnavailableException.getMessage();
            return false;
        }
        try {
            this.parser.start();
            this.tracks = this.parser.getTracks();
        }
        catch (BadHeaderException badHeaderException) {
            this.errMsg = "Bad header in the media: " + badHeaderException.getMessage();
            this.parser.close();
            return false;
        }
        catch (IOException iOException) {
            this.errMsg = "IO exception: " + iOException.getMessage();
            this.parser.close();
            return false;
        }
        if (this.tracks == null || this.tracks.length == 0) {
            this.errMsg = "The media has 0 track";
            this.parser.close();
            return false;
        }
        if (jmfSecurity != null) {
            String string = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    string = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    string = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Exception exception) {
                securityPrivelege = false;
            }
        }
        this.loops = new SourceThread[this.tracks.length];
        this.connectorNames = new String[this.tracks.length];
        int n2 = 0;
        while (n2 < this.tracks.length) {
            MyOutputConnector myOutputConnector = new MyOutputConnector(this.tracks[n2]);
            myOutputConnector.setProtocol(0);
            myOutputConnector.setSize(1);
            this.connectorNames[n2] = this.tracks[n2].toString();
            this.registerOutputConnector(this.tracks[n2].toString(), myOutputConnector);
            this.loops[n2] = null;
            ++n2;
        }
        this.engine = (PlaybackEngine)this.getController();
        if (this.engine == null || !this.engine.isRTP()) {
            this.parser.stop();
        }
        return true;
    }

    SourceThread createSourceThread(int n2) {
        Object object;
        SourceThread sourceThread = null;
        MyOutputConnector myOutputConnector = (MyOutputConnector)this.getOutputConnector(this.connectorNames[n2]);
        if (myOutputConnector == null || myOutputConnector.getInputConnector() == null) {
            this.tracks[n2].setEnabled(false);
            return null;
        }
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    object = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = CreateSourceThreadAction.cons;
                Constructor constructor = jdk12PriorityAction.cons;
                sourceThread = (SourceThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$SourceThread == null ? (class$com$sun$media$SourceThread = BasicSourceModule.class$("com.sun.media.SourceThread")) : class$com$sun$media$SourceThread, this, myOutputConnector, new Integer(n2)));
                int n3 = this.tracks[n2].getFormat() instanceof AudioFormat ? MediaThread.getAudioPriority() : MediaThread.getVideoPriority();
                sourceThread.useVideoPriority();
                jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(sourceThread, new Integer(n3)));
            }
            catch (Exception exception) {
                sourceThread = null;
            }
        } else {
            sourceThread = new SourceThread(this, myOutputConnector, n2);
            if (this.tracks[n2].getFormat() instanceof AudioFormat) {
                sourceThread.useAudioPriority();
            } else {
                sourceThread.useVideoPriority();
            }
        }
        if (sourceThread == null) {
            this.tracks[n2].setEnabled(false);
        }
        return sourceThread;
    }

    public void doFailedRealize() {
        this.parser.stop();
        this.parser.close();
    }

    public void abortRealize() {
        this.parser.stop();
        this.parser.close();
    }

    public boolean doPrefetch() {
        super.doPrefetch();
        return true;
    }

    public void doFailedPrefetch() {
    }

    public void abortPrefetch() {
        this.doStop();
    }

    public void doStart() {
        this.lastSystemTime = this.systemTimeBase.getNanoseconds();
        this.originSystemTime = this.currentSystemTime;
        this.rtpOffsetInvalid = true;
        super.doStart();
        try {
            this.parser.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n2 = 0;
        while (n2 < this.loops.length) {
            if (this.tracks[n2].isEnabled() && (this.loops[n2] != null || (this.loops[n2] = this.createSourceThread(n2)) != null)) {
                this.loops[n2].start();
            }
            ++n2;
        }
        this.started = true;
    }

    public void doStop() {
        this.started = false;
    }

    public void pause() {
        Object object = this.resetSync;
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.loops.length) {
                if (this.tracks[n2].isEnabled() && this.loops[n2] != null && !this.loops[n2].resetted) {
                    this.loops[n2].pause();
                }
                ++n2;
            }
            this.parser.stop();
        }
    }

    public void doDealloc() {
    }

    public void doClose() {
        this.parser.close();
        if (this.tracks == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.tracks.length) {
            if (this.loops[n2] != null) {
                this.loops[n2].kill();
            }
            ++n2;
        }
        if (this.rtpMapperUpdatable != null) {
            RTPTimeBase.returnMapperUpdatable(this.rtpMapperUpdatable);
            this.rtpMapperUpdatable = null;
        }
    }

    public void reset() {
        Object object = this.resetSync;
        synchronized (object) {
            super.reset();
            int n2 = 0;
            while (n2 < this.loops.length) {
                if (this.tracks[n2].isEnabled() && (this.loops[n2] != null || (this.loops[n2] = this.createSourceThread(n2)) != null)) {
                    this.loops[n2].resetted = true;
                    this.loops[n2].start();
                }
                ++n2;
            }
        }
    }

    public String[] getOutputConnectorNames() {
        return this.connectorNames;
    }

    public Time getDuration() {
        return this.parser.getDuration();
    }

    public Time setPosition(Time time, int n2) {
        Time time2 = this.parser.setPosition(time, n2);
        this.lastPositionSet = this.lastPositionSet.getNanoseconds() == time2.getNanoseconds() ? new Time(time2.getNanoseconds() + 1L) : time2;
        return time2;
    }

    public boolean isPositionable() {
        return this.parser.isPositionable();
    }

    public boolean isRandomAccess() {
        return this.parser.isRandomAccess();
    }

    public Object[] getControls() {
        return this.parser.getControls();
    }

    public Object getControl(String string) {
        return this.parser.getControl(string);
    }

    public Demultiplexer getDemultiplexer() {
        return this.parser;
    }

    public void setFormat(Connector connector, Format format) {
    }

    public void process() {
    }

    public long getBitsRead() {
        return this.bitsRead;
    }

    public void resetBitsRead() {
        this.bitsRead = 0L;
    }

    boolean readHasBlocked() {
        if (this.loops == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.loops.length) {
            if (this.loops[n2] != null && this.loops[n2].readBlocked) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void checkLatency() {
        if (this.latencyTrack > -1) {
            if (this.tracks[this.latencyTrack].isEnabled() && this.loops[this.latencyTrack] != null) {
                this.loops[this.latencyTrack].checkLatency = true;
                return;
            }
            this.latencyTrack = -1;
        }
        int n2 = 0;
        while (n2 < this.tracks.length) {
            if (this.tracks[n2].isEnabled()) {
                this.latencyTrack = n2;
                if (this.tracks[n2].getFormat() instanceof VideoFormat) break;
            }
            ++n2;
        }
        if (this.latencyTrack > -1 && this.loops[this.latencyTrack] != null) {
            this.loops[this.latencyTrack].checkLatency = true;
        }
    }

    protected boolean checkAllPaused() {
        int n2 = 0;
        while (n2 < this.loops.length) {
            if (this.tracks[n2].isEnabled() && this.loops[n2] != null && !this.loops[n2].isPaused()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

