/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicPlugIn;
import com.sun.media.BasicTrackControl;
import com.sun.media.GraphInspector;
import com.sun.media.GraphNode;
import com.sun.media.Log;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class SimpleGraphBuilder {
    protected int STAGES = 4;
    protected Hashtable plugIns = new Hashtable(40);
    protected GraphNode[] targetPlugins = null;
    protected Vector targetPluginNames = null;
    protected int targetType = -1;
    int indent = 0;
    protected static GraphInspector inspector;
    static /* synthetic */ Class class$javax$media$Codec;
    static /* synthetic */ Class class$javax$media$Renderer;
    static /* synthetic */ Class class$javax$media$Multiplexer;
    static /* synthetic */ Class class$javax$media$PlugIn;

    public static void setGraphInspector(GraphInspector graphInspector) {
        inspector = graphInspector;
    }

    public void reset() {
        Enumeration enumeration = this.plugIns.elements();
        while (enumeration.hasMoreElements()) {
            GraphNode graphNode = (GraphNode)enumeration.nextElement();
            graphNode.resetAttempted();
        }
    }

    boolean buildGraph(BasicTrackControl basicTrackControl) {
        Log.comment("Input: " + basicTrackControl.getOriginalFormat());
        Vector<GraphNode> vector = new Vector<GraphNode>();
        GraphNode graphNode = new GraphNode(null, null, basicTrackControl.getOriginalFormat(), null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        if (!this.setDefaultTargets(basicTrackControl.getOriginalFormat())) {
            return false;
        }
        vector.addElement(graphNode);
        while ((graphNode = this.buildGraph(vector)) != null) {
            GraphNode graphNode2 = this.buildTrackFromGraph(basicTrackControl, graphNode);
            if (graphNode2 == null) {
                this.indent = 0;
                Log.setIndent(this.indent);
                return true;
            }
            this.removeFailure(vector, graphNode2, basicTrackControl.getOriginalFormat());
        }
        this.indent = 0;
        Log.setIndent(this.indent);
        return false;
    }

    protected GraphNode buildTrackFromGraph(BasicTrackControl basicTrackControl, GraphNode graphNode) {
        return null;
    }

    GraphNode buildGraph(Format format) {
        Log.comment("Input: " + format);
        Vector<GraphNode> vector = new Vector<GraphNode>();
        GraphNode graphNode = new GraphNode(null, null, format, null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        if (!this.setDefaultTargets(format)) {
            return null;
        }
        vector.addElement(graphNode);
        while ((graphNode = this.buildGraph(vector)) != null) {
            GraphNode graphNode2 = this.verifyGraph(graphNode);
            if (graphNode2 == null) {
                this.indent = 0;
                Log.setIndent(this.indent);
                return graphNode;
            }
            this.removeFailure(vector, graphNode2, format);
        }
        this.indent = 0;
        Log.setIndent(this.indent);
        return graphNode;
    }

    GraphNode buildGraph(Vector vector) {
        GraphNode graphNode;
        while ((graphNode = this.doBuildGraph(vector)) == null) {
            if (vector.isEmpty()) break;
        }
        return graphNode;
    }

    GraphNode doBuildGraph(Vector vector) {
        Format format;
        Format[] formatArray;
        if (vector.isEmpty()) {
            return null;
        }
        GraphNode graphNode = (GraphNode)vector.firstElement();
        vector.removeElementAt(0);
        if (!(graphNode.input != null || graphNode.plugin != null && graphNode.plugin instanceof Codec)) {
            Log.error("Internal error: doBuildGraph");
            return null;
        }
        int n2 = this.indent;
        Log.setIndent(graphNode.level + 1);
        if (graphNode.plugin != null && SimpleGraphBuilder.verifyInput(graphNode.plugin, graphNode.input) == null) {
            return null;
        }
        GraphNode graphNode2 = this.findTarget(graphNode);
        if (graphNode2 != null) {
            this.indent = n2;
            Log.setIndent(this.indent);
            return graphNode2;
        }
        if (graphNode.level >= this.STAGES) {
            this.indent = n2;
            Log.setIndent(this.indent);
            return null;
        }
        if (graphNode.plugin != null) {
            if (graphNode.output != null) {
                formatArray = new Format[]{graphNode.output};
            } else {
                formatArray = graphNode.getSupportedOutputs(graphNode.input);
                if (formatArray == null || formatArray.length == 0) {
                    this.indent = n2;
                    Log.setIndent(this.indent);
                    return null;
                }
            }
            format = graphNode.input;
        } else {
            formatArray = new Format[]{graphNode.input};
            format = null;
        }
        boolean bl = false;
        int n3 = 0;
        while (n3 < formatArray.length) {
            block22: {
                Vector vector2;
                block23: {
                    block24: {
                        if (!graphNode.custom && format != null && format.equals(formatArray[n3])) break block22;
                        if (graphNode.plugin == null) break block23;
                        if (SimpleGraphBuilder.verifyOutput(graphNode.plugin, formatArray[n3]) != null) break block24;
                        if (inspector != null && inspector.detailMode()) {
                            inspector.verifyOutputFailed(graphNode.plugin, formatArray[n3]);
                        }
                        break block22;
                    }
                    if (inspector != null && !inspector.verify((Codec)graphNode.plugin, graphNode.input, formatArray[n3])) break block22;
                }
                if ((vector2 = PlugInManager.getPlugInList(formatArray[n3], null, 2)) != null && vector2.size() != 0) {
                    int n4 = 0;
                    while (n4 < vector2.size()) {
                        GraphNode graphNode3 = SimpleGraphBuilder.getPlugInNode((String)vector2.elementAt(n4), 2, this.plugIns);
                        if (graphNode3 != null && !graphNode3.checkAttempted(formatArray[n3])) {
                            Format[] formatArray2 = graphNode3.getSupportedInputs();
                            Format format2 = SimpleGraphBuilder.matches(formatArray[n3], formatArray2, null, graphNode3.plugin);
                            if (format2 == null) {
                                if (inspector != null && inspector.detailMode()) {
                                    inspector.verifyInputFailed(graphNode3.plugin, formatArray[n3]);
                                }
                            } else if (inspector == null || !inspector.detailMode() || inspector.verify((Codec)graphNode3.plugin, format2, null)) {
                                graphNode2 = new GraphNode(graphNode3, format2, graphNode, graphNode.level + 1);
                                vector.addElement(graphNode2);
                                bl = true;
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n3;
        }
        this.indent = n2;
        Log.setIndent(this.indent);
        return null;
    }

    GraphNode findTarget(GraphNode graphNode) {
        GraphNode graphNode2;
        Format[] formatArray;
        if (graphNode.plugin == null) {
            formatArray = new Format[]{graphNode.input};
        } else if (graphNode.output != null) {
            formatArray = new Format[]{graphNode.output};
        } else {
            formatArray = graphNode.getSupportedOutputs(graphNode.input);
            if (formatArray == null || formatArray.length == 0) {
                return null;
            }
        }
        if (this.targetPlugins != null && (graphNode2 = this.verifyTargetPlugins(graphNode, formatArray)) != null) {
            return graphNode2;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    GraphNode verifyTargetPlugins(GraphNode var1_1, Format[] var2_2) {
        var5_3 = 0;
        while (var5_3 < this.targetPlugins.length) {
            block7: {
                var3_4 = this.targetPlugins[var5_3];
                if (var3_4 != null) ** GOTO lbl12
                var6_6 = (String)this.targetPluginNames.elementAt(var5_3);
                if (var6_6 == null || SimpleGraphBuilder.matches(var2_2, var7_7 = PlugInManager.getSupportedInputFormats(var6_6, this.targetType), null, null) == null) break block7;
                var3_4 = SimpleGraphBuilder.getPlugInNode(var6_6, this.targetType, this.plugIns);
                if (var3_4 == null) {
                    this.targetPluginNames.setElementAt(null, var5_3);
                } else {
                    this.targetPlugins[var5_3] = var3_4;
lbl12:
                    // 2 sources

                    if ((var4_5 = SimpleGraphBuilder.matches(var2_2, var3_4.getSupportedInputs(), var1_1.plugin, var3_4.plugin)) != null && (SimpleGraphBuilder.inspector == null || (var1_1.plugin == null || SimpleGraphBuilder.inspector.verify((Codec)var1_1.plugin, var1_1.input, var4_5)) && !((var3_4.type == -1 || var3_4.type == 2) && var3_4.plugin instanceof Codec != false ? SimpleGraphBuilder.inspector.verify((Codec)var3_4.plugin, var4_5, null) == false : (var3_4.type == -1 || var3_4.type == 4) && var3_4.plugin instanceof Renderer != false && SimpleGraphBuilder.inspector.verify((Renderer)var3_4.plugin, var4_5) == false))) {
                        return new GraphNode(var3_4, var4_5, var1_1, var1_1.level + 1);
                    }
                }
            }
            ++var5_3;
        }
        return null;
    }

    boolean setDefaultTargets(Format format) {
        return this.setDefaultTargetRenderer(format);
    }

    boolean setDefaultTargetRenderer(Format format) {
        this.targetPluginNames = format instanceof AudioFormat ? PlugInManager.getPlugInList(new AudioFormat(null, -1.0, -1, -1, -1, -1, -1, -1.0, null), null, 4) : (format instanceof VideoFormat ? PlugInManager.getPlugInList(new VideoFormat(null, null, -1, null, -1.0f), null, 4) : PlugInManager.getPlugInList(null, null, 4));
        if (this.targetPluginNames == null || this.targetPluginNames.size() == 0) {
            return false;
        }
        this.targetPlugins = new GraphNode[this.targetPluginNames.size()];
        this.targetType = 4;
        return true;
    }

    protected GraphNode verifyGraph(GraphNode graphNode) {
        Format format = null;
        Vector<PlugIn> vector = new Vector<PlugIn>(5);
        if (graphNode.plugin == null) {
            return null;
        }
        Log.setIndent(this.indent++);
        while (graphNode != null && graphNode.plugin != null) {
            if (vector.contains(graphNode.plugin)) {
                PlugIn plugIn;
                if (graphNode.cname == null || (plugIn = SimpleGraphBuilder.createPlugIn(graphNode.cname, -1)) == null) {
                    Log.write("Failed to instantiate " + graphNode.cname);
                    return graphNode;
                }
                graphNode.plugin = plugIn;
            } else {
                vector.addElement(graphNode.plugin);
            }
            if ((graphNode.type == -1 || graphNode.type == 4) && graphNode.plugin instanceof Renderer) {
                ((Renderer)graphNode.plugin).setInputFormat(graphNode.input);
            } else if ((graphNode.type == -1 || graphNode.type == 2) && graphNode.plugin instanceof Codec) {
                ((Codec)graphNode.plugin).setInputFormat(graphNode.input);
                if (format != null) {
                    ((Codec)graphNode.plugin).setOutputFormat(format);
                } else if (graphNode.output != null) {
                    ((Codec)graphNode.plugin).setOutputFormat(graphNode.output);
                }
            }
            if (graphNode.type != -1 && graphNode.type != 4 || !(graphNode.plugin instanceof Renderer)) {
                try {
                    graphNode.plugin.open();
                }
                catch (Exception exception) {
                    Log.warning("Failed to open: " + graphNode.plugin);
                    graphNode.failed = true;
                    return graphNode;
                }
            }
            format = graphNode.input;
            graphNode = graphNode.prev;
        }
        Log.setIndent(this.indent--);
        return null;
    }

    void removeFailure(Vector vector, GraphNode graphNode, Format format) {
        if (graphNode.plugin == null) {
            return;
        }
        Log.comment("Failed to open plugin " + graphNode.plugin + ". Will re-build the graph allover again");
        vector.removeAllElements();
        GraphNode graphNode2 = new GraphNode(null, null, format, null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        vector.addElement(graphNode2);
        graphNode.failed = true;
        this.plugIns.put(graphNode.plugin.getClass().getName(), graphNode);
        Enumeration enumeration = this.plugIns.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            GraphNode graphNode3 = (GraphNode)this.plugIns.get(string);
            if (graphNode3.failed) continue;
            this.plugIns.remove(string);
        }
    }

    public static GraphNode getPlugInNode(String string, int n2, Hashtable hashtable) {
        GraphNode graphNode = null;
        Object var4_4 = null;
        boolean bl = false;
        if (hashtable == null || (graphNode = (GraphNode)hashtable.get(string)) == null) {
            PlugIn plugIn = SimpleGraphBuilder.createPlugIn(string, n2);
            graphNode = new GraphNode(string, plugIn, null, null, 0);
            if (hashtable != null) {
                hashtable.put(string, graphNode);
            }
            if (plugIn == null) {
                graphNode.failed = true;
                return null;
            }
            return graphNode;
        }
        if (graphNode.failed) {
            return null;
        }
        if (SimpleGraphBuilder.verifyClass(graphNode.plugin, n2)) {
            return graphNode;
        }
        return null;
    }

    public static Codec findCodec(Format format, Format format2, Format[] formatArray, Format[] formatArray2) {
        Vector vector = PlugInManager.getPlugInList(format, format2, 2);
        if (vector == null) {
            return null;
        }
        Codec codec = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            block9: {
                Format[] formatArray3;
                Format format3;
                codec = (Codec)SimpleGraphBuilder.createPlugIn((String)vector.elementAt(n2), 2);
                if (codec == null || (format3 = SimpleGraphBuilder.matches(format, formatArray3 = codec.getSupportedInputFormats(), null, (PlugIn)codec)) == null) break block9;
                if (formatArray != null && formatArray.length > 0) {
                    formatArray[0] = format3;
                }
                if ((formatArray3 = codec.getSupportedOutputFormats(format3)) == null || formatArray3.length == 0) break block9;
                boolean bl = false;
                int n3 = 0;
                while (n3 < formatArray3.length) {
                    block12: {
                        block11: {
                            block10: {
                                if (format2 == null) break block10;
                                if (format2.matches(formatArray3[n3]) && (format3 = format2.intersects(formatArray3[n3])) != null) break block11;
                                break block12;
                            }
                            format3 = formatArray3[n3];
                        }
                        if (codec.setOutputFormat(format3) != null) {
                            bl = true;
                            break;
                        }
                    }
                    ++n3;
                }
                if (bl) {
                    try {
                        codec.open();
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        // empty catch block
                    }
                    if (formatArray2 != null && formatArray2.length > 0) {
                        formatArray2[0] = format3;
                    }
                    return codec;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Renderer findRenderer(Format format) {
        Vector vector = PlugInManager.getPlugInList(format, null, 4);
        if (vector == null) {
            return null;
        }
        Renderer renderer = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            Format[] formatArray;
            Format format2;
            renderer = (Renderer)SimpleGraphBuilder.createPlugIn((String)vector.elementAt(n2), 4);
            if (renderer != null && (format2 = SimpleGraphBuilder.matches(format, formatArray = renderer.getSupportedInputFormats(), null, (PlugIn)renderer)) != null) {
                try {
                    renderer.open();
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    // empty catch block
                }
                return renderer;
            }
            ++n2;
        }
        return null;
    }

    public static Vector findRenderingChain(Format format, Vector vector) {
        SimpleGraphBuilder simpleGraphBuilder = new SimpleGraphBuilder();
        GraphNode graphNode = simpleGraphBuilder.buildGraph(format);
        if (graphNode == null) {
            return null;
        }
        Vector<PlugIn> vector2 = new Vector<PlugIn>(10);
        while (graphNode != null && graphNode.plugin != null) {
            vector2.addElement(graphNode.plugin);
            if (vector != null) {
                vector.addElement(graphNode.input);
            }
            graphNode = graphNode.prev;
        }
        return vector2;
    }

    public static PlugIn createPlugIn(String string, int n2) {
        Object t;
        try {
            Class clazz = BasicPlugIn.getClassForName(string);
            t = clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        catch (Error error) {
            return null;
        }
        if (SimpleGraphBuilder.verifyClass(t, n2)) {
            return (PlugIn)t;
        }
        return null;
    }

    public static boolean verifyClass(Object object, int n2) {
        Class clazz;
        switch (n2) {
            case 2: {
                clazz = class$javax$media$Codec == null ? (class$javax$media$Codec = SimpleGraphBuilder.class$("javax.media.Codec")) : class$javax$media$Codec;
                break;
            }
            case 4: {
                clazz = class$javax$media$Renderer == null ? (class$javax$media$Renderer = SimpleGraphBuilder.class$("javax.media.Renderer")) : class$javax$media$Renderer;
                break;
            }
            case 5: {
                clazz = class$javax$media$Multiplexer == null ? (class$javax$media$Multiplexer = SimpleGraphBuilder.class$("javax.media.Multiplexer")) : class$javax$media$Multiplexer;
                break;
            }
            default: {
                Class clazz2 = clazz = class$javax$media$PlugIn == null ? (class$javax$media$PlugIn = SimpleGraphBuilder.class$("javax.media.PlugIn")) : class$javax$media$PlugIn;
            }
        }
        return clazz.isInstance(object);
    }

    public static Format matches(Format[] formatArray, Format[] formatArray2, PlugIn plugIn, PlugIn plugIn2) {
        if (formatArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < formatArray.length) {
            Format format = SimpleGraphBuilder.matches(formatArray[n2], formatArray2, plugIn, plugIn2);
            if (format != null) {
                return format;
            }
            ++n2;
        }
        return null;
    }

    public static Format matches(Format format, Format[] formatArray, PlugIn plugIn, PlugIn plugIn2) {
        if (format == null || formatArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < formatArray.length) {
            Format format2;
            if (formatArray[n2] != null && formatArray[n2].getClass().isAssignableFrom(format.getClass()) && format.matches(formatArray[n2]) && (format2 = format.intersects(formatArray[n2])) != null && (plugIn2 == null || (format2 = SimpleGraphBuilder.verifyInput(plugIn2, format2)) != null)) {
                Format format3 = format2;
                if (!(plugIn != null && (format3 = SimpleGraphBuilder.verifyOutput(plugIn, format2)) == null || plugIn2 != null && format3 != format2 && SimpleGraphBuilder.verifyInput(plugIn2, format3) == null)) {
                    return format3;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Format matches(Format[] formatArray, Format format, PlugIn plugIn, PlugIn plugIn2) {
        Format[] formatArray2 = new Format[]{format};
        return SimpleGraphBuilder.matches(formatArray, formatArray2, plugIn, plugIn2);
    }

    public static Format verifyInput(PlugIn plugIn, Format format) {
        if (plugIn instanceof Codec) {
            return ((Codec)plugIn).setInputFormat(format);
        }
        if (plugIn instanceof Renderer) {
            return ((Renderer)plugIn).setInputFormat(format);
        }
        return null;
    }

    public static Format verifyOutput(PlugIn plugIn, Format format) {
        if (plugIn instanceof Codec) {
            return ((Codec)plugIn).setOutputFormat(format);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

