/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import codecLib.mpa.Decoder;
import codecLib.mpa.FrameInfo;
import codecLib.mpa.MPAException;
import codecLib.mpa.OutputConverter;
import com.sun.media.codec.audio.AudioCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    private int pendingDataSize = 0;
    private static final int OUTSIZE = 32768;
    private byte[] pendingData = new byte[32768];
    private Decoder decoder = null;
    private FrameInfo info = null;
    private boolean expectingSameInputBuffer = false;
    private long accumTS = 0L;
    private AudioFormat aFormat = null;
    float[][] fsamp = new float[12][1152];
    int[] fsampOffset = new int[12];
    int MAXOUTFRAMESIZE = 27648;
    int MIMINFRAMESIZE = 21;
    int outFrameSize = 0;

    public JavaDecoder() {
        this.inputFormats = new Format[]{new AudioFormat("mpeglayer3", 16000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 22050.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 24000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 32000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 44100.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 48000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1)};
    }

    public String getName() {
        return "MPEG Layer 3 Decoder";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        if (format instanceof AudioFormat) {
            AudioFormat audioFormat = (AudioFormat)format;
            this.outputFormats = new Format[]{new AudioFormat("LINEAR", audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), 1, 1)};
        } else {
            this.outputFormats = new Format[0];
        }
        return this.outputFormats;
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (this.decoder != null) {
            this.close();
        }
        try {
            this.decoder = new Decoder();
            this.pendingDataSize = 0;
            this.expectingSameInputBuffer = false;
            this.accumTS = 0L;
            this.aFormat = (AudioFormat)this.outputFormat;
            return;
        }
        catch (Throwable throwable) {
            System.out.println("mpa JavaDecoder: open " + throwable);
            throw new ResourceUnavailableException("could not open " + this.getName());
        }
    }

    public synchronized void close() {
        if (this.decoder != null) {
            this.decoder = null;
        }
        if (this.info != null) {
            this.info = null;
        }
    }

    public synchronized void reset() {
        if (this.decoder != null) {
            this.close();
            try {
                this.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                System.err.println("MP3 Decoder: " + resourceUnavailableException);
            }
        }
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        Object object = buffer.getData();
        Object object2 = buffer2.getData();
        if (object2 == null) {
            object2 = new byte[32768];
            buffer2.setData(object2);
        }
        if (!(object instanceof byte[]) || !(object2 instanceof byte[])) {
            return 1;
        }
        byte[] byArray = (byte[])object;
        byte[] byArray2 = (byte[])object2;
        int n2 = buffer.getLength();
        int n3 = buffer.getOffset();
        int n4 = byArray2.length;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (!this.expectingSameInputBuffer && this.pendingDataSize + n2 <= this.pendingData.length) {
            System.arraycopy(byArray, n3, this.pendingData, this.pendingDataSize, n2);
            this.pendingDataSize += n2;
        }
        if (this.decoder != null) {
            while (n4 - n5 >= this.MAXOUTFRAMESIZE && this.pendingDataSize >= this.MIMINFRAMESIZE) {
                if (this.info == null) {
                    this.info = new FrameInfo();
                    try {
                        this.decoder.getNextFrameInfo(this.info, this.pendingData, n6, this.pendingDataSize);
                        this.outFrameSize = this.info.getNumberOfSamples() * this.info.getNumberOfChannels() * 2;
                    }
                    catch (MPAException mPAException) {
                        this.info = null;
                        break;
                    }
                }
                try {
                    n7 = this.decoder.decode(this.fsamp, this.fsampOffset, this.pendingData, n6, this.pendingDataSize);
                }
                catch (MPAException mPAException) {
                    try {
                        this.decoder.getCurrFrameInfo(this.info);
                    }
                    catch (MPAException mPAException2) {
                        this.info = null;
                        break;
                    }
                    if (mPAException.getState() == -7) {
                        n7 = this.info.getHeaderOffset() + this.info.getFrameLength();
                        n6 += n7;
                        this.pendingDataSize -= n7;
                        continue;
                    }
                    this.info = null;
                    break;
                }
                if (this.info.getNumberOfChannels() == 1) {
                    OutputConverter.convert(byArray2, n5, this.fsamp[0], this.fsampOffset[0], this.info.getNumberOfSamples());
                } else {
                    OutputConverter.convert(byArray2, n5, this.fsamp[0], this.fsampOffset[0], this.fsamp[1], this.fsampOffset[1], this.info.getNumberOfSamples());
                }
                n5 += this.outFrameSize;
                n6 += n7;
                this.pendingDataSize -= n7;
            }
        }
        if (n6 != 0) {
            System.arraycopy(this.pendingData, n6, this.pendingData, 0, this.pendingDataSize);
        }
        buffer2.setLength(n5);
        buffer2.setFormat(this.outputFormat);
        if (this.aFormat != null && this.accumTS != 0L && buffer.getTimeStamp() > 0L) {
            buffer2.setTimeStamp(buffer.getTimeStamp() + this.aFormat.computeDuration(this.accumTS));
        }
        if (this.pendingDataSize > 1024) {
            this.expectingSameInputBuffer = true;
            this.accumTS += (long)buffer2.getLength();
            return 2;
        }
        this.accumTS = 0L;
        this.expectingSameInputBuffer = false;
        return 0;
    }
}

