/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.msadpcm;

import com.sun.media.codec.audio.msadpcm.MsAdpcmState;

public class MsAdpcm {
    private static int[] gainTable = new int[]{230, 230, 230, 230, 307, 409, 512, 614, 768, 614, 512, 409, 307, 230, 230, 230};
    private static int[] pred1Table = new int[]{256, 512, 0, 192, 240, 460, 392};
    private static int[] pred2Table = new int[]{0, -256, 0, 64, 0, -208, -232};

    protected static void decodeBlock(byte[] byArray, int n2, byte[] byArray2, int n3, int n4, MsAdpcmState[] msAdpcmStateArray, int n5) {
        int n6 = 0;
        while (n6 < n5) {
            msAdpcmStateArray[n6].bpred = byArray[n2++] & 0xFF;
            if (msAdpcmStateArray[n6].bpred >= 7) {
                msAdpcmStateArray[n6].bpred = 0;
                System.err.println("[MSADPCM] Illegal predictor value");
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < n5) {
            msAdpcmStateArray[n7].index = byArray[n2++] & 0xFF;
            msAdpcmStateArray[n7].index |= byArray[n2++] << 8;
            ++n7;
        }
        int n8 = 0;
        while (n8 < n5) {
            msAdpcmStateArray[n8].sample1 = byArray[n2++] & 0xFF;
            msAdpcmStateArray[n8].sample1 |= byArray[n2++] << 8;
            ++n8;
        }
        int n9 = 0;
        while (n9 < n5) {
            msAdpcmStateArray[n9].sample2 = byArray[n2++] & 0xFF;
            msAdpcmStateArray[n9].sample2 |= byArray[n2++] << 8;
            ++n9;
        }
        int n10 = 0;
        while (n10 < n5) {
            byArray2[n3++] = (byte)msAdpcmStateArray[n10].sample2;
            byArray2[n3++] = (byte)(msAdpcmStateArray[n10].sample2 >> 8);
            ++n10;
        }
        int n11 = 0;
        while (n11 < n5) {
            byArray2[n3++] = (byte)msAdpcmStateArray[n11].sample1;
            byArray2[n3++] = (byte)(msAdpcmStateArray[n11].sample1 >> 8);
            ++n11;
        }
        int n12 = n4;
        while (n12 > 0) {
            byte by = byArray[n2++];
            int n13 = by >> 4 & 0xF;
            MsAdpcmState msAdpcmState = msAdpcmStateArray[0];
            int n14 = n13 << 28 >> 28;
            int n15 = msAdpcmState.index;
            int n16 = msAdpcmState.sample1 * pred1Table[msAdpcmState.bpred] + msAdpcmState.sample2 * pred2Table[msAdpcmState.bpred] >> 8;
            int n17 = n14 * n15 + n16;
            if (n17 > Short.MAX_VALUE) {
                n17 = Short.MAX_VALUE;
            } else if (n17 < Short.MIN_VALUE) {
                n17 = Short.MIN_VALUE;
            }
            n15 = gainTable[n13] * n15 >> 8;
            if (n15 < 16) {
                n15 = 16;
            }
            msAdpcmState.sample2 = msAdpcmState.sample1;
            msAdpcmState.sample1 = n17;
            msAdpcmState.index = n15;
            byArray2[n3++] = (byte)n17;
            byArray2[n3++] = (byte)(n17 >> 8);
            n13 = by & 0xF;
            msAdpcmState = msAdpcmStateArray[n5 == 1 ? 0 : 1];
            n14 = n13 << 28 >> 28;
            n15 = msAdpcmState.index;
            n16 = msAdpcmState.sample1 * pred1Table[msAdpcmState.bpred] + msAdpcmState.sample2 * pred2Table[msAdpcmState.bpred] >> 8;
            n17 = n14 * n15 + n16;
            if (n17 > Short.MAX_VALUE) {
                n17 = Short.MAX_VALUE;
            } else if (n17 < Short.MIN_VALUE) {
                n17 = Short.MIN_VALUE;
            }
            n15 = gainTable[n13] * n15 >> 8;
            if (n15 < 16) {
                n15 = 16;
            }
            msAdpcmState.sample2 = msAdpcmState.sample1;
            msAdpcmState.sample1 = n17;
            msAdpcmState.index = n15;
            byArray2[n3++] = (byte)n17;
            byArray2[n3++] = (byte)(n17 >> 8);
            --n12;
        }
    }
}

