/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.rc;

import com.sun.media.codec.audio.AudioCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class RateCvrt
extends AudioCodec {
    public RateCvrt() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR")};
    }

    public String getName() {
        return "Rate Conversion";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        if (format instanceof AudioFormat) {
            AudioFormat audioFormat = (AudioFormat)format;
            int n2 = audioFormat.getSampleSizeInBits();
            int n3 = audioFormat.getChannels();
            int n4 = audioFormat.getEndian();
            int n5 = audioFormat.getSigned();
            this.outputFormats = new Format[]{new AudioFormat("LINEAR", 8000.0, n2, n3, n4, n5), new AudioFormat("LINEAR", 11025.0, n2, n3, n4, n5), new AudioFormat("LINEAR", 16000.0, n2, n3, n4, n5), new AudioFormat("LINEAR", 22050.0, n2, n3, n4, n5), new AudioFormat("LINEAR", 32000.0, n2, n3, n4, n5), new AudioFormat("LINEAR", 44100.0, n2, n3, n4, n5), new AudioFormat("LINEAR", 48000.0, n2, n3, n4, n5)};
        } else {
            this.outputFormats = new Format[0];
        }
        return this.outputFormats;
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        int n2 = buffer.getOffset();
        int n3 = buffer.getLength();
        double d2 = ((AudioFormat)this.inputFormat).getSampleRate();
        double d3 = ((AudioFormat)this.outputFormat).getSampleRate();
        int n4 = ((AudioFormat)this.inputFormat).getChannels();
        int n5 = ((AudioFormat)this.inputFormat).getSampleSizeInBits() / 8;
        int n6 = 0;
        n6 = n4 == 2 ? (n5 == 2 ? 4 : 2) : (n5 == 2 ? 2 : 1);
        if (d3 == 0.0 || d2 == 0.0) {
            return 1;
        }
        double d4 = d2 / d3;
        int n7 = (int)((double)(n3 - n2) * d3 / d2 + 0.5);
        switch (n6) {
            case 2: {
                if (n7 % 2 != 1) break;
                ++n7;
                break;
            }
            case 4: {
                if (n7 % 4 == 0) break;
                n7 = n7 / 4 + 1 << 2;
            }
        }
        if (this.inputFormat.getDataType() == Format.byteArray) {
            return this.doByteCvrt(buffer, n3, n2, buffer2, n7, n6, d4);
        }
        if (this.inputFormat.getDataType() == Format.shortArray) {
            return this.doShortCvrt(buffer, n3, n2, buffer2, n7, n6, d4);
        }
        if (this.inputFormat.getDataType() == Format.intArray) {
            return this.doIntCvrt(buffer, n3, n2, buffer2, n7, n6, d4);
        }
        return 1;
    }

    private int doByteCvrt(Buffer buffer, int n2, int n3, Buffer buffer2, int n4, int n5, double d2) {
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, n4);
        int n6 = 0;
        buffer2.setData(byArray2);
        buffer2.setFormat(this.outputFormat);
        buffer2.setOffset(0);
        buffer2.setLength(n4);
        double d3 = 0.0;
        int n7 = n3;
        int n8 = n6;
        int n9 = n3 + n2;
        if (d2 == 1.0) {
            System.arraycopy(byArray, n3, byArray2, n6, n2);
            return 0;
        }
        if (d2 > 1.0) {
            while (n7 <= n9 - n5 && n8 <= n4 - n5) {
                int n10 = 0;
                while (n10 < n5) {
                    byArray2[n8++] = byArray[n7 + n10];
                    ++n10;
                }
                d3 += d2;
                while (d3 > 0.0) {
                    n7 += n5;
                    d3 -= 1.0;
                }
            }
        } else {
            byte[] byArray3 = new byte[n5];
            while (n7 <= n9 - n5) {
                int n11 = 0;
                while (n11 < n5) {
                    byArray2[n8++] = byArray[n7 + n11];
                    byArray3[n11] = byArray[n7 + n11];
                    ++n11;
                }
                while ((d3 += d2) < 1.0) {
                    if (n8 > n4 - n5) continue;
                    int n12 = 0;
                    while (n12 < n5) {
                        byArray2[n8++] = byArray3[n12];
                        ++n12;
                    }
                }
                d3 -= 1.0;
                n7 += n5;
            }
        }
        return 0;
    }

    private int doShortCvrt(Buffer buffer, int n2, int n3, Buffer buffer2, int n4, int n5, double d2) {
        short[] sArray = (short[])buffer.getData();
        short[] sArray2 = this.validateShortArraySize(buffer2, n4);
        int n6 = 0;
        buffer2.setData(sArray2);
        buffer2.setFormat(this.outputFormat);
        buffer2.setOffset(0);
        buffer2.setLength(n4);
        double d3 = 0.0;
        int n7 = n3;
        int n8 = n6;
        int n9 = n3 + n2;
        if (d2 == 1.0) {
            System.arraycopy(sArray, n3, sArray2, n6, n2);
            return 0;
        }
        if (d2 > 1.0) {
            while (n7 <= n9 - n5 && n8 <= n4 - n5) {
                int n10 = 0;
                while (n10 < n5) {
                    sArray2[n8++] = sArray[n7 + n10];
                    ++n10;
                }
                d3 += d2;
                while (d3 > 0.0) {
                    n7 += n5;
                    d3 -= 1.0;
                }
            }
        } else {
            short[] sArray3 = new short[n5];
            while (n7 <= n9 - n5) {
                int n11 = 0;
                while (n11 < n5) {
                    sArray2[n8++] = sArray[n7 + n11];
                    sArray3[n11] = sArray[n7 + n11];
                    ++n11;
                }
                while ((d3 += d2) < 1.0) {
                    if (n8 > n4 - n5) continue;
                    int n12 = 0;
                    while (n12 < n5) {
                        sArray2[n8++] = sArray3[n12];
                        ++n12;
                    }
                }
                d3 -= 1.0;
                n7 += n5;
            }
        }
        return 0;
    }

    private int doIntCvrt(Buffer buffer, int n2, int n3, Buffer buffer2, int n4, int n5, double d2) {
        int[] nArray = (int[])buffer.getData();
        int[] nArray2 = this.validateIntArraySize(buffer2, n4);
        int n6 = 0;
        buffer2.setData(nArray2);
        buffer2.setFormat(this.outputFormat);
        buffer2.setOffset(0);
        buffer2.setLength(n4);
        double d3 = 0.0;
        int n7 = n3;
        int n8 = n6;
        int n9 = n3 + n2;
        if (d2 == 1.0) {
            System.arraycopy(nArray, n3, nArray2, n6, n2);
            return 0;
        }
        if (d2 > 1.0) {
            while (n7 <= n9 - n5 && n8 <= n4 - n5) {
                int n10 = 0;
                while (n10 < n5) {
                    nArray2[n8++] = nArray[n7 + n10];
                    ++n10;
                }
                d3 += d2;
                while (d3 > 0.0) {
                    n7 += n5;
                    d3 -= 1.0;
                }
            }
        } else {
            int[] nArray3 = new int[n5];
            while (n7 <= n9 - n5) {
                int n11 = 0;
                while (n11 < n5) {
                    nArray2[n8++] = nArray[n7 + n11];
                    nArray3[n11] = nArray[n7 + n11];
                    ++n11;
                }
                while ((d3 += d2) < 1.0) {
                    if (n8 > n4 - n5) continue;
                    int n12 = 0;
                    while (n12 < n5) {
                        nArray2[n8++] = nArray3[n12];
                        ++n12;
                    }
                }
                d3 -= 1.0;
                n7 += n5;
            }
        }
        return 0;
    }
}

