/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.h261;

import com.ibm.media.codec.video.VideoCodec;
import com.sun.media.JMFSecurityManager;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class NativeDecoder
extends VideoCodec {
    public static final int[] widths = new int[]{176, 352};
    public static final int[] heights = new int[]{144, 288};
    private int nativeData;
    int h261Flags;
    int syncBit = 0;
    int skipBytes = 0;
    int nframes = 0;
    int sizeChanged = 0;
    private int width = 352;
    private int height = 288;
    private boolean formatSizeInitFlag = false;

    private native boolean initNativeDecoder();

    private native boolean freeNativeDecoder();

    private native void allocatePicture(int var1);

    private native boolean decodeNative(Buffer var1, Buffer var2, long var3);

    public NativeDecoder() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("h261"), new VideoFormat("h261/rtp")};
        this.defaultOutputFormats = new VideoFormat[]{new YUVFormat()};
        this.PLUGIN_NAME = "H.261 Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = videoFormat.getSize();
        int n2 = videoFormat.getMaxDataLength();
        if (videoFormat.getEncoding().equals("h261/rtp")) {
            if (dimension != null) {
                Dimension dimension2 = this.movieSizeTo261Size(dimension);
                this.width = dimension2.width;
                this.height = dimension2.height;
            }
            int n3 = this.width * this.height;
            this.supportedOutputFormats = new VideoFormat[]{new YUVFormat(new Dimension(this.width, this.height), n3 + (n3 >> 1), Format.byteArray, videoFormat.getFrameRate(), 2, this.width, this.width >> 1, 0, n3, n3 + (n3 >> 2))};
        } else {
            Dimension dimension3 = this.movieSizeTo261Size(dimension);
            this.width = dimension3.width;
            this.height = dimension3.height;
            int n4 = dimension3.width * dimension3.height;
            this.supportedOutputFormats = new VideoFormat[]{new YUVFormat(dimension, n4 + (n4 >> 1), Format.byteArray, videoFormat.getFrameRate(), 2, dimension3.width, dimension3.width >> 1, 0, n4, n4 + (n4 >> 2))};
        }
        return this.supportedOutputFormats;
    }

    public Format setInputFormat(Format format) {
        Format format2 = super.setInputFormat(format);
        if (format2 == null) {
            return null;
        }
        if (this.opened) {
            try {
                this.close();
                this.outputFormat = (VideoFormat)this.getMatchingOutputFormats(format2)[0];
                this.open();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return format2;
    }

    public void open() throws ResourceUnavailableException {
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmh261");
            this.initNativeDecoder();
            this.allocateBuffer();
            super.open();
            return;
        }
        catch (Throwable throwable) {
            System.err.println("could not open " + this.PLUGIN_NAME + ". reason:");
            System.err.println(throwable);
            throw new ResourceUnavailableException("Could not open " + this.PLUGIN_NAME);
        }
    }

    public void close() {
        this.freeNativeDecoder();
        super.close();
    }

    public void reset() {
    }

    protected void videoResized() {
        this.initNativeDecoder();
        this.allocateBuffer();
    }

    protected void allocateBuffer() {
        int n2 = 101376;
        n2 = 4 * (n2 + n2 / 2);
        this.allocatePicture(n2);
    }

    public void findStartCode(Buffer buffer) {
        byte[] byArray = (byte[])buffer.getData();
        int n2 = 1;
        while (byArray[n2] == 0) {
            ++n2;
        }
        this.skipBytes = n2 - 1;
        if (byArray[n2] != 1) {
            --this.skipBytes;
            if ((byArray[n2] & 0x80) != 0) {
                this.h261Flags |= 0x20000000;
            } else if ((byArray[n2] & 0x40) != 0) {
                this.h261Flags |= 0x40000000;
            } else if ((byArray[n2] & 0x20) != 0) {
                this.h261Flags |= 0x60000000;
            } else if ((byArray[n2] & 0x10) != 0) {
                this.h261Flags |= Integer.MIN_VALUE;
            } else if ((byArray[n2] & 8) != 0) {
                this.h261Flags |= 0xA0000000;
            } else if ((byArray[n2] & 4) != 0) {
                this.h261Flags |= 0xC0000000;
            } else if ((byArray[n2] & 2) != 0) {
                this.h261Flags |= 0xE0000000;
            }
        }
        n2 = buffer.getLength() - 1;
        while (byArray[n2] == 0) {
            --n2;
        }
        if (n2 == 1) {
            buffer.setLength(n2 - 1);
        } else {
            switch (byArray[n2] & 0xFF) {
                case 1: {
                    break;
                }
                case 2: {
                    this.h261Flags |= 0x4000000;
                    break;
                }
                case 4: {
                    this.h261Flags |= 0x8000000;
                    break;
                }
                case 8: {
                    this.h261Flags |= 0xC000000;
                    break;
                }
                case 16: {
                    this.h261Flags |= 0x10000000;
                    break;
                }
                case 32: {
                    this.h261Flags |= 0x14000000;
                    break;
                }
                case 64: {
                    this.h261Flags |= 0x18000000;
                    break;
                }
                case 128: {
                    this.h261Flags |= 0x1C000000;
                }
            }
            buffer.setLength(n2 - 1);
        }
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n2;
        boolean bl = false;
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        VideoFormat videoFormat = (VideoFormat)buffer.getFormat();
        int n3 = buffer.getLength();
        int n4 = videoFormat.getMaxDataLength();
        byte[] byArray = (byte[])buffer.getData();
        if (videoFormat.getEncoding().equals("h261/rtp")) {
            bl = true;
            n2 = buffer.getOffset();
            this.h261Flags = (byArray[n2] << 24) + ((byArray[n2 + 1] & 0xFF) << 16) + ((byArray[n2 + 2] & 0xFF) << 8) + (byArray[n2 + 3] & 0xFF);
            this.syncBit = (buffer.getFlags() & 0x800) != 0 ? 1 : 0;
            this.skipBytes = 4;
            if (byArray[n2 + this.skipBytes] == 0 && byArray[n2 + this.skipBytes + 1] == 1 && (byArray[n2 + this.skipBytes + 2] & 0xFC) == 0) {
                int n5 = byArray[n2 + this.skipBytes + 3] >> 3 & 1;
                if (this.width != widths[n5] || this.height != heights[n5]) {
                    this.width = widths[n5];
                    this.height = heights[n5];
                    int n6 = this.width * this.height;
                    this.close();
                    this.outputFormat = new YUVFormat(new Dimension(this.width, this.height), n6 + (n6 >> 1), Format.byteArray, videoFormat.getFrameRate(), 2, this.width, this.width >> 1, 0, n6, n6 + (n6 >> 2));
                    try {
                        this.open();
                    }
                    catch (Exception exception) {
                        return 1;
                    }
                }
                this.formatSizeInitFlag = true;
            }
        } else {
            this.h261Flags = 0x1000000;
            this.syncBit = 1;
            this.findStartCode(buffer);
        }
        buffer2.setFormat(this.outputFormat);
        n2 = this.outputFormat.getMaxDataLength();
        Object object = this.validateData(buffer2, n2 * 2, true);
        long l2 = this.getNativeData(object);
        boolean bl2 = this.decodeNative(buffer, buffer2, l2);
        if (bl2 && this.syncBit == 1) {
            this.updateOutput(buffer2, this.outputFormat, n2, 0);
            return 0;
        }
        return 4;
    }

    private Dimension movieSizeTo261Size(Dimension dimension) {
        int n2 = dimension.width + 15 & 0xFFFFFFF0;
        int n3 = dimension.height + 15 & 0xFFFFFFF0;
        int n4 = n2 * n3 >> 8;
        if (n4 <= 99) {
            return new Dimension(176, 144);
        }
        if (n4 <= 396) {
            return new Dimension(352, 288);
        }
        return new Dimension(0, 0);
    }

    public boolean checkFormat(Format format) {
        if (format.getEncoding().equals("h261/rtp")) {
            return true;
        }
        return super.checkFormat(format);
    }
}

