/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.codec.video.jpeg.RTPDePacketizer;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.JPEGFormat;
import javax.media.format.VideoFormat;

public class DePacketizer
extends BasicCodec {
    private VideoFormat inputFormat = null;
    private JPEGFormat outputFormat = null;
    private int decimation = -1;
    private int quality = -1;
    private RTPDePacketizer rtpdp = null;
    int DEFAULT_WIDTH = 320;
    int DEFAULT_HEIGHT = 240;

    public DePacketizer() {
        this.inputFormats = new Format[]{new VideoFormat("jpeg/rtp")};
        this.outputFormats = new Format[]{new VideoFormat("jpeg")};
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (BasicPlugIn.matches(format, this.inputFormats) == null) {
            return new Format[0];
        }
        Format[] formatArray = new Format[]{this.makeJPEGFormat(format)};
        return formatArray;
    }

    public Format setInputFormat(Format format) {
        this.inputFormat = (VideoFormat)format;
        if (this.opened) {
            this.outputFormat = this.makeJPEGFormat(this.inputFormat);
        }
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof VideoFormat)) {
            return null;
        }
        this.outputFormat = this.makeJPEGFormat(format);
        return this.outputFormat;
    }

    private final JPEGFormat makeJPEGFormat(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        return new JPEGFormat(videoFormat.getSize() != null ? videoFormat.getSize() : new Dimension(this.DEFAULT_WIDTH, this.DEFAULT_HEIGHT), -1, Format.byteArray, videoFormat.getFrameRate(), this.quality, this.decimation);
    }

    public void open() throws ResourceUnavailableException {
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Incorrect formats set on JPEG converter");
        }
        this.rtpdp = new RTPDePacketizer();
        super.open();
    }

    public synchronized void close() {
        this.rtpdp = null;
        super.close();
    }

    public void reset() {
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (buffer.isDiscard()) {
            this.updateOutput(buffer2, this.outputFormat, 0, 0);
            buffer2.setDiscard(true);
            return 4;
        }
        int n2 = this.rtpdp.process(buffer, buffer2);
        if (n2 != 0) {
            return n2;
        }
        int n3 = this.rtpdp.getType();
        int n4 = this.rtpdp.getQuality();
        if (n3 != this.decimation || n4 != this.quality) {
            this.decimation = n3;
            this.quality = n4;
            this.outputFormat = this.makeJPEGFormat(buffer.getFormat());
        }
        buffer2.setFormat(this.outputFormat);
        buffer2.setOffset(0);
        buffer2.setTimeStamp(buffer.getTimeStamp());
        buffer.setLength(0);
        buffer2.setFlags(buffer2.getFlags() | 0x10);
        return 0;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "JPEG DePacketizer";
    }
}

