/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_jmx;

import com.sun.media.BasicPlayer;
import com.sun.media.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.renderer.VisualContainer;

public class Handler
extends BasicPlayer {
    Player[] players = null;
    Player master = null;
    boolean[] realized = null;
    Vector locators = new Vector();
    ControllerListener listener = new PlayerListener(this);
    boolean playersRealized = false;
    Object realizedSync = new Object();
    private boolean closed = false;
    private boolean audioEnabled = false;
    private boolean videoEnabled = false;
    String sessionError = "Cannot create a Player for: ";
    private Container container = null;

    public Handler() {
        this.framePositioning = true;
    }

    protected boolean doRealize() {
        super.doRealize();
        MediaLocator mediaLocator = null;
        try {
            this.players = new Player[this.locators.size()];
            this.realized = new boolean[this.locators.size()];
            int n2 = 0;
            while (n2 < this.locators.size()) {
                mediaLocator = (MediaLocator)this.locators.elementAt(n2);
                this.players[n2] = Manager.createPlayer(mediaLocator);
                this.players[n2].addControllerListener(this.listener);
                this.realized[n2] = false;
                this.players[n2].realize();
                ++n2;
            }
        }
        catch (Exception exception) {
            Log.error(this.sessionError + mediaLocator);
            this.processError = this.sessionError + mediaLocator;
            return false;
        }
        try {
            Object object = this.realizedSync;
            synchronized (object) {
                while (!(this.playersRealized || this.isInterrupted() || this.closed)) {
                    this.realizedSync.wait();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.closed || this.isInterrupted()) {
            this.resetInterrupt();
            this.processError = "Realize interrupted";
            return false;
        }
        try {
            this.master = this.players[0];
            int n3 = 1;
            while (n3 < this.players.length) {
                this.master.addController(this.players[n3]);
                ++n3;
            }
        }
        catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
            this.processError = "AddController failed";
            return false;
        }
        this.manageController(this.master);
        return true;
    }

    protected void completeRealize() {
        this.state = 300;
        super.completeRealize();
    }

    protected void doStart() {
        super.doStart();
    }

    protected void doStop() {
        super.doStop();
    }

    protected void doDeallocate() {
        Object object = this.realizedSync;
        synchronized (object) {
            this.realizedSync.notify();
        }
    }

    protected void doClose() {
        this.closed = true;
        Object object = this.realizedSync;
        synchronized (object) {
            this.realizedSync.notify();
        }
        this.stop();
        super.doClose();
    }

    protected TimeBase getMasterTimeBase() {
        return this.master.getTimeBase();
    }

    protected boolean audioEnabled() {
        return this.audioEnabled;
    }

    protected boolean videoEnabled() {
        return this.videoEnabled;
    }

    private void sendMyEvent(ControllerEvent controllerEvent) {
        super.sendEvent(controllerEvent);
    }

    /*
     * Unable to fully structure code
     */
    public void setSource(DataSource var1_1) throws IOException, IncompatibleSourceException {
        block14: {
            block13: {
                super.setSource(var1_1);
                if (!(var1_1 instanceof PullDataSource)) {
                    throw new IncompatibleSourceException();
                }
                var2_2 = ((PullDataSource)var1_1).getStreams();
                if (var2_2.length != 1) {
                    throw new IncompatibleSourceException();
                }
                var1_1.start();
                var3_3 = (int)var2_2[0].getContentLength();
                if ((long)var3_3 == -1L) {
                    throw new IncompatibleSourceException();
                }
                var4_4 = new byte[var3_3];
                try {
                    var3_3 = var2_2[0].read(var4_4, 0, var3_3);
                    var5_5 = new String(var4_4);
                }
                catch (Exception var6_6) {
                    throw new IncompatibleSourceException();
                }
                var7_8 = 0;
                var9_9 = var5_5.length();
                var11_10 = null;
                var6_7 = var5_5.charAt(var7_8);
                break block13;
                while (++var7_8 < var9_9) {
                    var6_7 = var5_5.charAt(var7_8);
lbl25:
                    // 2 sources

                    ** while (var6_7 != ' ' && var6_7 != '\n')
lbl26:
                    // 1 sources

                }
lbl27:
                // 2 sources

                if (var7_8 >= var9_9) break block14;
                var8_11 = var7_8;
                while (++var8_11 < var9_9 && (var6_7 = var5_5.charAt(var8_11)) != '\n') {
                }
                var10_12 = var5_5.substring(var7_8, var8_11);
                if (var10_12.indexOf(58) == -1) {
                    if (var11_10 == null) {
                        var12_13 = var1_1.getLocator();
                        if (var12_13 == null) {
                            throw new IncompatibleSourceException();
                        }
                        var11_10 = var12_13.toString();
                        var13_14 = var11_10.lastIndexOf(47);
                        if (var13_14 < 0) {
                            var13_14 = var11_10.lastIndexOf(File.separator);
                        }
                        var11_10 = var11_10.substring(0, var13_14 + 1);
                    }
                    var10_12 = var11_10 + var10_12;
                }
                this.locators.addElement(new MediaLocator(var10_12));
                var7_8 = var8_11;
            }
            if (var7_8 < var9_9) ** GOTO lbl25
        }
        if (this.locators.size() < 1) {
            throw new IncompatibleSourceException();
        }
    }

    private void invalidateComp() {
        this.controlComp = null;
        this.controls = null;
    }

    public Component getVisualComponent() {
        Vector<Component> vector = new Vector<Component>(1);
        int n2 = 0;
        while (n2 < this.players.length) {
            Component component = this.players[n2].getVisualComponent();
            if (component != null) {
                vector.addElement(component);
            }
            ++n2;
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (Component)vector.elementAt(0);
        }
        return this.createVisualContainer(vector);
    }

    protected Component createVisualContainer(Vector vector) {
        Boolean bl = (Boolean)Manager.getHint(3);
        if (this.container == null) {
            this.container = bl == null || bl == false ? new HeavyPanel(vector) : new LightPanel(vector);
            this.container.setLayout(new FlowLayout());
            this.container.setBackground(Color.black);
            int n2 = 0;
            while (n2 < vector.size()) {
                Component component = (Component)vector.elementAt(n2);
                this.container.add(component);
                component.setSize(component.getPreferredSize());
                ++n2;
            }
        }
        return this.container;
    }

    public void updateStats() {
        int n2 = 0;
        while (n2 < this.players.length) {
            if (this.players[n2] != null) {
                ((BasicPlayer)this.players[n2]).updateStats();
            }
            ++n2;
        }
    }

    class PlayerListener
    implements ControllerListener {
        Handler handler;

        public PlayerListener(Handler handler2) {
            this.handler = handler2;
        }

        public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
            Player player = (Player)controllerEvent.getSourceController();
            if (player == null) {
                return;
            }
            int n2 = 0;
            while (n2 < Handler.this.players.length) {
                if (Handler.this.players[n2] == player) break;
                ++n2;
            }
            if (n2 >= Handler.this.players.length) {
                System.err.println("Unknown player: " + player);
                return;
            }
            if (controllerEvent instanceof RealizeCompleteEvent) {
                Handler.this.realized[n2] = true;
                int n3 = 0;
                while (n3 < Handler.this.realized.length) {
                    if (!Handler.this.realized[n3]) {
                        return;
                    }
                    ++n3;
                }
                Object object = Handler.this.realizedSync;
                synchronized (object) {
                    Handler.this.playersRealized = true;
                    Handler.this.realizedSync.notifyAll();
                }
            }
            if (controllerEvent instanceof ControllerErrorEvent) {
                Handler.this.players[n2].removeControllerListener(this);
                Log.error("Meta Handler internal error: " + controllerEvent);
                Handler.this.players[n2] = null;
            }
        }
    }

    class LightPanel
    extends Container
    implements VisualContainer {
        public LightPanel(Vector vector) {
        }
    }

    class HeavyPanel
    extends Panel
    implements VisualContainer {
        public HeavyPanel(Vector vector) {
        }
    }
}

