/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.DisplayList;
import com.sun.media.content.application.x_shockwave_flash.RColor;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

final class Bitmap
implements ImageConsumer {
    int width;
    int height;
    int bpp;
    byte[] pixels8;
    int[] pixels32;
    ColorModel colorModel;
    DisplayList display;
    private boolean loaded;
    private boolean grabbing;
    private int flags;
    private ImageProducer producer;
    private static int[][][] PixCoverage = new int[8][8][4];
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int RGBSlabChunkSize = 256;
    private static int[] pixBuf;
    private int n;
    private int[] ce = new int[4];

    Bitmap(ImageProducer imageProducer, DisplayList displayList) {
        this.producer = imageProducer;
        this.display = displayList;
        imageProducer.startProduction(this);
        this.grabBits();
    }

    Bitmap(Image image, DisplayList displayList) {
        this(image.getSource(), displayList);
        image.flush();
    }

    Bitmap(int[] nArray, int n2, int n3, DisplayList displayList) {
        this.pixels32 = nArray;
        this.width = n2;
        this.height = n3;
        this.display = displayList;
        this.bpp = 32;
    }

    Bitmap(byte[] byArray, int n2, int n3, DisplayList displayList) {
        this.pixels8 = byArray;
        this.width = n2;
        this.height = n3;
        this.display = displayList;
        this.bpp = 8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void grabBits() {
        int n2;
        this.grabbing = true;
        try {
            int n3;
            block9: {
                try {
                    while (this.grabbing && this.producer != null) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.pixels8 = null;
                    this.pixels32 = null;
                    this.height = 0;
                    this.width = 0;
                    this.loaded = false;
                    Object var3_2 = null;
                    this.grabbing = false;
                    this.producer = null;
                    if (!this.loaded) return;
                    if (this.pixels32 == null) return;
                    n3 = this.width * this.height;
                    break block9;
                }
                Object var3_1 = null;
                this.grabbing = false;
                this.producer = null;
                if (!this.loaded) return;
                if (this.pixels32 == null) return;
                int n4 = this.width * this.height;
                while (n4 > 0) {
                    int n5 = --n4;
                    this.pixels32[n5] = this.pixels32[n5] | 0xFF000000;
                }
                return;
            }
            while (n3 > 0) {
                int n6 = --n3;
                this.pixels32[n6] = this.pixels32[n6] | 0xFF000000;
            }
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.grabbing = false;
            this.producer = null;
            if (!this.loaded) throw throwable;
            if (this.pixels32 == null) throw throwable;
            n2 = this.width * this.height;
        }
        while (true) {
            if (n2 <= 0) {
                throw throwable;
            }
            int n7 = --n2;
            this.pixels32[n7] = this.pixels32[n7] | 0xFF000000;
        }
    }

    synchronized int status() {
        return this.flags;
    }

    public synchronized void imageComplete(int n2) {
        this.loaded = n2 == 3;
        this.grabbing = false;
        switch (n2) {
            default: {
                this.flags |= 0xC0;
                break;
            }
            case 4: {
                this.flags |= 0x80;
                break;
            }
            case 3: {
                this.flags |= 0x20;
                break;
            }
            case 2: {
                this.flags |= 0x10;
            }
        }
        if (this.producer != null) {
            this.producer.removeConsumer(this);
        }
        this.producer = null;
        this.notify();
    }

    public void setColorModel(ColorModel colorModel) {
        this.colorModel = colorModel;
    }

    public void setDimensions(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public void setHints(int n2) {
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, byte[] byArray, int n6, int n7) {
        if (this.pixels8 == null) {
            this.pixels8 = new byte[this.width * this.height];
            this.bpp = 8;
        }
        System.arraycopy(byArray, n6, this.pixels8, this.width * n3 + n2, n7);
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, int[] nArray, int n6, int n7) {
        if (this.pixels32 == null) {
            this.pixels32 = new int[this.width * this.height];
            this.bpp = 32;
        }
        System.arraycopy(nArray, n6, this.pixels32, this.width * n3 + n2, n7);
    }

    public void setProperties(Hashtable hashtable) {
    }

    private static void buildCoverageTable() {
        int n2 = 0;
        while (n2 < 8) {
            int n3 = 0;
            while (n3 < 8) {
                Bitmap.PixCoverage[n2][n3][0] = (8 - n2) * (8 - n3);
                Bitmap.PixCoverage[n2][n3][1] = n2 * (8 - n3);
                Bitmap.PixCoverage[n2][n3][2] = (8 - n2) * n3;
                Bitmap.PixCoverage[n2][n3][3] = n2 * n3;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while (n6 <= 3) {
                    Bitmap.PixCoverage[n2][n3][n6] = (PixCoverage[n2][n3][n6] + 4) / 8;
                    n5 += PixCoverage[n2][n3][n6];
                    if (PixCoverage[n2][n3][n6] > PixCoverage[n2][n3][n4]) {
                        n4 = n6;
                    }
                    ++n6;
                }
                int n7 = 8 - n5;
                int[] nArray = PixCoverage[n2][n3];
                int n8 = n4;
                nArray[n8] = nArray[n8] + n7;
                ++n3;
            }
            ++n2;
        }
    }

    static int LimitAbs(int n2, int n3) {
        int n4 = n2 / n3;
        if (n2 < 0) {
            --n4;
        }
        return n2 - n4 * n3;
    }

    static int LimitAbsI(int n2, int n3) {
        int n4 = n2 / n3;
        if (n2 < 0) {
            --n4;
        }
        return n2 - n4 * n3;
    }

    private int CalcLimit(int n2, int n3, int n4) {
        if (n3 > 0) {
            while (n2 > n4) {
                n2 -= n4;
            }
            int n5 = (n4 - n2 + n3 - 1) / n3;
            if (this.n > n5) {
                this.n = n5;
            }
        } else if (n3 < 0) {
            while (n2 < 0) {
                n2 += n4;
            }
            int n6 = (n2 - n3 - 1) / -n3;
            if (this.n > n6) {
                this.n = n6;
            }
        }
        return n2;
    }

    private void UnpackPix32(int n2, int[] nArray) {
        nArray[0] = n2 >>> 16 & 0xFF;
        nArray[1] = n2 >>> 8 & 0xFF;
        nArray[2] = n2 & 0xFF;
    }

    private static int Pix32ToWide(int n2) {
        return (n2 & 0xFF0000) << 5 | (n2 & 0xFF00) << 2 | (n2 & 0xFF) >>> 1;
    }

    private void WideToRGBI(int n2, int[] nArray) {
        nArray[0] = n2 >>> 24;
        nArray[1] = n2 >>> 13 & 0xFF;
        nArray[2] = n2 >>> 2 & 0xFF;
    }

    int GetRGBPixel(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.height) {
            n3 = this.height - 1;
        }
        if (n2 >= this.width) {
            n2 = this.width - 1;
        }
        int n4 = n3 * this.width;
        if (this.bpp == 8) {
            return this.display.IndexToRGB(this.pixels8[n4 + n2]);
        }
        return this.pixels32[n4 + n2];
    }

    int GetSSRGBPixel(int n2, int n3) {
        int n4;
        int n5 = n2 >> 16;
        int n6 = n3 >> 16;
        int n7 = (n2 & 0xFFFF) >> 13;
        int n8 = (n3 & 0xFFFF) >> 13;
        this.ce[0] = PixCoverage[n7][n8][0];
        this.ce[1] = PixCoverage[n7][n8][1];
        this.ce[2] = PixCoverage[n7][n8][2];
        this.ce[3] = PixCoverage[n7][n8][3];
        if (n5 < 0) {
            n5 = 0;
            this.ce[0] = this.ce[0] + this.ce[1];
            this.ce[1] = 0;
            this.ce[2] = this.ce[2] + this.ce[3];
            this.ce[3] = 0;
        } else if (n5 >= this.width - 1) {
            n5 = this.width - 2;
            this.ce[1] = this.ce[1] + this.ce[0];
            this.ce[0] = 0;
            this.ce[3] = this.ce[3] + this.ce[2];
            this.ce[2] = 0;
        }
        if (n6 < 0) {
            n6 = 0;
            this.ce[0] = this.ce[0] + this.ce[2];
            this.ce[2] = 0;
            this.ce[1] = this.ce[1] + this.ce[3];
            this.ce[3] = 0;
        } else if (n6 >= this.height - 1) {
            n6 = this.height - 2;
            this.ce[2] = this.ce[2] + this.ce[0];
            this.ce[0] = 0;
            this.ce[3] = this.ce[3] + this.ce[1];
            this.ce[1] = 0;
        }
        long l2 = 0L;
        int n9 = n6 * this.width;
        if (this.bpp != 8) {
            n4 = n9 + n5;
            l2 = (long)Bitmap.Pix32ToWide(this.pixels32[n4]) * (long)this.ce[0];
            l2 += (long)Bitmap.Pix32ToWide(this.pixels32[n4 + 1]) * (long)this.ce[1];
            l2 += (long)Bitmap.Pix32ToWide(this.pixels32[n4 += this.width]) * (long)this.ce[2];
            l2 += (long)Bitmap.Pix32ToWide(this.pixels32[n4 + 1]) * (long)this.ce[3];
        }
        n4 = (int)l2;
        return n4 >>> 8 & 0xFF0000 | n4 >>> 5 & 0xFF00 | n4 >>> 2 & 0xFF;
    }

    /*
     * Unable to fully structure code
     */
    void Blt32to8(RColor var1_1, Point var2_2, int var3_3, byte[] var4_4, int var5_5) {
        block3: {
            if (var1_1.bmDy != 0) ** GOTO lbl17
            var6_6 = (var2_2.y >> 16) * this.width;
            if (Math.abs(var1_1.bmDx - 65536) >= 256) ** GOTO lbl12
            var6_6 += var2_2.x >> 16;
            var2_2.x += var3_3 * var1_1.bmDx;
            while (var3_3-- > 0) {
                var4_4[var5_5++] = (byte)this.display.RGBToIndex(this.pixels32[var6_6++]);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var4_4[var5_5++] = (byte)this.display.RGBToIndex(this.pixels32[var6_6 + (var2_2.x >> 16)]);
                var2_2.x += var1_1.bmDx;
lbl12:
                // 2 sources

                ** while (var3_3-- > 0)
            }
lbl13:
            // 1 sources

            break block3;
lbl-1000:
            // 1 sources

            {
                var4_4[var5_5++] = (byte)this.display.RGBToIndex(this.pixels32[(var2_2.y >> 16) * this.width + (var2_2.x >> 16)]);
                var2_2.x += var1_1.bmDx;
                var2_2.y += var1_1.bmDy;
lbl17:
                // 2 sources

                ** while (var3_3-- > 0)
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void Blt32to32(RColor var1_1, Point var2_2, int var3_3, int[] var4_4, int var5_5) {
        block3: {
            if (var1_1.bmDy != 0) ** GOTO lbl17
            var6_6 = (var2_2.y >> 16) * this.width;
            if (Math.abs(var1_1.bmDx - 65536) >= 256) ** GOTO lbl12
            var6_6 += var2_2.x >> 16;
            var2_2.x += var3_3 * var1_1.bmDx;
            while (var3_3-- > 0) {
                var4_4[var5_5++] = this.pixels32[var6_6++];
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var4_4[var5_5++] = this.pixels32[var6_6 + (var2_2.x >> 16)];
                var2_2.x += var1_1.bmDx;
lbl12:
                // 2 sources

                ** while (var3_3-- > 0)
            }
lbl13:
            // 1 sources

            break block3;
lbl-1000:
            // 1 sources

            {
                var4_4[var5_5++] = this.pixels32[(var2_2.y >> 16) * this.width + (var2_2.x >> 16)];
                var2_2.x += var1_1.bmDx;
                var2_2.y += var1_1.bmDy;
lbl17:
                // 2 sources

                ** while (var3_3-- > 0)
            }
        }
    }

    private void Blt32toI(RColor rColor, Point point, int n2, int[] nArray) {
        int n3 = 0;
        if (rColor.bmDy == 0) {
            int n4 = (point.y >> 16) * this.width;
            int n5 = n2;
            while (n5 > 0) {
                nArray[n3] = this.pixels32[n4 + (point.x >> 16)];
                ++n3;
                point.x += rColor.bmDx;
                --n5;
            }
        } else {
            int n6 = n2;
            while (n6 > 0) {
                nArray[n3] = this.pixels32[(point.y >> 16) * this.width + (point.x >> 16)];
                ++n3;
                point.x += rColor.bmDx;
                point.y += rColor.bmDy;
                --n6;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void DrawSlab(int var1_1, int var2_2, int var3_3, RColor var4_4) {
        block23: {
            var5_5 = new Point(0, 0);
            var6_6 = this.display.pixels8;
            var7_7 = this.display.pixels32;
            var5_5.x = var2_2 << 16;
            var5_5.y = this.display.bitY << 16;
            var4_4.bmInvMat.transform(var5_5, var5_5);
            var8_8 = this.width << 16;
            var9_9 = this.height << 16;
            if (var4_4.fillType == 65) {
                var13_10 = this.width;
                var14_11 = this.height;
                if (var4_4.bmSmooth) {
                    --var14_11;
                    --var13_10;
                }
                var15_12 = new Point(0, 0);
                var16_13 = var3_3 - var2_2;
                var15_12.x = var5_5.x + var4_4.bmDx * var16_13;
                var15_12.y = var5_5.y + var4_4.bmDy * var16_13;
                while (true) {
                    var10_14 = var5_5.x >> 16;
                    var11_15 = var5_5.y >> 16;
                    if (var10_14 >= 0 && var11_15 >= 0 && var10_14 < var13_10 && var11_15 < var14_11 || var2_2 >= var3_3) break;
                    var12_16 = var4_4.bmSmooth != false ? this.GetSSRGBPixel(var5_5.x, var5_5.y) : this.GetRGBPixel(var10_14, var11_15);
                    if (var4_4.cx != null) {
                        var12_16 = var4_4.cx.ApplyColorMap(var12_16);
                    }
                    if (var6_6 != null) {
                        var6_6[var2_2 + var1_1] = (byte)this.display.RGBToIndex(var12_16);
                    } else {
                        var7_7[var2_2 + var1_1] = var12_16;
                    }
                    var5_5.x += var4_4.bmDx;
                    var5_5.y += var4_4.bmDy;
                    ++var2_2;
                }
                while (true) {
                    var10_14 = var15_12.x >> 16;
                    var11_15 = var15_12.y >> 16;
                    if ((var10_14 < 0 || var11_15 < 0 || var10_14 >= var13_10 || var11_15 >= var14_11) && var2_2 < var3_3) {
                        var12_16 = var4_4.bmSmooth != false ? this.GetSSRGBPixel(var15_12.x, var15_12.y) : this.GetRGBPixel(var10_14, var11_15);
                        --var3_3;
                        if (var4_4.cx != null) {
                            var12_16 = var4_4.cx.ApplyColorMap(var12_16);
                        }
                        if (var6_6 != null) {
                            var6_6[var3_3 + var1_1] = (byte)var12_16;
                        } else {
                            var7_7[var3_3 + var1_1] = var12_16;
                        }
                        var15_12.x -= var4_4.bmDx;
                        var15_12.y -= var4_4.bmDy;
                        continue;
                    }
                    break;
                }
            } else {
                var5_5.x = Bitmap.LimitAbs(var5_5.x, var8_8);
                var5_5.y = Bitmap.LimitAbs(var5_5.y, var9_9);
            }
            if (!var4_4.bmFast) ** GOTO lbl94
            while (var2_2 < var3_3) {
                this.n = Math.min(var3_3 - var2_2, 256);
                var5_5.x = this.CalcLimit(var5_5.x, var4_4.bmDx, var8_8);
                var5_5.y = this.CalcLimit(var5_5.y, var4_4.bmDy, var9_9);
                if (var6_6 != null) {
                    this.Blt32to8(var4_4, var5_5, this.n, var6_6, var2_2 + var1_1);
                } else {
                    this.Blt32to32(var4_4, var5_5, this.n, var7_7, var2_2 + var1_1);
                }
                var2_2 += this.n;
            }
            break block23;
lbl-1000:
            // 1 sources

            {
                this.n = Math.min(var3_3 - var2_2, 256);
                var5_5.x = this.CalcLimit(var5_5.x, var4_4.bmDx, var8_8);
                var5_5.y = this.CalcLimit(var5_5.y, var4_4.bmDy, var9_9);
                if (var6_6 != null) {
                    this.Blt32toI(var4_4, var5_5, this.n, Bitmap.pixBuf);
                } else {
                    this.Blt32toI(var4_4, var5_5, this.n, Bitmap.pixBuf);
                }
                if (var4_4.cx != null) {
                    var4_4.cx.ApplyColorMap(Bitmap.pixBuf, this.n);
                }
                if (var6_6 != null) {
                    var10_14 = var2_2 + var1_1;
                    var11_15 = 0;
                    var12_16 = this.n;
                    while (var12_16 > 0) {
                        var6_6[var10_14] = (byte)this.display.RGBToIndex(Bitmap.pixBuf[var11_15]);
                        --var12_16;
                        ++var10_14;
                        ++var11_15;
                    }
                } else {
                    var10_14 = var2_2 + var1_1;
                    var11_15 = 0;
                    var12_16 = this.n;
                    while (var12_16 > 0) {
                        var7_7[var10_14] = Bitmap.pixBuf[var11_15];
                        --var12_16;
                        ++var10_14;
                        ++var11_15;
                    }
                }
                var2_2 += this.n;
lbl94:
                // 2 sources

                ** while (var2_2 < var3_3)
            }
        }
    }

    static {
        Bitmap.buildCoverageTable();
        pixBuf = new int[256];
    }
}

