/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Flash;
import com.sun.media.content.application.x_shockwave_flash.RColor;

final class ColorTransform {
    static final int needA = 1;
    static final int needB = 2;
    int flags;
    int ra;
    int rb;
    int ga;
    int gb;
    int ba;
    int bb;
    byte[] redMap;
    byte[] greenMap;
    byte[] blueMap;

    ColorTransform() {
    }

    private static void BuildMapChannel(int n2, int n3, byte[] byArray) {
        int n4 = n3 << 8;
        int n5 = 256;
        int n6 = 0;
        while (n5-- != 0) {
            byArray[n6++] = (n4 & 0xFFFF0000) == 0 ? (int)(n4 >> 8) : (n4 > 0 ? -1 : 0);
            n4 += n2;
        }
    }

    void BuildMapChannels() {
        this.redMap = new byte[256];
        this.greenMap = new byte[256];
        this.blueMap = new byte[256];
        if (this.redMap == null || this.greenMap == null || this.blueMap == null) {
            this.blueMap = null;
            this.greenMap = null;
            this.redMap = null;
            return;
        }
        ColorTransform.BuildMapChannel(this.ra, this.rb, this.redMap);
        ColorTransform.BuildMapChannel(this.ga, this.gb, this.greenMap);
        ColorTransform.BuildMapChannel(this.ba, this.bb, this.blueMap);
    }

    void Clear() {
        this.flags = 0;
        this.ba = 256;
        this.ga = 256;
        this.ra = 256;
        this.bb = 0;
        this.gb = 0;
        this.rb = 0;
    }

    private static int ApplyChannel(int n2, int n3, int n4) {
        if (((n2 = (n2 * n3 >> 8) + n4) & 0xFF00) == 0) {
            return n2;
        }
        if (n2 > 0) {
            return 255;
        }
        return 0;
    }

    private static int ApplyChannelB(int n2, int n3, int n4) {
        if (((n2 += n4) & 0xFF00) == 0) {
            return n2;
        }
        if (n2 > 0) {
            return 255;
        }
        return 0;
    }

    void ApplyColorMap(int[] nArray, int n2) {
        if (this.flags == 0 || this.redMap == null) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = this.redMap[n4 >> 16 & 0xFF] & 0xFF;
            int n6 = this.greenMap[n4 >> 8 & 0xFF] & 0xFF;
            int n7 = this.blueMap[n4 & 0xFF] & 0xFF;
            nArray[n3] = 0xFF000000 | n5 << 16 | n6 << 8 | n7;
            ++n3;
        }
    }

    int ApplyColorMap(int n2) {
        if (this.flags == 0 || this.redMap == null) {
            return n2;
        }
        int n3 = this.redMap[n2 >> 16 & 0xFF] & 0xFF;
        int n4 = this.greenMap[n2 >> 8 & 0xFF] & 0xFF;
        int n5 = this.blueMap[n2 & 0xFF] & 0xFF;
        return 0xFF000000 | n3 << 16 | n4 << 8 | n5;
    }

    void Apply(RColor rColor) {
        if (this.flags == 0) {
            return;
        }
        int n2 = rColor.color;
        int n3 = ColorTransform.ApplyChannel(n2 >> 16 & 0xFF, this.ra, this.rb);
        int n4 = ColorTransform.ApplyChannel(n2 >> 8 & 0xFF, this.ga, this.gb);
        int n5 = ColorTransform.ApplyChannel(n2 & 0xFF, this.ba, this.bb);
        n2 = 0xFF000000 | n3 << 16 | n4 << 8 | n5;
        rColor.RecalcSolid(Flash.gApplet.display, n2);
    }

    void ApplyGradient(RColor rColor) {
        if (this.flags == 0 || rColor.gcolorRamp == null) {
            return;
        }
        int[] nArray = rColor.gcolorRamp;
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            int n3 = ColorTransform.ApplyChannel(nArray[n2] >> 16 & 0xFF, this.ra, this.rb);
            int n4 = ColorTransform.ApplyChannel(nArray[n2] >> 8 & 0xFF, this.ga, this.gb);
            int n5 = ColorTransform.ApplyChannel(nArray[n2] & 0xFF, this.ba, this.bb);
            nArray[n2] = 0xFF000000 | n3 << 16 | n4 << 8 | n5;
            --n2;
        }
    }
}

