/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Bitmap;
import com.sun.media.content.application.x_shockwave_flash.ColorTransform;
import com.sun.media.content.application.x_shockwave_flash.Curve;
import com.sun.media.content.application.x_shockwave_flash.DisplayList;
import com.sun.media.content.application.x_shockwave_flash.Matrix;
import com.sun.media.content.application.x_shockwave_flash.RColor;
import com.sun.media.content.application.x_shockwave_flash.REdge;
import com.sun.media.content.application.x_shockwave_flash.SObject;
import com.sun.media.content.application.x_shockwave_flash.SParser;
import com.sun.media.content.application.x_shockwave_flash.ScriptPlayer;
import java.awt.Point;

final class SCharacterParser
extends SParser {
    static final int fillSolid = 0;
    static final int fillGradient = 16;
    static final int fillLinearGradient = 16;
    static final int fillRadialGradient = 18;
    static final int fillMaxGradientColors = 8;
    static final int fillBits = 64;
    static final int fillBitsClip = 65;
    static final int fillBitsNoSmooth = 66;
    DisplayList display;
    ScriptPlayer player;
    ColorTransform cx;
    Matrix mat;
    int layer;
    int nLines;
    int nFills;
    RColor[] fillIndex;
    RColor[] lineIndexColor;
    int[] lineIndexThick;
    int nFillBits;
    int nLineBits;
    int line;
    int fill0;
    int fill1;
    Point curPt = new Point(0, 0);
    Point curPtX = new Point(0, 0);
    Point curPtXc = new Point(0, 0);
    Point curPtX2 = new Point(0, 0);
    public final int eflagsMoveTo = 1;
    public final int eflagsFill0 = 2;
    public final int eflagsFill1 = 4;
    public final int eflagsLine = 8;
    public final int eflagsNewStyles = 16;
    public final int eflagsEnd = 128;
    boolean useWinding = false;
    int depth;
    SObject obj;
    int fillRule;
    RColor color1;
    RColor color2;
    RColor strokeColor;
    boolean isThick;
    int lineThickness;
    boolean strokeInited;
    int strokeDepth = 0;
    Point lStartPt = new Point(0, 0);
    Point startOrigin = new Point(0, 0);
    Point rStartPt = new Point(0, 0);
    Point lCurPt = new Point(0, 0);
    Point curOrigin = new Point(0, 0);
    Point rCurPt = new Point(0, 0);
    Point sCurPt = new Point(0, 0);

    SCharacterParser(ScriptPlayer scriptPlayer, int n2, Matrix matrix, ColorTransform colorTransform) {
        this.mat = matrix;
        this.cx = colorTransform;
        this.layer = 0;
        this.nFills = 0;
        this.nLines = 0;
        this.fill1 = 0;
        this.fill0 = 0;
        this.line = 0;
        this.curPt.y = 0;
        this.curPt.x = 0;
        this.mat.transform(this.curPt, this.curPtX);
        this.player = scriptPlayer;
        this.display = scriptPlayer.display;
        this.Attach(this.player.script, n2);
    }

    private void buildCache(RColor rColor) {
        if (rColor.cacheValid) {
            return;
        }
        switch (rColor.fillType) {
            case 64: 
            case 65: 
            case 66: {
                if (rColor.bitmap == null) {
                    rColor.fillType = 0;
                    break;
                }
                rColor.bmFast = true;
                rColor.bmDx = rColor.bmInvMat.a;
                rColor.bmDy = rColor.bmInvMat.b;
                if (this.cx == null) break;
                this.cx.BuildMapChannels();
                rColor.cx = this.cx;
                rColor.bmFast = false;
                break;
            }
        }
    }

    boolean GetStyles() {
        RColor rColor;
        this.nFills = this.GetByte();
        if (this.nFills == 255) {
            this.nFills = this.GetWord();
        }
        if ((this.fillIndex = new RColor[this.nFills + 1]) == null) {
            return false;
        }
        int n2 = 1;
        while (n2 <= this.nFills) {
            Object object;
            Object object2;
            rColor = null;
            int n3 = this.GetByte();
            if ((n3 & 0x10) != 0) {
                Matrix matrix = this.GetMatrix();
                int n4 = this.GetByte();
                object2 = new int[n4];
                object = new int[n4];
                int n5 = 0;
                while (n5 < n4) {
                    object[n5] = this.GetByte();
                    object2[n5] = this.GetColor();
                    ++n5;
                }
                rColor = new RColor(this.display, n3, n4, (int[])object2, (int[])object, matrix, this.mat);
                if (this.cx != null) {
                    this.cx.ApplyGradient(rColor);
                }
            } else if ((n3 & 0x40) != 0) {
                int n6 = this.GetWord();
                Matrix matrix = this.GetMatrix();
                rColor = new RColor(this.display, -65281);
                object2 = this.player.FindCharacter(n6);
                if (object2 != null && object2.type == 1) {
                    if (object2.object != null && object2.object instanceof Bitmap) {
                        rColor.bitmap = (Bitmap)object2.object;
                        rColor.fillType = n3;
                        if (this.display.model != null) {
                            if (this.display.antialias) {
                                Matrix matrix2 = new Matrix();
                                matrix2.scale(16384, 16384);
                                object = Matrix.concat(this.mat, matrix2);
                            } else {
                                object = new Matrix(this.mat);
                            }
                            matrix.tx <<= 16;
                            matrix.ty <<= 16;
                            object.tx <<= 16;
                            object.ty <<= 16;
                            matrix = Matrix.concat(matrix, (Matrix)object);
                            rColor.bmInvMat = matrix.invert();
                            this.buildCache(rColor);
                        }
                    }
                } else {
                    rColor = new RColor(this.display, -65536);
                }
            } else {
                rColor = new RColor(this.display, this.GetColor());
                if (this.cx != null) {
                    this.cx.Apply(rColor);
                }
            }
            this.fillIndex[n2] = rColor;
            rColor.order = this.layer + n2;
            ++n2;
        }
        this.nLines = this.GetByte();
        if (this.nLines == 255) {
            this.nLines = this.GetWord();
        }
        this.lineIndexColor = new RColor[this.nLines + 1];
        this.lineIndexThick = new int[this.nLines + 1];
        if (this.lineIndexColor == null || this.lineIndexThick == null) {
            this.lineIndexColor = null;
            this.lineIndexThick = null;
            return false;
        }
        n2 = 1;
        while (n2 <= this.nLines) {
            this.lineIndexThick[n2] = this.mat.transform(this.GetWord());
            rColor = new RColor(this.display, this.GetColor());
            if (this.cx != null) {
                this.cx.Apply(rColor);
            }
            this.lineIndexColor[n2] = rColor;
            rColor.order = this.layer | n2 + this.nFills;
            ++n2;
        }
        this.InitBits();
        this.nFillBits = this.GetBits(4);
        this.nLineBits = this.GetBits(4);
        return true;
    }

    int GetEdge(Curve curve) {
        boolean bl;
        boolean bl2 = bl = this.GetBits(1) != 0;
        if (!bl) {
            int n2 = this.GetBits(5);
            if (n2 == 0) {
                return 128;
            }
            if ((n2 & 1) != 0) {
                int n3 = this.GetBits(5);
                this.curPt.x = this.GetSBits(n3);
                this.curPt.y = this.GetSBits(n3);
                this.mat.transform(this.curPt, this.curPtX);
            }
            if ((n2 & 2) != 0) {
                this.fill0 = this.GetBits(this.nFillBits);
            }
            if ((n2 & 4) != 0) {
                this.fill1 = this.GetBits(this.nFillBits);
            }
            if ((n2 & 8) != 0) {
                this.line = this.GetBits(this.nLineBits);
            }
            if ((n2 & 0x10) != 0) {
                this.layer += this.nFills + this.nLines;
                this.GetStyles();
            }
            return n2;
        }
        boolean bl3 = curve.isLine = this.GetBits(1) != 0;
        if (curve.isLine) {
            boolean bl4;
            int n4 = this.GetBits(4) + 2;
            boolean bl5 = bl4 = this.GetBits(1) != 0;
            if (bl4) {
                this.curPt.x += this.GetSBits(n4);
                this.curPt.y += this.GetSBits(n4);
            } else {
                boolean bl6;
                boolean bl7 = bl6 = this.GetBits(1) != 0;
                if (bl6) {
                    this.curPt.y += this.GetSBits(n4);
                } else {
                    this.curPt.x += this.GetSBits(n4);
                }
            }
            this.mat.transform(this.curPt, this.curPtX2);
            curve.set(this.curPtX, this.curPtX2);
        } else {
            int n5 = this.GetBits(4) + 2;
            this.curPt.x += this.GetSBits(n5);
            this.curPt.y += this.GetSBits(n5);
            this.mat.transform(this.curPt, this.curPtXc);
            this.curPt.x += this.GetSBits(n5);
            this.curPt.y += this.GetSBits(n5);
            this.mat.transform(this.curPt, this.curPtX2);
            curve.set(this.curPtX, this.curPtXc, this.curPtX2);
        }
        this.curPtX.x = this.curPtX2.x;
        this.curPtX.y = this.curPtX2.y;
        return 0;
    }

    void AddCurve(Curve curve, boolean bl) {
        REdge rEdge = new REdge();
        if (curve.anchor1y <= curve.anchor2y) {
            rEdge.anchor1x = curve.anchor1x;
            rEdge.anchor1y = curve.anchor1y;
            rEdge.anchor2x = curve.anchor2x;
            rEdge.anchor2y = curve.anchor2y;
            rEdge.dir = 1;
        } else {
            rEdge.anchor1x = curve.anchor2x;
            rEdge.anchor1y = curve.anchor2y;
            rEdge.anchor2x = curve.anchor1x;
            rEdge.anchor2y = curve.anchor1y;
            rEdge.dir = -1;
        }
        rEdge.isLine = curve.isLine;
        rEdge.controlx = curve.controlx;
        rEdge.controly = curve.controly;
        if (!rEdge.isLine) {
            if (rEdge.controly < rEdge.anchor1y || rEdge.controly > rEdge.anchor2y) {
                if (rEdge.controly < rEdge.anchor1y && rEdge.anchor1y - rEdge.controly < 3) {
                    rEdge.controly = rEdge.anchor1y;
                } else if (curve.controly > rEdge.anchor2y && curve.controly - rEdge.anchor2y < 3) {
                    rEdge.controly = rEdge.anchor2y;
                } else {
                    int n2 = curve.anchor1y - 2 * curve.controly + curve.anchor2y;
                    int n3 = curve.anchor1y - curve.controly;
                    if (++this.depth > 16) {
                        return;
                    }
                    Curve curve2 = new Curve(curve);
                    Curve curve3 = curve2.divide(Matrix.div(n3, n2));
                    this.AddCurve(curve2, bl);
                    this.AddCurve(curve3, bl);
                    --this.depth;
                    return;
                }
            }
            if (rEdge.anchor2y - rEdge.anchor1y > 256) {
                if (++this.depth > 16) {
                    return;
                }
                Curve curve4 = new Curve(curve);
                Curve curve5 = curve4.divide(32768);
                this.AddCurve(curve4, bl);
                this.AddCurve(curve5, bl);
                --this.depth;
                return;
            }
        }
        if (rEdge.anchor1y == rEdge.anchor2y) {
            return;
        }
        if (bl) {
            rEdge.fillRule = 2;
            rEdge.color1 = this.strokeColor;
        } else {
            rEdge.fillRule = this.fillRule;
            rEdge.color1 = this.color1;
            rEdge.color2 = this.color2;
        }
        rEdge.nextObj = this.obj.edges;
        this.obj.edges = rEdge;
    }

    void BuildEdges(boolean bl) {
        this.depth = 0;
        this.layer = this.obj.id << 16;
        if (bl) {
            if (!this.GetStyles()) {
                return;
            }
        } else {
            this.InitBits();
            this.nFillBits = this.GetBits(4);
            this.nLineBits = this.GetBits(4);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        Curve curve = new Curve();
        this.color2 = null;
        this.color1 = null;
        while (true) {
            int n2;
            if ((n2 = this.GetEdge(curve)) != 0) {
                if (n2 == 128) {
                    if (!bl3) break;
                    this.EndStroke();
                    break;
                }
                if ((n2 & 6) != 0) {
                    this.color1 = this.fillIndex[this.fill0];
                    this.color2 = this.fillIndex[this.fill1];
                    if (this.color1 == null && this.color2 != null) {
                        this.color1 = this.color2;
                        this.color2 = null;
                    }
                    this.fillRule = this.color2 != null ? 0 : (this.useWinding ? 2 : 1);
                    boolean bl4 = bl2 = this.color1 != null;
                }
                if ((n2 & 9) == 0) continue;
                if (bl3) {
                    this.EndStroke();
                }
                if (this.line != 0) {
                    this.BeginStroke(this.lineIndexThick[this.line], this.lineIndexColor[this.line]);
                    bl3 = true;
                    continue;
                }
                bl3 = false;
                continue;
            }
            if (bl3) {
                this.AddStrokeCurve(curve);
            }
            if (!bl2) continue;
            this.AddCurve(curve, false);
        }
    }

    final void AddEdge(Point point, Point point2) {
        if (point.y == point2.y) {
            return;
        }
        REdge rEdge = new REdge();
        if (point.y > point2.y) {
            rEdge.dir = -1;
            rEdge.set(point2, point);
        } else {
            rEdge.dir = 1;
            rEdge.set(point, point2);
        }
        rEdge.fillRule = 2;
        rEdge.color1 = this.strokeColor;
        rEdge.nextObj = this.obj.edges;
        this.obj.edges = rEdge;
    }

    final void StrokeJoin(Point point, Point point2, Point point3) {
        int n2 = Matrix.fastLength(point.x - point2.x, point.y - point2.y);
        if (n2 > 3) {
            double d2 = Math.atan2(point.y - point3.y, point.x - point3.x);
            double d3 = Math.atan2(point2.y - point3.y, point2.x - point3.x);
            while (d2 < d3) {
                d2 += Math.PI * 2;
            }
            double d4 = d2 - d3;
            if (0.1 < d4 && d4 <= Math.PI) {
                double d5 = this.lineThickness / 2;
                int n3 = (int)(d5 * d4) / 3;
                Point point4 = new Point(point.x, point.y);
                Point point5 = new Point(0, 0);
                if (n3 > 1) {
                    if (n3 > 16) {
                        n3 = 16;
                    }
                    double d6 = -d4 / (double)n3;
                    double d7 = d2 + d6;
                    --n3;
                    while (n3-- > 0) {
                        point5.x = (int)(d5 * Math.cos(d7)) + point3.x;
                        point5.y = (int)(d5 * Math.sin(d7)) + point3.y;
                        this.AddEdge(point4, point5);
                        point4.x = point5.x;
                        point4.y = point5.y;
                        d7 += d6;
                    }
                }
                this.AddEdge(point4, point2);
                return;
            }
        }
        this.AddEdge(point, point2);
    }

    static final Curve CurveAdjust(Curve curve, Point point, Point point2) {
        int n2 = Matrix.length(curve.anchor1x - curve.anchor2x, curve.anchor1y - curve.anchor2y);
        int n3 = n2 > 0 ? Matrix.div(Matrix.length(point.x - point2.x, point.y - point2.y), n2) : 65536;
        int n4 = curve.controlx - curve.anchor1x;
        int n5 = curve.controly - curve.anchor1y;
        int n6 = curve.controlx - curve.anchor2x;
        int n7 = curve.controly - curve.anchor2y;
        Curve curve2 = new Curve();
        curve2.anchor1x = point.x;
        curve2.anchor1y = point.y;
        curve2.anchor2x = point2.x;
        curve2.anchor2y = point2.y;
        if (Matrix.fastLength(n4, n5) > Matrix.fastLength(n6, n7)) {
            curve2.controlx = Matrix.mul(n3, n4) + point.x;
            curve2.controly = Matrix.mul(n3, n5) + point.y;
        } else {
            curve2.controlx = Matrix.mul(n3, n6) + point2.x;
            curve2.controly = Matrix.mul(n3, n7) + point2.y;
        }
        return curve2;
    }

    static final Curve CurveReverse(Curve curve) {
        Curve curve2 = new Curve();
        curve2.isLine = curve.isLine;
        curve2.anchor1x = curve.anchor2x;
        curve2.anchor1y = curve.anchor2y;
        curve2.controlx = curve.controlx;
        curve2.controly = curve.controly;
        curve2.anchor2x = curve.anchor1x;
        curve2.anchor2y = curve.anchor1y;
        return curve2;
    }

    final void StrokeThickCurve(Curve curve) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (!curve.isLine && this.strokeDepth < 5 && (n6 = curve.flatness()) > 6 && 2 * n6 > (n5 = Matrix.fastLength(curve.anchor1x - curve.anchor2x, curve.anchor1y - curve.anchor2y))) {
            Curve curve2 = new Curve(curve);
            Curve curve3 = curve2.divide(32768);
            ++this.strokeDepth;
            this.StrokeThickCurve(curve2);
            this.StrokeThickCurve(curve3);
            --this.strokeDepth;
            return;
        }
        n6 = this.lineThickness / 2;
        n5 = curve.controly - curve.anchor1y;
        int n7 = curve.anchor1x - curve.controlx;
        if (n5 == 0 && n7 == 0) {
            n5 = curve.anchor2y - curve.anchor1y;
            n7 = curve.anchor1x - curve.anchor2x;
        }
        if ((n4 = Matrix.length(n5, n7)) > 0) {
            n4 = Matrix.div(n6, n4);
            n5 = Matrix.mul(n4, n5);
            n7 = Matrix.mul(n4, n7);
        }
        if (curve.isLine) {
            n3 = n5;
            n2 = n7;
        } else {
            n3 = curve.anchor2y - curve.controly;
            n2 = curve.controlx - curve.anchor2x;
            if (n3 == 0 && n2 == 0) {
                n3 = curve.anchor2y - curve.anchor1y;
                n2 = curve.anchor1x - curve.anchor2x;
            }
            if ((n4 = Matrix.length(n3, n2)) > 0) {
                n4 = Matrix.div(n6, n4);
                n3 = Matrix.mul(n4, n3);
                n2 = Matrix.mul(n4, n2);
            }
        }
        Point point = new Point(curve.anchor1x + n5, curve.anchor1y + n7);
        Point point2 = new Point(curve.anchor2x + n3, curve.anchor2y + n2);
        Point point3 = new Point(curve.anchor1x - n5, curve.anchor1y - n7);
        Point point4 = new Point(curve.anchor2x - n3, curve.anchor2y - n2);
        if (curve.isLine) {
            this.AddEdge(point2, point);
            this.AddEdge(point3, point4);
        } else {
            this.AddCurve(SCharacterParser.CurveReverse(SCharacterParser.CurveAdjust(curve, point, point2)), true);
            this.AddCurve(SCharacterParser.CurveAdjust(curve, point3, point4), true);
        }
        if (!this.strokeInited) {
            this.lStartPt.x = point.x;
            this.lStartPt.y = point.y;
            this.startOrigin.x = curve.anchor1x;
            this.startOrigin.y = curve.anchor1y;
            this.rStartPt.x = point3.x;
            this.rStartPt.y = point3.y;
            this.strokeInited = true;
        } else {
            this.StrokeJoin(point, this.lCurPt, this.curOrigin);
            this.StrokeJoin(this.rCurPt, point3, this.curOrigin);
        }
        this.lCurPt.x = point2.x;
        this.lCurPt.y = point2.y;
        this.curOrigin.x = curve.anchor2x;
        this.curOrigin.y = curve.anchor2y;
        this.rCurPt.x = point4.x;
        this.rCurPt.y = point4.y;
    }

    static final int Sign(int n2) {
        if (n2 < 0) {
            return -1;
        }
        return n2 > 0 ? 1 : 0;
    }

    final void StrokeThinLine(Curve curve) {
        int n2 = curve.anchor2y - curve.anchor1y;
        int n3 = curve.anchor1x - curve.anchor2x;
        Point point = new Point(curve.anchor1x, curve.anchor1y);
        Point point2 = new Point(curve.anchor1x, curve.anchor1y);
        Point point3 = new Point(curve.anchor2x, curve.anchor2y);
        Point point4 = new Point(curve.anchor2x, curve.anchor2y);
        boolean bl = Matrix.abs(n2) > Matrix.abs(n3);
        switch (this.lineThickness) {
            case 1: {
                if (bl) {
                    int n4 = SCharacterParser.Sign(n2);
                    if (n4 > 0) {
                        point.x += n4;
                        point3.x += n4;
                        break;
                    }
                    point2.x -= n4;
                    point4.x -= n4;
                    break;
                }
                int n5 = SCharacterParser.Sign(n3);
                if (n5 > 0) {
                    point.y += n5;
                    point3.y += n5;
                    break;
                }
                point2.y -= n5;
                point4.y -= n5;
                break;
            }
            case 2: {
                if (bl) {
                    int n6 = SCharacterParser.Sign(n2);
                    point.x += n6;
                    point3.x += n6;
                    point2.x -= n6;
                    point4.x -= n6;
                    break;
                }
                int n7 = SCharacterParser.Sign(n3);
                point.y += n7;
                point3.y += n7;
                point2.y -= n7;
                point4.y -= n7;
                break;
            }
            case 3: {
                if (bl) {
                    int n8 = SCharacterParser.Sign(n2);
                    point.x += n8;
                    point3.x += n8;
                    point2.x -= (n8 *= 2);
                    point4.x -= n8;
                    break;
                }
                int n9 = SCharacterParser.Sign(n3);
                point.y += n9;
                point3.y += n9;
                point2.y -= (n9 *= 2);
                point4.y -= n9;
            }
        }
        this.AddEdge(point3, point);
        this.AddEdge(point2, point4);
        if (!this.strokeInited) {
            this.lStartPt.x = point.x;
            this.lStartPt.y = point.y;
            this.startOrigin.x = curve.anchor1x;
            this.startOrigin.y = curve.anchor1y;
            this.rStartPt.x = point2.x;
            this.rStartPt.y = point2.y;
            this.strokeInited = true;
        } else {
            this.AddEdge(point, this.lCurPt);
            this.AddEdge(this.rCurPt, point2);
        }
        this.lCurPt.x = point3.x;
        this.lCurPt.y = point3.y;
        this.curOrigin.x = curve.anchor2x;
        this.curOrigin.y = curve.anchor2y;
        this.rCurPt.x = point4.x;
        this.rCurPt.y = point4.y;
    }

    private static final void CurveOffsetX(Curve curve, int n2) {
        curve.anchor1x += n2;
        curve.controlx += n2;
        curve.anchor2x += n2;
    }

    private static final void CurveOffsetY(Curve curve, int n2) {
        curve.anchor1y += n2;
        curve.controly += n2;
        curve.anchor2y += n2;
    }

    private static final boolean SameSign(int n2, int n3) {
        if (n2 == 0) {
            return true;
        }
        if (n2 > 0) {
            return n3 >= 0;
        }
        return n3 <= 0;
    }

    final void StrokeThinCurve(Curve curve) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (!curve.isLine && curve.flatness() > 2) {
            n5 = curve.controly - curve.anchor1y;
            n4 = curve.anchor1x - curve.controlx;
            int n6 = curve.anchor2y - curve.controly;
            int n7 = curve.controlx - curve.anchor2x;
            n3 = Matrix.abs(n5) > Matrix.abs(n4) ? 1 : 0;
            int n8 = n2 = Matrix.abs(n6) > Matrix.abs(n7) ? 1 : 0;
            if (n3 != n2 || !SCharacterParser.SameSign(n5, n6) || !SCharacterParser.SameSign(n4, n7)) {
                Curve curve2 = new Curve(curve);
                Curve curve3 = curve2.divide(32768);
                this.StrokeThinCurve(curve2);
                this.StrokeThinCurve(curve3);
                return;
            }
        }
        n5 = curve.anchor2y - curve.anchor1y;
        n4 = curve.anchor1x - curve.anchor2x;
        Curve curve4 = new Curve(curve);
        Curve curve5 = new Curve(curve);
        n3 = Matrix.abs(n5) > Matrix.abs(n4) ? 1 : 0;
        switch (this.lineThickness) {
            case 1: {
                if (n3 != 0) {
                    n2 = SCharacterParser.Sign(n5);
                    if (n2 > 0) {
                        SCharacterParser.CurveOffsetX(curve4, n2);
                        break;
                    }
                    SCharacterParser.CurveOffsetX(curve5, -n2);
                    break;
                }
                n2 = SCharacterParser.Sign(n4);
                if (n2 > 0) {
                    SCharacterParser.CurveOffsetY(curve4, n2);
                    break;
                }
                SCharacterParser.CurveOffsetY(curve5, -n2);
                break;
            }
            case 2: {
                if (n3 != 0) {
                    n2 = SCharacterParser.Sign(n5);
                    SCharacterParser.CurveOffsetX(curve4, n2);
                    SCharacterParser.CurveOffsetX(curve5, -n2);
                    break;
                }
                n2 = SCharacterParser.Sign(n4);
                SCharacterParser.CurveOffsetY(curve4, n2);
                SCharacterParser.CurveOffsetY(curve5, -n2);
                break;
            }
            case 3: {
                if (n3 != 0) {
                    n2 = SCharacterParser.Sign(n5);
                    SCharacterParser.CurveOffsetX(curve4, n2);
                    SCharacterParser.CurveOffsetX(curve5, -2 * n2);
                    break;
                }
                n2 = SCharacterParser.Sign(n4);
                SCharacterParser.CurveOffsetY(curve4, n2);
                SCharacterParser.CurveOffsetY(curve5, -2 * n2);
            }
        }
        this.AddCurve(SCharacterParser.CurveReverse(curve4), true);
        this.AddCurve(curve5, true);
        if (!this.strokeInited) {
            this.lStartPt.x = curve4.anchor1x;
            this.lStartPt.y = curve4.anchor1y;
            this.startOrigin.x = curve.anchor1x;
            this.startOrigin.y = curve.anchor1y;
            this.rStartPt.x = curve5.anchor1x;
            this.rStartPt.y = curve5.anchor1y;
            this.strokeInited = true;
        } else {
            this.AddEdge(new Point(curve4.anchor1x, curve4.anchor1y), this.lCurPt);
            this.AddEdge(this.rCurPt, new Point(curve5.anchor1x, curve5.anchor1y));
        }
        this.lCurPt.x = curve4.anchor2x;
        this.lCurPt.y = curve4.anchor2y;
        this.curOrigin.x = curve.anchor2x;
        this.curOrigin.y = curve.anchor2y;
        this.rCurPt.x = curve5.anchor2x;
        this.rCurPt.y = curve5.anchor2y;
    }

    final void BeginStroke(int n2, RColor rColor) {
        this.strokeInited = false;
        this.lineThickness = Math.max(this.display.antialias ? 4 : 1, n2);
        this.isThick = this.lineThickness > 3;
        this.strokeColor = rColor;
        this.sCurPt.y = Integer.MIN_VALUE;
        this.sCurPt.x = Integer.MIN_VALUE;
    }

    final void AddStrokeCurve(Curve curve) {
        this.sCurPt.x = curve.anchor2x;
        this.sCurPt.y = curve.anchor2y;
        if (curve.anchor1x == curve.anchor2x && curve.anchor1y == curve.anchor2y && curve.anchor1x == curve.controlx && curve.anchor1y == curve.controly) {
            return;
        }
        if (!this.isThick) {
            if (curve.isLine) {
                this.StrokeThinLine(curve);
            } else {
                this.StrokeThinCurve(curve);
            }
        } else if (this.display.antialias && curve.isLine) {
            if (this.lineThickness == 4 || this.lineThickness == 12) {
                Curve curve2 = new Curve(curve);
                if (curve2.anchor1x == curve2.anchor2x && Matrix.abs(curve2.anchor1y - curve2.anchor2y) > 12) {
                    curve2.anchor1x = curve2.anchor2x = (curve2.anchor1x & 0xFFFFFFFC) + 2;
                } else if (curve2.anchor1y == curve2.anchor2y && Matrix.abs(curve2.anchor1x - curve2.anchor2x) > 12) {
                    curve2.anchor1y = curve2.anchor2y = (curve2.anchor1y & 0xFFFFFFFC) + 2;
                }
                this.StrokeThickCurve(curve2);
            } else if (this.lineThickness == 8) {
                Curve curve3 = new Curve(curve);
                if (curve3.anchor1x == curve3.anchor2x && Matrix.abs(curve3.anchor1y - curve3.anchor2y) > 12) {
                    curve3.anchor1x = curve3.anchor2x = curve3.anchor1x + 2 & 0xFFFFFFFC;
                } else if (curve3.anchor1y == curve3.anchor2y && Matrix.abs(curve3.anchor1x - curve3.anchor2x) > 12) {
                    curve3.anchor1y = curve3.anchor2y = curve3.anchor1y + 2 & 0xFFFFFFFC;
                }
                this.StrokeThickCurve(curve3);
            } else {
                this.StrokeThickCurve(curve);
            }
        } else {
            this.StrokeThickCurve(curve);
        }
    }

    final void EndStroke() {
        if (this.strokeInited) {
            if (this.startOrigin.x == this.curOrigin.x && this.startOrigin.y == this.curOrigin.y) {
                if (!this.isThick) {
                    this.AddEdge(this.lStartPt, this.lCurPt);
                    this.AddEdge(this.rCurPt, this.rStartPt);
                } else {
                    this.StrokeJoin(this.lStartPt, this.lCurPt, this.curOrigin);
                    this.StrokeJoin(this.rCurPt, this.rStartPt, this.curOrigin);
                }
            } else if (!this.isThick) {
                this.AddEdge(this.lStartPt, this.rStartPt);
                this.AddEdge(this.rCurPt, this.lCurPt);
            } else {
                this.StrokeJoin(this.lStartPt, this.rStartPt, this.startOrigin);
                this.StrokeJoin(this.rCurPt, this.lCurPt, this.curOrigin);
            }
        } else if (this.sCurPt.x != Integer.MIN_VALUE) {
            int n2 = this.lineThickness / 2;
            Point point = new Point(this.sCurPt.x, this.sCurPt.y);
            Point point2 = new Point(this.sCurPt.x, this.sCurPt.y);
            point.y -= n2;
            point2.y += this.lineThickness - n2;
            if (!this.isThick) {
                point.x -= n2;
                point2.x -= n2;
                this.AddEdge(point, point2);
                point.x += this.lineThickness - n2;
                point2.x += this.lineThickness - n2;
                this.AddEdge(point2, point);
            } else {
                this.StrokeJoin(point, point2, this.sCurPt);
                this.StrokeJoin(point2, point, this.sCurPt);
            }
        }
    }
}

