/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Bitmap;
import com.sun.media.content.application.x_shockwave_flash.ColorTransform;
import com.sun.media.content.application.x_shockwave_flash.DisplayList;
import com.sun.media.content.application.x_shockwave_flash.Flash;
import com.sun.media.content.application.x_shockwave_flash.ImageSource;
import com.sun.media.content.application.x_shockwave_flash.Matrix;
import com.sun.media.content.application.x_shockwave_flash.Rect;
import com.sun.media.content.application.x_shockwave_flash.SCharacter;
import com.sun.media.content.application.x_shockwave_flash.SObject;
import com.sun.media.content.application.x_shockwave_flash.SParser;
import com.sun.media.content.application.x_shockwave_flash.Semaphore;
import com.sun.media.content.application.x_shockwave_flash.Sound;
import com.sun.media.content.application.x_shockwave_flash.SoundMixer;
import java.io.IOException;
import java.io.InputStream;
import javax.media.protocol.PullSourceStream;

final class ScriptPlayer
extends SParser
implements Runnable {
    static final int noErr = 0;
    static final int badHeaderErr = -1;
    static final int noMemErr = -2;
    static final int noScriptErr = -3;
    static final int playOK = 0;
    static final int playNeedData = 1;
    static final int playAtEnd = 2;
    static final int stagEnd = 0;
    static final int stagShowFrame = 1;
    static final int stagDefineShape = 2;
    static final int stagFreeCharacter = 3;
    static final int stagPlaceObject = 4;
    static final int stagRemoveObject = 5;
    static final int stagDefineBits = 6;
    static final int stagDefineButton = 7;
    static final int stagJPEGTables = 8;
    static final int stagSetBackgroundColor = 9;
    static final int stagDefineFont = 10;
    static final int stagDefineText = 11;
    static final int stagDoAction = 12;
    static final int stagDefineFontInfo = 13;
    static final int stagDefineSound = 14;
    static final int stagStartSound = 15;
    static final int stagStopSound = 16;
    static final int stagDefineButtonSound = 17;
    static final int stagSoundStreamHead = 18;
    static final int stagSoundStreamBlock = 19;
    static final int stagDefineBitsLossless = 20;
    static final int stagDefineBitsJPEG2 = 21;
    static final int stagDefineShape2 = 22;
    static final int stagDefineButtonCxform = 23;
    static final int stagProtect = 24;
    static final int stagPathsArePostScript = 25;
    static final int sactionHasLength = 128;
    static final int sactionNone = 0;
    static final int sactionGotoFrame = 129;
    static final int sactionGetURL = 131;
    static final int sactionNextFrame = 4;
    static final int sactionPrevFrame = 5;
    static final int sactionPlay = 6;
    static final int sactionStop = 7;
    static final int sactionToggleQuality = 8;
    static final int sactionStopSounds = 9;
    static final int sactionWaitForFrame = 138;
    static final int soundHasInPoint = 1;
    static final int soundHasOutPoint = 2;
    static final int soundHasLoops = 4;
    static final int soundHasEnvelope = 8;
    static final int syncNoMultiple = 1;
    static final int syncStop = 2;
    int nextPos;
    int startPos;
    int scriptErr;
    int len;
    int scriptLen;
    Rect frame;
    int frameRate;
    int frameDelay;
    int numFrames;
    int version;
    int headerLen;
    byte[] headerBuf = new byte[8];
    boolean gotHeader;
    boolean atEnd;
    int curFrame;
    Semaphore gotData = new Semaphore(false);
    DisplayList display;
    private Flash flash;
    static final int maxActions = 16;
    public int[] actionList = new int[16];
    public int nActions;
    static final int charIndexSize = 64;
    static final int charIndexMask = 63;
    SCharacter[] charIndex = new SCharacter[64];
    Sound streamSound = new Sound(0, 0, null, 0);
    int mixFormat;
    boolean mute;
    static final int START_MARKER = 216;
    static final int END_MARKER = 217;
    static final int TAG_MARKER = 255;
    private int jpegTablePos;
    private int jpegTableLen;
    private static int imageClassToUse;
    private static final int IMAGE_NOT_INITIALIZED = 0;
    private static final int IMAGE_TOOLKIT = 1;
    private static final int IMAGE_SUN = 2;
    private static final int IMAGE_NONE = 3;
    private int numFramesComplete;
    private int numFramesCompletePos;
    private InputStream scriptStream = null;
    private boolean scriptComplete;

    ScriptPlayer() {
        this.frame = new Rect(0, 0, 600, 600);
        this.ClearScript();
    }

    ScriptPlayer(Flash flash, DisplayList displayList) {
        this();
        this.flash = flash;
        this.display = displayList;
    }

    public final boolean ScriptComplete() {
        return this.script != null && this.len >= this.scriptLen;
    }

    public final boolean GotHeader() {
        return this.gotHeader;
    }

    public final int GetFrame() {
        return this.curFrame;
    }

    public final boolean AtEnd() {
        return this.atEnd;
    }

    void PlayButtonSound(SObject sObject, int n2) {
        int n3 = sObject.buttonState;
        if (n3 == n2 || n2 != 1 && n3 > n2) {
            return;
        }
        if (sObject.character.soundPos > 0) {
            int n4;
            SParser sParser = new SParser();
            sParser.Attach(this.script, sObject.character.soundPos);
            int n5 = 1;
            while (n5 < n2) {
                n4 = sParser.GetWord();
                if (n4 > 0) {
                    sParser.GetSoundInfo(null, null, true);
                }
                n5 <<= 1;
            }
            n4 = sParser.GetWord();
            if (n4 > 0) {
                SCharacter sCharacter = this.FindCharacter(n4);
                if (sCharacter == null || sCharacter.type != 5) {
                    return;
                }
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                Sound sound = (Sound)sCharacter.object;
                sParser.GetSoundInfo(nArray, nArray2, false);
                if (sound.ConvertToMulaw(nArray[0])) {
                    if ((nArray2[0] & 2) != 0) {
                        sound.stop();
                    } else if ((nArray2[0] & 1) != 0 && !this.mute) {
                        sound.playNoMultiple(nArray[0]);
                    } else if (!this.mute) {
                        sound.playMultiple(nArray[0]);
                    }
                }
            }
        }
    }

    void SoundStreamHead() {
        this.mixFormat = this.GetByte();
        this.streamSound.SetFormat(this.GetByte());
        this.streamSound.SetSamples(this.GetWord());
    }

    void SoundStreamBlock() {
    }

    void StopAllSounds() {
        Sound sound = this.streamSound;
        while (sound != null) {
            sound.stop();
            sound = sound.next;
        }
        SoundMixer.StopAllStreams();
    }

    void StartSound() {
        int n2 = this.GetWord();
        SCharacter sCharacter = this.FindCharacter(n2);
        if (sCharacter == null || sCharacter.type != 5) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Sound sound = (Sound)sCharacter.object;
        this.GetSoundInfo(nArray, nArray2, false);
        if (sound.ConvertToMulaw(nArray[0])) {
            if ((nArray2[0] & 2) != 0) {
                sound.stop();
            } else if ((nArray2[0] & 1) != 0 && !this.mute) {
                sound.playNoMultiple(nArray[0]);
            } else if (!this.mute) {
                sound.playMultiple(nArray[0]);
            }
        }
    }

    public void FreeAll() {
        if (this.display != null) {
            this.display.FreeAll();
        }
        this.pos = this.startPos;
        this.curFrame = -1;
        this.atEnd = false;
    }

    public void ClearScript() {
        this.FreeAll();
        this.gotHeader = false;
        this.curFrame = -1;
        this.atEnd = false;
        this.headerLen = 0;
        this.len = 0;
        this.scriptLen = -1;
        this.pos = 0;
        this.script = null;
        this.scriptErr = 0;
        this.nActions = 0;
    }

    public SCharacter FindCharacter(int n2) {
        SCharacter sCharacter = this.charIndex[n2 & 0x3F];
        while (sCharacter != null && sCharacter.tag != n2) {
            sCharacter = sCharacter.next;
        }
        return sCharacter;
    }

    private SCharacter CreateCharacter(int n2) {
        SCharacter sCharacter = new SCharacter();
        if (sCharacter != null) {
            sCharacter.next = this.charIndex[n2 & 0x3F];
            this.charIndex[n2 & 0x3F] = sCharacter;
            sCharacter.player = this;
            sCharacter.tag = n2;
        }
        return sCharacter;
    }

    private void FreeCharacter(int n2) {
        Object var2_2 = null;
        SCharacter sCharacter = this.charIndex[n2 & 0x3F];
    }

    private void DefineShape() {
        int n2 = this.GetWord();
        if (this.FindCharacter(n2) != null) {
            return;
        }
        SCharacter sCharacter = this.CreateCharacter(n2);
        sCharacter.type = 0;
        sCharacter.bounds = this.GetRect();
        sCharacter.dataPos = this.pos;
    }

    private void PlaceObject() {
        int n2 = this.GetWord();
        int n3 = this.GetWord();
        SCharacter sCharacter = this.FindCharacter(n2);
        Matrix matrix = this.GetMatrix();
        if (this.pos < this.end) {
            ColorTransform colorTransform = new ColorTransform();
            this.GetColorTransform(colorTransform);
            this.display.PlaceObject(sCharacter, n2 << 16 | n3, matrix, colorTransform);
        } else {
            this.display.PlaceObject(sCharacter, n2 << 16 | n3, matrix, null);
        }
    }

    private void RemoveObject() {
        int n2 = this.GetWord();
        int n3 = this.GetWord();
        this.display.RemoveObject(n2 << 16 | n3);
    }

    private void DefineButton() {
        int n2 = this.GetWord();
        if (this.FindCharacter(n2) != null) {
            return;
        }
        SCharacter sCharacter = this.CreateCharacter(n2);
        sCharacter.type = 2;
        sCharacter.dataPos = this.pos;
        sCharacter.bounds = new Rect();
    }

    void DefineButtonExtra(boolean bl) {
        int n2 = this.GetWord();
        SCharacter sCharacter = this.FindCharacter(n2);
        if (sCharacter == null || sCharacter.type != 2) {
            return;
        }
        if (bl) {
            sCharacter.soundPos = this.pos;
        } else {
            sCharacter.cxformPos = this.pos;
        }
    }

    void DefineSound(int n2) {
        int n3 = this.GetWord();
        if (this.FindCharacter(n3) != null) {
            return;
        }
        SCharacter sCharacter = this.CreateCharacter(n3);
        if (sCharacter == null) {
            return;
        }
        sCharacter.type = 5;
        int n4 = this.GetByte();
        int n5 = this.GetDWord();
        Sound sound = new Sound(n4, n5, this.script, this.pos);
        sCharacter.object = sound;
        if (sound == null) {
            this.FreeCharacter(n3);
            return;
        }
        sCharacter.dataPos = this.pos;
        if (sound.CompressFormat() > 16) {
            this.FreeCharacter(n3);
        } else {
            sound.characterTag = n3;
            sound.next = this.streamSound.next;
            this.streamSound.next = sound;
        }
    }

    private void DefineFont() {
        int n2 = this.GetWord();
        if (this.FindCharacter(n2) != null) {
            return;
        }
        SCharacter sCharacter = this.CreateCharacter(n2);
        sCharacter.type = 3;
        sCharacter.bounds = new Rect();
        sCharacter.dataPos = this.pos;
    }

    private void DefineText() {
        int n2 = this.GetWord();
        if (this.FindCharacter(n2) != null) {
            return;
        }
        SCharacter sCharacter = this.CreateCharacter(n2);
        sCharacter.type = 4;
        sCharacter.bounds = this.GetRect();
        sCharacter.dataPos = this.pos;
    }

    private void ParseHeader() {
        if (this.scriptErr != 0) {
            return;
        }
        if (this.gotHeader) {
            return;
        }
        if (this.len < 21) {
            return;
        }
        this.frame = this.GetRect();
        this.frameRate = this.GetWord() << 8;
        this.frameDelay = 65536000 / this.frameRate;
        this.numFrames = this.GetWord();
        this.numFramesCompletePos = this.startPos = this.pos;
        this.curFrame = -1;
        this.gotHeader = true;
    }

    public void PushData(byte[] byArray, int n2) {
        if (this.scriptErr != 0) {
            return;
        }
        int n3 = 0;
        if (this.scriptLen < 0) {
            int n4 = Math.min(8 - this.headerLen, n2);
            System.arraycopy(byArray, n3, this.headerBuf, this.headerLen, n4);
            n3 += n4;
            n2 -= n4;
            this.headerLen += n4;
            if (this.headerLen == 8) {
                if (this.headerBuf[0] != 70 || this.headerBuf[1] != 87 || this.headerBuf[2] != 83) {
                    this.scriptErr = -1;
                    return;
                }
                this.version = this.headerBuf[3];
                System.out.println("Flash file version = " + this.version);
                this.scriptLen = this.headerBuf[4] & 0xFF | (this.headerBuf[5] & 0xFF) << 8 | (this.headerBuf[6] & 0xFF) << 16 | (this.headerBuf[7] & 0xFF) << 24;
                this.scriptLen -= 8;
                this.script = new byte[this.scriptLen];
                if (this.script == null) {
                    this.scriptErr = -2;
                    return;
                }
            } else {
                return;
            }
        }
        if (this.len + n2 > this.scriptLen) {
            n2 = Math.min(n2, this.scriptLen - this.len);
        }
        System.arraycopy(byArray, n3, this.script, this.len, n2);
        this.len += n2;
        if (!this.gotHeader) {
            this.ParseHeader();
        }
        this.gotData.set();
    }

    private void DefineJPEGTables(int n2) {
        this.jpegTableLen = n2 - 2;
        this.jpegTablePos = this.pos;
    }

    private int ImageClassToUse() {
        if (imageClassToUse == 0) {
            if (("SLAV" + System.getProperty("java.version")).indexOf("SLAV1.0") == -1) {
                imageClassToUse = 1;
            } else {
                imageClassToUse = 3;
                try {
                    Class.forName("sun.awt.image.ImageDecoder");
                    imageClassToUse = 2;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return imageClassToUse;
    }

    private void DefineBits(int n2, int n3) {
        block15: {
            block16: {
                int n4 = this.GetWord();
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                if (this.FindCharacter(n4) != null) {
                    return;
                }
                SCharacter sCharacter = this.CreateCharacter(n4);
                if (sCharacter == null) {
                    return;
                }
                sCharacter.type = 1;
                sCharacter.dataPos = this.pos - 8;
                if (n3 == 6) {
                    n7 = this.pos + 2;
                    n8 = n2 - 4;
                    n5 = this.jpegTablePos;
                    n6 = this.jpegTableLen;
                } else {
                    int n9 = n5 = this.pos;
                    while (n9 < this.end) {
                        if ((this.script[n9] & 0xFF) == 255 && (this.script[n9 + 1] & 0xFF) == 217) {
                            n6 = n9 - n5;
                            break;
                        }
                        ++n9;
                    }
                    int n10 = n5 + n6;
                    while (n10 < this.end) {
                        if ((this.script[n10] & 0xFF) == 255 && (this.script[n10 + 1] & 0xFF) == 216) {
                            n7 = n10 + 2;
                            n8 = n2 - 6 - n6;
                            break;
                        }
                        ++n10;
                    }
                }
                byte[] byArray = new byte[n6 + n8];
                if (byArray == null) break block16;
                System.arraycopy(this.script, n5, byArray, 0, n6);
                System.arraycopy(this.script, n7, byArray, n6, n8);
                switch (this.ImageClassToUse()) {
                    case 1: {
                        sCharacter.object = new Bitmap(this.flash.getToolkit().createImage(byArray), this.display);
                        break;
                    }
                    case 2: {
                        try {
                            Object obj = Class.forName("ImageSource").newInstance();
                            if (obj != null) {
                                ((ImageSource)obj).SetData(byArray);
                                ((ImageSource)obj).CreateInputStream();
                                Bitmap bitmap = new Bitmap((ImageSource)obj, this.display);
                                ((ImageSource)obj).DestroyInputStream();
                                sCharacter.object = bitmap;
                            }
                            break block15;
                        }
                        catch (Exception exception) {
                            sCharacter.object = null;
                        }
                        break block15;
                    }
                    default: {
                        sCharacter.object = null;
                        break;
                    }
                }
                break block15;
            }
            sCharacter.object = null;
        }
    }

    private int DoTag() {
        if (this.script == null) {
            return -3;
        }
        if (this.scriptErr != 0) {
            return this.scriptErr;
        }
        if (this.atEnd) {
            return 2;
        }
        if (this.len - this.pos < 2) {
            return 1;
        }
        int n2 = this.pos;
        int n3 = this.GetWord();
        int n4 = n3 & 0x3F;
        if (n4 == 63) {
            if (this.len - this.pos < 4) {
                this.pos = n2;
                return 1;
            }
            n4 = this.GetDWord();
        }
        this.end = this.nextPos = this.pos + n4;
        if (this.nextPos > this.len) {
            this.pos = n2;
            return 1;
        }
        switch (n3 >> 6) {
            case 0: {
                this.atEnd = true;
                break;
            }
            case 1: {
                ++this.curFrame;
                break;
            }
            case 2: 
            case 22: {
                this.DefineShape();
                break;
            }
            case 3: {
                this.FreeCharacter(this.GetWord());
                break;
            }
            case 4: {
                this.PlaceObject();
                break;
            }
            case 5: {
                this.RemoveObject();
                break;
            }
            case 6: 
            case 21: {
                this.DefineBits(n4, n3 >> 6);
                break;
            }
            case 20: {
                break;
            }
            case 8: {
                this.DefineJPEGTables(n4);
                break;
            }
            case 14: {
                this.DefineSound(n4);
                break;
            }
            case 15: {
                this.StartSound();
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                this.DefineButtonExtra(true);
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 7: {
                this.DefineButton();
                break;
            }
            case 10: {
                this.DefineFont();
                break;
            }
            case 11: {
                this.DefineText();
                break;
            }
            case 9: {
                this.display.SetBackgroundColor(this.GetColor(), 3);
                break;
            }
            case 12: {
                if (this.nActions >= 16) break;
                this.actionList[this.nActions] = this.pos;
                ++this.nActions;
                break;
            }
            case 23: {
                this.DefineButtonExtra(false);
                break;
            }
        }
        this.pos = this.nextPos;
        return this.scriptErr;
    }

    public int DrawFrame(int n2) {
        if (this.scriptErr != 0) {
            return this.scriptErr;
        }
        if (!this.gotHeader) {
            return 1;
        }
        if (this.curFrame > n2) {
            this.FreeAll();
        }
        int n3 = 0;
        while (this.curFrame < n2 && n3 == 0) {
            n3 = this.DoTag();
        }
        return n3;
    }

    boolean FrameComplete(int n2) {
        if (this.numFramesComplete >= n2) {
            return true;
        }
        if (this.scriptComplete) {
            return true;
        }
        if (this.script == null || this.scriptErr != -3) {
            return false;
        }
        SParser sParser = new SParser();
        sParser.Attach(this.script, this.numFramesCompletePos);
        while (true) {
            if (this.len - sParser.pos < 2) {
                return false;
            }
            int n3 = sParser.GetWord();
            int n4 = n3 & 0x3F;
            if (n4 == 63) {
                if (this.len - this.pos < 4) {
                    return false;
                }
                n4 = sParser.GetDWord();
            }
            sParser.pos += n4;
            if (sParser.pos > this.len) {
                return false;
            }
            this.numFramesCompletePos = sParser.pos;
            if (n3 >> 6 != 1) continue;
            ++this.numFramesComplete;
            if (this.numFramesComplete >= n2) break;
        }
        return true;
    }

    public void loadScript(InputStream inputStream) {
        this.ClearScript();
        this.scriptStream = inputStream;
        Thread thread = new Thread(this);
        thread.setPriority(6);
        thread.start();
    }

    public boolean loadScript(PullSourceStream pullSourceStream) {
        this.ClearScript();
        try {
            int n2;
            byte[] byArray = new byte[512];
            while ((n2 = pullSourceStream.read(byArray, 0, byArray.length)) >= 0) {
                this.PushData(byArray, n2);
            }
        }
        catch (IOException iOException) {
            this.scriptComplete = true;
            return false;
        }
        this.scriptComplete = true;
        return true;
    }

    public void run() {
        try {
            int n2;
            byte[] byArray = new byte[512];
            while ((n2 = this.scriptStream.read(byArray)) >= 0) {
                this.PushData(byArray, n2);
            }
            this.scriptStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.scriptStream = null;
        this.scriptComplete = true;
    }

    public int percentLoaded() {
        if (this.scriptComplete || this.len >= this.scriptLen) {
            return 100;
        }
        return this.len / this.scriptLen;
    }
}

