/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.video;

import com.sun.media.BasicPlugIn;
import com.sun.media.Log;
import com.sun.media.datasink.RandomAccess;
import com.sun.media.multiplexer.BasicMux;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;

public class QuicktimeMux
extends BasicMux {
    private int removeCount = 0;
    private boolean sourceConnected = false;
    private boolean sinkConnected = false;
    private boolean closed = false;
    private boolean opened = false;
    private int debugCounter = 0;
    private Hashtable streamNumberHash;
    private TrakInfo[] trakInfoArray;
    private int dataSize = 0;
    private Format[] rgbFormats;
    private Format[] yuvFormats;
    private int[] scaleOffsets;
    private boolean[] endOfMediaStatus;
    private int numberOfEoms = 0;
    private int numberOfTracks = 0;
    private int numberOfSupportedTracks = 0;
    private static final String VIDEO = "vide";
    private static final String AUDIO = "soun";
    private long mdatOffset;
    private long moovOffset;
    private int mdatLength;
    private int moovLength;
    private long mvhdDurationOffset;
    private static Hashtable audioFourccMapper = new Hashtable();
    private static Hashtable videoFourccMapper = new Hashtable();
    private final int movieTimeScale = 60000;
    private final int DEFAULT_FRAME_RATE = 15;
    private final int DEFAULT_FRAME_DURATION = 4000;
    private final int TRAK_ENABLED = 1;
    private final int TRAK_IN_MOVIE = 2;
    private static final int DATA_SELF_REFERENCE_FLAG = 1;
    private static final boolean ALWAYS_USE_ONE_ENTRY_FOR_STTS = false;
    private static final int EPSILON_DURATION = 1000000;
    private static final int MVHD_ATOM_SIZE = 100;
    private static final int TKHD_ATOM_SIZE = 84;
    private static final int MDHD_ATOM_SIZE = 24;
    private boolean requireTwoPass = true;
    Format bigEndian = new AudioFormat(null, -1.0, -1, -1, 1, -1);

    public QuicktimeMux() {
        this.supportedInputs = new Format[2];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedInputs[1] = new VideoFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new FileTypeDescriptor("video.quicktime");
        int n2 = -1;
        this.rgbFormats = new Format[]{new RGBFormat(null, n2, Format.byteArray, n2, 16, 31744, 992, 31, 2, n2, 0, 0), new RGBFormat(null, n2, Format.byteArray, n2, 24, 1, 2, 3, 3, n2, 0, n2), new RGBFormat(null, n2, Format.byteArray, n2, 32, 2, 3, 4, 4, n2, 0, n2)};
        this.yuvFormats = new Format[]{new YUVFormat(null, n2, Format.byteArray, n2, 96, n2, n2, 0, 1, 3)};
    }

    public String getName() {
        return "Quicktime Multiplexer";
    }

    public Format setInputFormat(Format format, int n2) {
        if (this.trakInfoArray == null) {
            this.trakInfoArray = new TrakInfo[this.numTracks];
            this.endOfMediaStatus = new boolean[this.numTracks];
        }
        if (!(format instanceof VideoFormat) && !(format instanceof AudioFormat)) {
            this.trakInfoArray[n2] = new TrakInfo();
            this.trakInfoArray[n2].format = format;
            this.trakInfoArray[n2].supported = false;
            return format;
        }
        String string = format.getEncoding();
        if (format instanceof VideoFormat) {
            if (videoFourccMapper.get(string.toLowerCase()) == null) {
                return null;
            }
            if (string.equalsIgnoreCase("rgb") && BasicPlugIn.matches(format, this.rgbFormats) == null) {
                return null;
            }
            if (string.equalsIgnoreCase("yuv") && BasicPlugIn.matches(format, this.yuvFormats) == null) {
                return null;
            }
            VideoTrakInfo videoTrakInfo = new VideoTrakInfo();
            this.trakInfoArray[n2] = videoTrakInfo;
            videoTrakInfo.supported = true;
            videoTrakInfo.type = VIDEO;
            videoTrakInfo.encoding = string;
            videoTrakInfo.format = format;
            videoTrakInfo.videoFormat = null;
        } else if (format instanceof AudioFormat) {
            Object object;
            if (string.equalsIgnoreCase("LINEAR")) {
                object = (AudioFormat)format;
                if (((AudioFormat)object).getSampleSizeInBits() > 8) {
                    if (((AudioFormat)object).getSigned() == 0) {
                        return null;
                    }
                    if (((AudioFormat)object).getEndian() == 0) {
                        return null;
                    }
                    if (((AudioFormat)object).getEndian() == -1) {
                        format = ((AudioFormat)object).intersects(this.bigEndian);
                    }
                }
            } else if (audioFourccMapper.get(string.toLowerCase()) == null) {
                return null;
            }
            this.trakInfoArray[n2] = object = new AudioTrakInfo();
            ((TrakInfo)object).supported = true;
            ((TrakInfo)object).type = AUDIO;
            ((TrakInfo)object).encoding = string;
            ((TrakInfo)object).format = format;
            ((AudioTrakInfo)object).audioFormat = (AudioFormat)format;
            ((AudioTrakInfo)object).frameSizeInBytes = ((AudioTrakInfo)object).audioFormat.getFrameSizeInBits() / 8;
            if (((AudioTrakInfo)object).frameSizeInBytes <= 0) {
                ((AudioTrakInfo)object).frameSizeInBytes = ((AudioTrakInfo)object).audioFormat.getSampleSizeInBits() * ((AudioTrakInfo)object).audioFormat.getChannels() / 8;
            }
            if (string.equalsIgnoreCase("ima4")) {
                ((AudioTrakInfo)object).samplesPerBlock = 64;
            } else if (string.equalsIgnoreCase("gsm")) {
                ((AudioTrakInfo)object).samplesPerBlock = 160;
            } else if (string.equalsIgnoreCase("MAC3")) {
                ((AudioTrakInfo)object).samplesPerBlock = 6;
            } else if (string.equalsIgnoreCase("MAC6")) {
                ((AudioTrakInfo)object).samplesPerBlock = 6;
            }
        }
        if (this.trakInfoArray[n2].supported) {
            ++this.numberOfSupportedTracks;
        }
        this.inputs[n2] = format;
        return format;
    }

    public synchronized int doProcess(Buffer buffer, int n2) {
        Object object;
        if (buffer.isEOM() && !this.endOfMediaStatus[n2]) {
            this.endOfMediaStatus[n2] = true;
            ++this.numberOfEoms;
            if (this.numberOfEoms == this.numTracks) {
                return super.doProcess(buffer, n2);
            }
            return 0;
        }
        if (!this.trakInfoArray[n2].initFormat) {
            if (this.trakInfoArray[n2] instanceof VideoTrakInfo) {
                object = (VideoTrakInfo)this.trakInfoArray[n2];
                ((VideoTrakInfo)object).videoFormat = (VideoFormat)buffer.getFormat();
                ((VideoTrakInfo)object).frameRate = ((VideoTrakInfo)object).videoFormat.getFrameRate();
                if (((VideoTrakInfo)object).frameRate > 0.0f) {
                    ((VideoTrakInfo)object).frameDuration = (int)((double)(1.0f / ((VideoTrakInfo)object).frameRate * 60000.0f) + 0.5);
                } else {
                    ((VideoTrakInfo)object).frameRate = 15.0f;
                    ((VideoTrakInfo)object).frameDuration = 4000;
                }
            }
            this.trakInfoArray[n2].initFormat = true;
        }
        if ((object = buffer.getData()) == null) {
            return 1;
        }
        byte[] byArray = (byte[])object;
        if (byArray == null) {
            return 1;
        }
        int n3 = buffer.getLength();
        this.dataSize += n3;
        TrakInfo trakInfo = this.trakInfoArray[n2];
        this.write(byArray, 0, n3);
        int n4 = this.filePointer - n3;
        int n5 = trakInfo.chunkOffsetsIndex++;
        int n6 = trakInfo.numChunkOffsetsArraysUsed++;
        trakInfo.chunkOffsetsArray[n6 - 1][n5] = n4;
        if (++n5 >= 1000) {
            trakInfo.chunkOffsetsIndex = 0;
            trakInfo.chunkOffsetsArray[n6] = new int[1000];
            if (++n6 >= 1000) {
                System.err.println("Cannot create quicktime file with more than " + 1000 * 1000 + " chunks ");
                return 1;
            }
        }
        String string = trakInfo.type;
        VideoTrakInfo videoTrakInfo = null;
        AudioTrakInfo audioTrakInfo = null;
        if (string.equals(VIDEO)) {
            boolean bl;
            videoTrakInfo = (VideoTrakInfo)trakInfo;
            int n7 = videoTrakInfo.sampleSizeIndex++;
            int n8 = videoTrakInfo.numSampleSizeArraysUsed;
            videoTrakInfo.sampleSize[n8 - 1][n7] = n3;
            if (videoTrakInfo.constantSampleSize && n3 != videoTrakInfo.sampleSize[0][0]) {
                videoTrakInfo.constantSampleSize = false;
            }
            if (videoTrakInfo.minDuration >= 0L) {
                long l2 = buffer.getTimeStamp();
                if (l2 <= -1L) {
                    videoTrakInfo.minDuration = -1L;
                } else if (videoTrakInfo.totalFrames > 0) {
                    long l3 = l2 - videoTrakInfo.previousTimeStamp;
                    if (l3 < videoTrakInfo.minDuration) {
                        videoTrakInfo.minDuration = l3;
                    } else if (l3 > videoTrakInfo.maxDuration) {
                        videoTrakInfo.maxDuration = l3;
                    }
                    int n9 = videoTrakInfo.timeStampIndex++;
                    int n10 = videoTrakInfo.numTimeStampArraysUsed++;
                    videoTrakInfo.timeStamps[n10 - 1][n9] = l3;
                    if (++n9 >= 1000) {
                        videoTrakInfo.timeStampIndex = 0;
                        videoTrakInfo.timeStamps[n10] = new long[1000];
                        if (++n10 >= 1000) {
                            System.err.println("Cannot create quicktime file with more than " + 1000 * 1000 + " frames ");
                            return 1;
                        }
                    }
                }
                videoTrakInfo.previousTimeStamp = l2;
            }
            if (++n7 >= 2000) {
                videoTrakInfo.sampleSizeIndex = 0;
                videoTrakInfo.sampleSize[n8] = new int[2000];
                ++videoTrakInfo.numSampleSizeArraysUsed;
                if (++n8 >= 1000) {
                    System.err.println("Cannot create quicktime file with more than " + 1000 * 2000 + " samples ");
                    return 1;
                }
            }
            boolean bl2 = bl = (buffer.getFlags() & 0x10) > 0;
            if (bl) {
                int n11 = videoTrakInfo.keyFrameIndex++;
                int n12 = videoTrakInfo.numKeyFrameArraysUsed++;
                videoTrakInfo.keyFrames[n12 - 1][n11] = videoTrakInfo.totalFrames + 1;
                if (++n11 >= 1000) {
                    videoTrakInfo.keyFrameIndex = 0;
                    videoTrakInfo.keyFrames[n12] = new int[1000];
                    if (++n12 >= 1000) {
                        System.err.println("Cannot create quicktime file with more than " + 1000 * 1000 + " keyframes ");
                        return 1;
                    }
                }
            }
        } else {
            audioTrakInfo = (AudioTrakInfo)trakInfo;
            int n13 = n3 / audioTrakInfo.frameSizeInBytes * audioTrakInfo.samplesPerBlock;
            audioTrakInfo.numSamples += n13;
            if (audioTrakInfo.previousSamplesPerChunk != n13) {
                int n14 = audioTrakInfo.samplesPerChunkIndex;
                int n15 = audioTrakInfo.numSamplesPerChunkArraysUsed++;
                audioTrakInfo.samplesPerChunkArray[n15 - 1][n14] = trakInfo.totalFrames + 1;
                audioTrakInfo.samplesPerChunkArray[n15 - 1][++n14] = n13;
                ++n14;
                audioTrakInfo.samplesPerChunkIndex = n14++;
                audioTrakInfo.previousSamplesPerChunk = n13;
                if (n14 >= 1000) {
                    audioTrakInfo.samplesPerChunkIndex = 0;
                    audioTrakInfo.samplesPerChunkArray[n15] = new int[1000];
                    if (++n15 >= 1000) {
                        System.err.println("Cannot create quicktime file with more than " + 1000 * 1000 + " chunks ");
                        return 1;
                    }
                }
            }
        }
        ++trakInfo.totalFrames;
        return 0;
    }

    protected void writeHeader() {
        this.mdatOffset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("mdat");
        this.bufFlush();
        this.dataSize = 0;
    }

    public boolean requireTwoPass() {
        return this.requireTwoPass;
    }

    protected void writeFooter() {
        this.moovOffset = this.filePointer;
        this.seek((int)this.mdatOffset);
        this.bufClear();
        this.mdatLength = 8 + this.dataSize;
        this.bufWriteInt(this.mdatLength);
        this.bufFlush();
        this.seek((int)this.moovOffset);
        this.writeMOOV();
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.numTracks) {
            if (this.trakInfoArray[n3].supported) {
                this.writeSize(this.trakInfoArray[n3].tkhdDurationOffset, this.trakInfoArray[n3].duration);
                if (this.trakInfoArray[n3].type.equals(VIDEO)) {
                    this.writeSize(this.trakInfoArray[n3].mdhdDurationOffset, this.trakInfoArray[n3].duration);
                }
                if (this.trakInfoArray[n3].duration > n2) {
                    n2 = this.trakInfoArray[n3].duration;
                }
            }
            ++n3;
        }
        this.writeSize(this.mvhdDurationOffset, n2);
        if (this.requireTwoPass && this.sth != null && this.sth instanceof RandomAccess) {
            RandomAccess randomAccess = (RandomAccess)((Object)this.sth);
            if (randomAccess.write(-1L, this.moovLength + this.mdatLength)) {
                this.updateSTCO();
                this.write(null, 0, -1);
                randomAccess.write(this.moovOffset, this.moovLength);
                randomAccess.write(this.mdatOffset, this.mdatLength);
            } else {
                System.err.println("No space to write streamable file");
            }
            randomAccess.write(-1L, -1);
        }
    }

    private int writeMOOV() {
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("moov");
        this.bufFlush();
        int n2 = 8;
        n2 += this.writeMVHD();
        int n3 = 0;
        while (n3 < this.numTracks) {
            if (this.trakInfoArray[n3].supported) {
                n2 += this.writeTRAK(n3, this.trakInfoArray[n3].type);
            }
            ++n3;
        }
        this.moovLength = n2;
        return this.writeSize(l2, n2);
    }

    private int writeMVHD() {
        this.bufClear();
        this.bufWriteInt(108);
        this.bufWriteBytes("mvhd");
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(60000);
        this.mvhdDurationOffset = this.filePointer;
        this.bufWriteInt(0);
        this.bufWriteInt(65536);
        this.bufWriteShort((short)255);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        this.bufFlush();
        this.writeMatrix();
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(this.numberOfSupportedTracks + 1);
        this.bufFlush();
        return 108;
    }

    private int writeSize(long l2, int n2) {
        long l3 = this.filePointer;
        this.seek((int)l2);
        this.bufClear();
        this.bufWriteInt(n2);
        this.bufFlush();
        this.seek((int)l3);
        return n2;
    }

    private int writeTRAK(int n2, String string) {
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("trak");
        this.bufFlush();
        int n3 = 8;
        n3 += this.writeTKHD(n2, string);
        return this.writeSize(l2, n3 += this.writeMDIA(n2, string));
    }

    private int writeTKHD(int n2, String string) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (string.equals(VIDEO)) {
            VideoTrakInfo videoTrakInfo = (VideoTrakInfo)this.trakInfoArray[n2];
            Dimension dimension = null;
            VideoFormat videoFormat = videoTrakInfo.videoFormat;
            if (videoFormat != null) {
                dimension = videoFormat.getSize();
            }
            if (dimension != null) {
                n3 = dimension.width;
                n4 = dimension.height;
            }
            n5 = videoTrakInfo.duration;
        } else {
            AudioTrakInfo audioTrakInfo = (AudioTrakInfo)this.trakInfoArray[n2];
            float f2 = (int)audioTrakInfo.audioFormat.getSampleRate();
            float f3 = 0.01f;
            audioTrakInfo.duration = n5 = (int)((float)audioTrakInfo.numSamples / f2 * 60000.0f + f3);
            n6 = 255;
        }
        this.bufClear();
        this.bufWriteInt(92);
        this.bufWriteBytes("tkhd");
        this.bufWriteInt(3);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(n2 + 1);
        this.bufWriteInt(0);
        this.trakInfoArray[n2].tkhdDurationOffset = this.filePointer;
        this.bufWriteInt(n5);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)n6);
        this.bufWriteShort((short)0);
        this.bufFlush();
        this.writeMatrix();
        this.bufClear();
        this.bufWriteInt(n3 * 65536);
        this.bufWriteInt(n4 * 65536);
        this.bufFlush();
        return 92;
    }

    private int writeMDIA(int n2, String string) {
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("mdia");
        this.bufFlush();
        int n3 = 8;
        n3 += this.writeMDHD(n2, string);
        n3 += this.writeMhlrHdlr(n2, string);
        return this.writeSize(l2, n3 += this.writeMINF(n2, string));
    }

    private void writeMatrix() {
        this.bufClear();
        this.bufWriteInt(65536);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(65536);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0x40000000);
        this.bufFlush();
    }

    private int writeMDHD(int n2, String string) {
        int n3 = 0;
        int n4 = 0;
        if (string.equals(VIDEO)) {
            n3 = 60000;
            VideoTrakInfo videoTrakInfo = (VideoTrakInfo)this.trakInfoArray[n2];
            n4 = videoTrakInfo.duration;
        } else {
            AudioTrakInfo audioTrakInfo = (AudioTrakInfo)this.trakInfoArray[n2];
            n3 = (int)audioTrakInfo.audioFormat.getSampleRate();
            n4 = audioTrakInfo.numSamples;
        }
        this.bufClear();
        this.bufWriteInt(32);
        this.bufWriteBytes("mdhd");
        this.bufWriteInt(1);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(n3);
        this.trakInfoArray[n2].mdhdDurationOffset = this.filePointer;
        this.bufWriteInt(n4);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufFlush();
        return 32;
    }

    private int writeMINF(int n2, String string) {
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("minf");
        this.bufFlush();
        int n3 = 8;
        n3 = string.equals(VIDEO) ? (n3 += this.writeVMHD(n2, string)) : (n3 += this.writeSMHD(n2, string));
        n3 += this.writeDHlrHdlr(n2, string);
        n3 += this.writeDINF(n2, string);
        return this.writeSize(l2, n3 += this.writeSTBL(n2, string));
    }

    private int writeVMHD(int n2, String string) {
        this.bufClear();
        this.bufWriteInt(20);
        this.bufWriteBytes("vmhd");
        this.bufWriteInt(1);
        this.bufWriteShort((short)64);
        this.bufWriteShort((short)Short.MIN_VALUE);
        this.bufWriteShort((short)Short.MIN_VALUE);
        this.bufWriteShort((short)Short.MIN_VALUE);
        this.bufFlush();
        return 20;
    }

    private int writeSMHD(int n2, String string) {
        this.bufClear();
        this.bufWriteInt(16);
        this.bufWriteBytes("smhd");
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufFlush();
        return 16;
    }

    private int writeMhlrHdlr(int n2, String string) {
        this.bufClear();
        this.bufWriteInt(36);
        this.bufWriteBytes("hdlr");
        this.bufWriteInt(0);
        this.bufWriteBytes("mhlr");
        this.bufWriteBytes(string);
        this.bufWriteBytes("    ");
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteBytes("    ");
        this.bufFlush();
        return 36;
    }

    private int writeDHlrHdlr(int n2, String string) {
        this.bufClear();
        this.bufWriteInt(36);
        this.bufWriteBytes("hdlr");
        this.bufWriteInt(0);
        this.bufWriteBytes("dhlr");
        this.bufWriteBytes("alis");
        this.bufWriteBytes("    ");
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteBytes("    ");
        this.bufFlush();
        return 36;
    }

    private int writeDINF(int n2, String string) {
        this.bufClear();
        this.bufWriteInt(36);
        this.bufWriteBytes("dinf");
        this.bufWriteInt(28);
        this.bufWriteBytes("dref");
        this.bufWriteInt(0);
        this.bufWriteInt(1);
        this.bufWriteInt(12);
        this.bufWriteBytes("alis");
        this.bufWriteInt(1);
        this.bufFlush();
        return 36;
    }

    private int writeSTBL(int n2, String string) {
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stbl");
        this.bufFlush();
        int n3 = 8;
        n3 += this.writeSTSD(n2, string);
        n3 += this.writeSTTS(n2, string);
        n3 += this.writeSTSS(n2, string);
        n3 += this.writeSTSC(n2, string);
        n3 += this.writeSTSZ(n2, string);
        return this.writeSize(l2, n3 += this.writeSTCO(n2, string));
    }

    private int writeSTSD(int n2, String string) {
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stsd");
        int n3 = 8;
        this.bufWriteInt(0);
        this.bufWriteInt(1);
        this.bufFlush();
        n3 += 8;
        n3 = string.equals(VIDEO) ? (n3 += this.writeVideoSampleDescription(n2, string)) : (n3 += this.writeAudioSampleDescription(n2, string));
        return this.writeSize(l2, n3);
    }

    private int writeVideoSampleDescription(int n2, String string) {
        int n3;
        VideoTrakInfo videoTrakInfo = (VideoTrakInfo)this.trakInfoArray[n2];
        int n4 = videoTrakInfo.videoFormat.getSize().width;
        int n5 = videoTrakInfo.videoFormat.getSize().height;
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        int n6 = 4;
        String string2 = videoTrakInfo.encoding;
        String string3 = null;
        if (string2.equalsIgnoreCase("rgb")) {
            RGBFormat rGBFormat = (RGBFormat)videoTrakInfo.format;
            n3 = rGBFormat.getBitsPerPixel();
            string3 = "raw ";
        } else {
            string3 = (String)videoFourccMapper.get(string2.toLowerCase());
            n3 = 24;
        }
        this.bufWriteBytes(string3);
        n6 += 4;
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        n6 += 6;
        this.bufWriteShort((short)1);
        n6 += 2;
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufWriteBytes("appl");
        this.bufWriteInt(1023);
        this.bufWriteInt(1023);
        this.bufWriteShort((short)n4);
        this.bufWriteShort((short)n5);
        this.bufWriteInt(0x480000);
        this.bufWriteInt(0x480000);
        this.bufWriteInt(0);
        this.bufWriteShort((short)1);
        this.bufWriteBytes(string3);
        this.bufWriteBytes("                            ");
        this.bufWriteShort((short)n3);
        this.bufWriteShort((short)-1);
        this.bufFlush();
        return this.writeSize(l2, n6 += 70);
    }

    private int writeAudioSampleDescription(int n2, String string) {
        AudioTrakInfo audioTrakInfo = (AudioTrakInfo)this.trakInfoArray[n2];
        AudioFormat audioFormat = audioTrakInfo.audioFormat;
        int n3 = audioFormat.getChannels();
        int n4 = audioFormat.getSampleSizeInBits();
        int n5 = (int)audioFormat.getSampleRate();
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        int n6 = 4;
        String string2 = audioTrakInfo.encoding;
        String string3 = string2.equalsIgnoreCase("LINEAR") ? (n4 == 8 && audioFormat.getSigned() == 0 ? "raw " : "twos") : (String)audioFourccMapper.get(string2.toLowerCase());
        this.bufWriteBytes(string3);
        n6 += 4;
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        n6 += 6;
        this.bufWriteShort((short)1);
        n6 += 2;
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufWriteInt(0);
        this.bufWriteShort((short)n3);
        this.bufWriteShort((short)n4);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufWriteInt(n5 * 65536);
        this.bufFlush();
        return this.writeSize(l2, n6 += 20);
    }

    private int writeSTTS(int n2, String string) {
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stts");
        int n3 = 8;
        this.bufWriteInt(0);
        n3 += 4;
        if (string.equals(VIDEO)) {
            VideoTrakInfo videoTrakInfo = (VideoTrakInfo)this.trakInfoArray[n2];
            if (videoTrakInfo.minDuration <= -1L || videoTrakInfo.maxDuration - videoTrakInfo.minDuration < 1000000L) {
                this.bufWriteInt(1);
                n3 += 4;
                this.bufWriteInt(videoTrakInfo.totalFrames);
                this.bufWriteInt(videoTrakInfo.frameDuration);
                videoTrakInfo.duration = videoTrakInfo.totalFrames * videoTrakInfo.frameDuration;
                n3 += 8;
            } else {
                int n4;
                int n5;
                int n6;
                this.bufWriteInt(videoTrakInfo.totalFrames);
                n3 += 4;
                videoTrakInfo.duration = 0;
                long[][] lArray = videoTrakInfo.timeStamps;
                int n7 = 0;
                int n8 = 0;
                long l3 = 0L;
                int n9 = videoTrakInfo.totalFrames - 1;
                int n10 = 8;
                int n11 = (this.maxBufSize - 200) / n10 * n10;
                int n12 = n9 * n10;
                if (n12 <= n11) {
                    n6 = 1;
                    n5 = n9;
                } else {
                    n6 = n12 / n11;
                    if ((float)n12 / (float)n11 > (float)n6) {
                        ++n6;
                    }
                    n5 = n11 / n10;
                }
                int n13 = 0;
                while (n13 < n6) {
                    n4 = 0;
                    while (n4 < n5) {
                        this.bufWriteInt(1);
                        l3 = lArray[n7][n8++];
                        int n14 = (int)(0.5 + (double)l3 / 1.0E9 * 60000.0);
                        this.bufWriteInt(n14);
                        videoTrakInfo.duration += n14;
                        n3 += 8;
                        if (n8 >= 1000) {
                            ++n7;
                            n8 = 0;
                        }
                        ++n4;
                    }
                    this.bufFlush();
                    this.bufClear();
                    if (n13 == n6 - 2) {
                        n5 = n9 - (n6 - 1) * n5;
                    }
                    ++n13;
                }
                if (videoTrakInfo.totalFrames > 1) {
                    this.bufWriteInt(1);
                    n4 = (int)((double)l3 / 1.0E9 * 60000.0);
                    this.bufWriteInt(n4);
                    n3 += 8;
                    videoTrakInfo.duration += n4;
                }
            }
            int n15 = 0;
            while (n15 < videoTrakInfo.numTimeStampArraysUsed) {
                videoTrakInfo.timeStamps[n15] = null;
                ++n15;
            }
        } else {
            AudioTrakInfo audioTrakInfo = (AudioTrakInfo)this.trakInfoArray[n2];
            this.bufWriteInt(1);
            n3 += 4;
            this.bufWriteInt(audioTrakInfo.numSamples);
            this.bufWriteInt(1);
            n3 += 8;
        }
        if (this.bufLength > 0) {
            this.bufFlush();
        }
        return this.writeSize(l2, n3);
    }

    private int writeSTSS(int n2, String string) {
        int n3;
        int n4;
        if (!string.equals(VIDEO)) {
            return 0;
        }
        VideoTrakInfo videoTrakInfo = (VideoTrakInfo)this.trakInfoArray[n2];
        int n5 = videoTrakInfo.numKeyFrameArraysUsed;
        int n6 = (n5 - 1) * 1000 + videoTrakInfo.keyFrameIndex;
        if (n6 == 0) {
            Log.warning("Error: There should be atleast 1 keyframe in the track. All frames are now treated as keyframes");
            return 0;
        }
        if (n6 == videoTrakInfo.totalFrames) {
            int n7 = 0;
            while (n7 < n5) {
                videoTrakInfo.keyFrames[n7] = null;
                ++n7;
            }
            return 0;
        }
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stss");
        int n8 = 8;
        this.bufWriteInt(0);
        n8 += 4;
        int[][] nArray = videoTrakInfo.keyFrames;
        this.bufWriteInt(n6);
        n8 += 4;
        int n9 = n6;
        int n10 = 4;
        int n11 = (this.maxBufSize - 200) / n10 * n10;
        int n12 = n9 * n10;
        if (n12 <= n11) {
            n4 = 1;
            n3 = n9;
        } else {
            n4 = n12 / n11;
            if ((float)n12 / (float)n11 > (float)n4) {
                ++n4;
            }
            n3 = n11 / n10;
        }
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        while (n15 < n4) {
            int n16 = 0;
            while (n16 < n3) {
                this.bufWriteInt(nArray[n13][n14++]);
                if (n14 >= 1000) {
                    ++n13;
                    n14 = 0;
                }
                ++n16;
            }
            this.bufFlush();
            this.bufClear();
            if (n15 == n4 - 2) {
                n3 = n9 - (n4 - 1) * n3;
            }
            ++n15;
        }
        return this.writeSize(l2, n8 += n6 * 4);
    }

    private int writeSTSC(int n2, String string) {
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stsc");
        int n3 = 8;
        this.bufWriteInt(0);
        n3 += 4;
        if (string.equals(VIDEO)) {
            VideoTrakInfo videoTrakInfo = (VideoTrakInfo)this.trakInfoArray[n2];
            this.bufWriteInt(1);
            n3 += 4;
            this.bufWriteInt(1);
            this.bufWriteInt(1);
            this.bufWriteInt(1);
            n3 += 12;
        } else {
            int n4;
            int n5;
            AudioTrakInfo audioTrakInfo = (AudioTrakInfo)this.trakInfoArray[n2];
            int n6 = ((audioTrakInfo.numSamplesPerChunkArraysUsed - 1) * 1000 + audioTrakInfo.samplesPerChunkIndex) / 2;
            this.bufWriteInt(n6);
            n3 += 4;
            int n7 = n6;
            int n8 = 12;
            int n9 = (this.maxBufSize - 200) / n8 * n8;
            int n10 = n7 * n8;
            if (n10 <= n9) {
                n5 = 1;
                n4 = n7;
            } else {
                n5 = n10 / n9;
                if ((float)n10 / (float)n9 > (float)n5) {
                    ++n5;
                }
                n4 = n9 / n8;
            }
            int n11 = 0;
            int n12 = 0;
            int[][] nArray = audioTrakInfo.samplesPerChunkArray;
            int n13 = 0;
            while (n13 < n5) {
                int n14 = 0;
                while (n14 < n4) {
                    this.bufWriteInt(nArray[n11][n12++]);
                    this.bufWriteInt(nArray[n11][n12++]);
                    this.bufWriteInt(1);
                    if (n12 >= 1000) {
                        ++n11;
                        n12 = 0;
                    }
                    ++n14;
                }
                this.bufFlush();
                this.bufClear();
                if (n13 == n5 - 2) {
                    n4 = n7 - (n5 - 1) * n4;
                }
                ++n13;
            }
            n3 += n6 * 12;
        }
        if (this.bufLength > 0) {
            this.bufFlush();
        }
        return this.writeSize(l2, n3);
    }

    private int writeSTSZ(int n2, String string) {
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stsz");
        int n3 = 8;
        this.bufWriteInt(0);
        n3 += 4;
        TrakInfo trakInfo = this.trakInfoArray[n2];
        if (string.equals(AUDIO)) {
            this.bufWriteInt(1);
            this.bufWriteInt(((AudioTrakInfo)trakInfo).numSamples);
            n3 += 8;
        } else if (string.equals(VIDEO)) {
            int n4;
            VideoTrakInfo videoTrakInfo = (VideoTrakInfo)trakInfo;
            int n5 = videoTrakInfo.numSampleSizeArraysUsed;
            int n6 = trakInfo.totalFrames;
            if (trakInfo.constantSampleSize) {
                n4 = videoTrakInfo.sampleSize[0][0];
                this.bufWriteInt(n4);
                this.bufWriteInt(n6);
                n3 += 8;
            } else {
                int n7;
                int n8;
                int[][] nArray = videoTrakInfo.sampleSize;
                this.bufWriteInt(0);
                this.bufWriteInt(n6);
                n3 += 8;
                int n9 = n6;
                int n10 = 4;
                int n11 = (this.maxBufSize - 200) / n10 * n10;
                int n12 = n9 * n10;
                if (n12 <= n11) {
                    n8 = 1;
                    n7 = n9;
                } else {
                    n8 = n12 / n11;
                    if ((float)n12 / (float)n11 > (float)n8) {
                        ++n8;
                    }
                    n7 = n11 / n10;
                }
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = 0;
                    while (n16 < n7) {
                        this.bufWriteInt(nArray[n13][n14++]);
                        if (n14 >= 2000) {
                            ++n13;
                            n14 = 0;
                        }
                        ++n16;
                    }
                    this.bufFlush();
                    this.bufClear();
                    if (n15 == n8 - 2) {
                        n7 = n9 - (n8 - 1) * n7;
                    }
                    ++n15;
                }
                n3 += n6 * 4;
            }
            n4 = 0;
            while (n4 < n5) {
                videoTrakInfo.sampleSize[n4] = null;
                ++n4;
            }
        }
        if (this.bufLength > 0) {
            this.bufFlush();
        }
        return this.writeSize(l2, n3);
    }

    private int writeSTCO(int n2, String string) {
        int n3;
        int n4;
        long l2 = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stco");
        int n5 = 8;
        this.bufWriteInt(0);
        n5 += 4;
        TrakInfo trakInfo = this.trakInfoArray[n2];
        int n6 = trakInfo.numChunkOffsetsArraysUsed;
        int[][] nArray = trakInfo.chunkOffsetsArray;
        this.bufWriteInt(trakInfo.totalFrames);
        n5 += 4;
        int n7 = trakInfo.totalFrames;
        int n8 = 4;
        int n9 = (this.maxBufSize - 200) / n8 * n8;
        int n10 = n7 * n8;
        if (n10 <= n9) {
            n4 = 1;
            n3 = n7;
        } else {
            n4 = n10 / n9;
            if ((float)n10 / (float)n9 > (float)n4) {
                ++n4;
            }
            n3 = n9 / n8;
        }
        int n11 = 0;
        int n12 = 0;
        trakInfo.chunkOffsetOffset = this.filePointer;
        int n13 = 0;
        while (n13 < n4) {
            int n14 = 0;
            while (n14 < n3) {
                int n15 = (int)((long)nArray[n11][n12++] - this.mdatOffset);
                this.bufWriteInt(n15);
                if (n12 >= 1000) {
                    ++n11;
                    n12 = 0;
                }
                ++n14;
            }
            this.bufFlush();
            this.bufClear();
            if (n13 == n4 - 2) {
                n3 = n7 - (n4 - 1) * n3;
            }
            ++n13;
        }
        return this.writeSize(l2, n5 += trakInfo.totalFrames * 4);
    }

    private void updateSTCO() {
        int n2 = 0;
        while (n2 < this.trakInfoArray.length) {
            int n3;
            int n4;
            TrakInfo trakInfo = this.trakInfoArray[n2];
            int n5 = trakInfo.numChunkOffsetsArraysUsed;
            int[][] nArray = trakInfo.chunkOffsetsArray;
            int n6 = trakInfo.chunkOffsetOffset;
            this.seek(n6);
            this.bufClear();
            int n7 = trakInfo.totalFrames;
            int n8 = 4;
            int n9 = (this.maxBufSize - 200) / n8 * n8;
            int n10 = n7 * n8;
            if (n10 <= n9) {
                n4 = 1;
                n3 = n7;
            } else {
                n4 = n10 / n9;
                if ((float)n10 / (float)n9 > (float)n4) {
                    ++n4;
                }
                n3 = n9 / n8;
            }
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            while (n13 < n4) {
                int n14 = 0;
                while (n14 < n3) {
                    int n15 = nArray[n11][n12++] + this.moovLength;
                    this.bufWriteInt(n15);
                    if (n12 >= 1000) {
                        ++n11;
                        n12 = 0;
                    }
                    ++n14;
                }
                this.bufFlush();
                this.bufClear();
                if (n13 == n4 - 2) {
                    n3 = n7 - (n4 - 1) * n3;
                }
                ++n13;
            }
            ++n2;
        }
    }

    static {
        audioFourccMapper.put("alaw", "alaw");
        audioFourccMapper.put("ulaw", "ulaw");
        audioFourccMapper.put("ima4", "ima4");
        audioFourccMapper.put("gsm", "agsm");
        audioFourccMapper.put("MAC3", "MAC3");
        audioFourccMapper.put("MAC6", "MAC6");
        videoFourccMapper.put("rgb", "rgb");
        videoFourccMapper.put("cvid", "cvid");
        videoFourccMapper.put("jpeg", "jpeg");
        videoFourccMapper.put("h261", "h261");
        videoFourccMapper.put("h263", "h263");
        videoFourccMapper.put("iv32", "iv32");
        videoFourccMapper.put("iv41", "iv41");
        videoFourccMapper.put("iv50", "iv50");
        videoFourccMapper.put("mjpg", "mjpg");
        videoFourccMapper.put("mjpa", "mjpa");
        videoFourccMapper.put("mjpb", "mjpb");
        videoFourccMapper.put("mpeg", "mpeg");
        videoFourccMapper.put("rpza", "rpza");
        videoFourccMapper.put("yuv", "yuv2");
    }

    private class AudioTrakInfo
    extends TrakInfo {
        AudioFormat audioFormat;
        final int IMA4_SAMPLES_PER_BLOCK = 64;
        final int GSM_SAMPLES_PER_BLOCK = 160;
        final int MAC3_SAMPLES_PER_BLOCK = 6;
        final int MAC6_SAMPLES_PER_BLOCK = 6;
        int samplesPerBlock = 1;
        int numSamples = 0;
        int frameSizeInBytes;
        final int MAX_SAMPLESPERCHUNK_NUMARRAYS = 1000;
        final int MAX_SAMPLESPERCHUNK_ARRAYSIZE = 1000;
        int numSamplesPerChunkArraysUsed = 1;
        int samplesPerChunkIndex = 0;
        int[][] samplesPerChunkArray = new int[1000][];
        int previousSamplesPerChunk = -1;

        public AudioTrakInfo() {
            this.samplesPerChunkArray[0] = new int[1000];
            this.samplesPerChunkArray[0][0] = 1;
            this.samplesPerChunkArray[0][1] = -1;
        }
    }

    private class VideoTrakInfo
    extends TrakInfo {
        VideoFormat videoFormat;
        float frameRate;
        int frameDuration;
        final int MAX_SAMPLE_SIZE_NUMARRAYS = 1000;
        final int MAX_SAMPLE_SIZE_ARRAYSIZE = 2000;
        int numSampleSizeArraysUsed = 1;
        int sampleSizeIndex = 0;
        int[][] sampleSize;
        final int MAX_KEYFRAME_NUMARRAYS = 1000;
        final int MAX_KEYFRAME_ARRAYSIZE = 1000;
        int numKeyFrameArraysUsed = 1;
        int keyFrameIndex = 0;
        int[][] keyFrames;
        final int MAX_TIMESTAMP_NUMARRAYS = 1000;
        final int MAX_TIMESTAMP_ARRAYSIZE = 1000;
        int numTimeStampArraysUsed = 1;
        int timeStampIndex = 0;
        long[][] timeStamps;
        long minDuration = Long.MAX_VALUE;
        long maxDuration = -1L;
        long previousTimeStamp;

        public VideoTrakInfo() {
            this.sampleSize = new int[1000][];
            this.sampleSize[0] = new int[2000];
            this.keyFrames = new int[1000][];
            this.keyFrames[0] = new int[1000];
            this.timeStamps = new long[1000][];
            this.timeStamps[0] = new long[1000];
        }

        public String toString() {
            return super.toString() + " \n frameRate " + this.frameRate + " : frameDuration " + this.frameDuration;
        }
    }

    private class TrakInfo {
        boolean initFormat = false;
        boolean supported = false;
        String type;
        String encoding;
        Format format;
        long tkhdDurationOffset = -1L;
        long mdhdDurationOffset = -1L;
        int totalFrames = 0;
        int duration;
        boolean constantSampleSize = true;
        final int MAX_CHUNKOFFSETS_NUMARRAYS = 1000;
        final int MAX_CHUNKOFFSETS_ARRAYSIZE = 1000;
        int numChunkOffsetsArraysUsed = 1;
        int chunkOffsetsIndex = 0;
        int[][] chunkOffsetsArray = new int[1000][];
        int chunkOffsetOffset;

        public TrakInfo() {
            this.chunkOffsetsArray[0] = new int[1000];
        }

        public String toString() {
            if (!this.supported) {
                System.out.println("No support for format " + this.format);
            }
            return this.type + ": " + this.encoding + " : totalFrames " + this.totalFrames;
        }
    }
}

