/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser;

import com.sun.media.BasicPlugIn;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.CachedStream;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;

public abstract class BasicPullParser
extends BasicPlugIn
implements Demultiplexer {
    protected DataSource source;
    protected SourceStream[] streams;
    private Format[] outputFormats;
    private byte[] b = new byte[1];
    private byte[] intArray = new byte[4];
    private byte[] shortArray = new byte[2];
    private final int TEMP_BUFFER_LENGTH = 2048;
    private byte[] tempBuffer = new byte[2048];
    private long currentLocation = 0L;
    protected boolean seekable = false;
    protected boolean positionable = false;
    protected CachedStream cacheStream;
    private Object sync = new Object();

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        this.streams = ((PullDataSource)dataSource).getStreams();
        if (this.streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (this.streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        this.source = dataSource;
        this.streams = this.streams;
        this.positionable = this.streams[0] instanceof Seekable;
        boolean bl = this.seekable = this.positionable && ((Seekable)((Object)this.streams[0])).isRandomAccess();
        if (!this.supports(this.streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        try {
            this.cacheStream = (CachedStream)((Object)this.streams[0]);
        }
        catch (ClassCastException classCastException) {
            this.cacheStream = null;
        }
    }

    protected boolean supports(SourceStream[] sourceStreamArray) {
        return sourceStreamArray[0] != null && sourceStreamArray[0] instanceof PullSourceStream;
    }

    public boolean isPositionable() {
        return this.positionable;
    }

    public boolean isRandomAccess() {
        return this.seekable;
    }

    public int readBytes(PullSourceStream pullSourceStream, byte[] byArray, int n2) throws IOException {
        return this.readBytes(pullSourceStream, byArray, 0, n2);
    }

    public int readBytes(PullSourceStream pullSourceStream, byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = n3;
        int n5 = 0;
        n4 = n3;
        while (n4 > 0) {
            n5 = pullSourceStream.read(byArray, n2, n4);
            if (n5 == -1) {
                if (n2 == 0) {
                    throw new IOException("BasicPullParser: readBytes(): Reached end of stream while trying to read " + n3 + " bytes");
                }
                return n2;
            }
            if (n5 == -2) {
                return -2;
            }
            if (n5 < 0) {
                throw new IOException("BasicPullParser: readBytes() read returned " + n5);
            }
            n4 -= n5;
            n2 += n5;
            Object object = this.sync;
            synchronized (object) {
                this.currentLocation += (long)n5;
            }
        }
        return n3;
    }

    public int readInt(PullSourceStream pullSourceStream) throws IOException {
        return this.readInt(pullSourceStream, true);
    }

    public int readShort(PullSourceStream pullSourceStream) throws IOException {
        return this.readShort(pullSourceStream, true);
    }

    public int readByte(PullSourceStream pullSourceStream) throws IOException {
        this.readBytes(pullSourceStream, this.b, 1);
        return this.b[0];
    }

    protected int readInt(PullSourceStream pullSourceStream, boolean bl) throws IOException {
        this.readBytes(pullSourceStream, this.intArray, 4);
        int n2 = bl ? (this.intArray[0] & 0xFF) << 24 | (this.intArray[1] & 0xFF) << 16 | (this.intArray[2] & 0xFF) << 8 | this.intArray[3] & 0xFF : (this.intArray[3] & 0xFF) << 24 | (this.intArray[2] & 0xFF) << 16 | (this.intArray[1] & 0xFF) << 8 | this.intArray[0] & 0xFF;
        return n2;
    }

    protected int parseIntFromArray(byte[] byArray, int n2, boolean bl) throws IOException {
        int n3 = bl ? (byArray[n2 + 0] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF : (byArray[n2 + 3] & 0xFF) << 24 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2 + 0] & 0xFF;
        return n3;
    }

    protected short readShort(PullSourceStream pullSourceStream, boolean bl) throws IOException {
        this.readBytes(pullSourceStream, this.shortArray, 2);
        int n2 = bl ? (this.shortArray[0] & 0xFF) << 8 | this.shortArray[1] & 0xFF : (this.shortArray[1] & 0xFF) << 8 | this.shortArray[0] & 0xFF;
        return (short)n2;
    }

    public static final short parseShortFromArray(byte[] byArray, boolean bl) throws IOException {
        if (byArray.length < 2) {
            throw new IOException("Unexpected EOF");
        }
        int n2 = bl ? (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF : (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        return (short)n2;
    }

    protected String readString(PullSourceStream pullSourceStream) throws IOException {
        this.readBytes(pullSourceStream, this.intArray, 4);
        return new String(this.intArray);
    }

    public void skip(PullSourceStream pullSourceStream, int n2) throws IOException {
        int n3;
        if (pullSourceStream instanceof Seekable && ((Seekable)((Object)pullSourceStream)).isRandomAccess()) {
            long l2 = ((Seekable)((Object)pullSourceStream)).tell();
            long l3 = l2 + (long)n2;
            ((Seekable)((Object)pullSourceStream)).seek(l3);
            if (l3 != ((Seekable)((Object)pullSourceStream)).tell()) {
                throw new IOException("Seek to " + l3 + " failed");
            }
            Object object = this.sync;
            synchronized (object) {
                this.currentLocation += (long)n2;
            }
            return;
        }
        int n4 = n2;
        while (n4 > 2048) {
            n3 = this.readBytes(pullSourceStream, this.tempBuffer, 2048);
            if (n3 != 2048) {
                throw new IOException("BasicPullParser: End of Media reached while trying to skip " + n2);
            }
            n4 -= 2048;
        }
        if (n4 > 0 && (n3 = this.readBytes(pullSourceStream, this.tempBuffer, n4)) != n4) {
            throw new IOException("BasicPullParser: End of Media reached while trying to skip " + n2);
        }
        Object object = this.sync;
        synchronized (object) {
            this.currentLocation += (long)n2;
        }
    }

    public final long getLocation(PullSourceStream pullSourceStream) {
        Object object = this.sync;
        synchronized (object) {
            if (pullSourceStream instanceof Seekable) {
                long l2 = ((Seekable)((Object)pullSourceStream)).tell();
                return l2;
            }
            long l3 = this.currentLocation;
            return l3;
        }
    }

    public abstract ContentDescriptor[] getSupportedInputContentDescriptors();

    public void open() {
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
    }

    public void start() throws IOException {
        if (this.source != null) {
            this.source.start();
        }
    }

    public void stop() {
        if (this.source != null) {
            try {
                this.source.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void reset() {
    }

    public abstract Time getDuration();

    public abstract Time getMediaTime();

    public abstract Time setPosition(Time var1, int var2);

    public abstract Track[] getTracks() throws IOException, BadHeaderException;
}

