/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser;

import com.sun.media.parser.RawParser;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.SourceStream;

public class RawPullStreamParser
extends RawParser {
    protected SourceStream[] streams;
    protected Track[] tracks = null;
    static final String NAME = "Raw pull stream parser";

    public String getName() {
        return NAME;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        this.streams = ((PullDataSource)dataSource).getStreams();
        if (this.streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (this.streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(this.streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        this.source = dataSource;
        this.streams = this.streams;
    }

    protected boolean supports(SourceStream[] sourceStreamArray) {
        return sourceStreamArray[0] != null && sourceStreamArray[0] instanceof PullSourceStream;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        int n2 = 0;
        while (n2 < this.streams.length) {
            this.tracks[n2] = new FrameTrack(this, (PullSourceStream)this.streams[n2]);
            ++n2;
        }
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
    }

    public void start() throws IOException {
        this.source.start();
    }

    public void stop() {
        try {
            this.source.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class FrameTrack
    implements Track {
        Demultiplexer parser;
        PullSourceStream pss;
        boolean enabled = true;
        Format format = null;
        TrackListener listener;
        Integer stateReq = new Integer(0);

        public FrameTrack(Demultiplexer demultiplexer, PullSourceStream pullSourceStream) {
            this.pss = pullSourceStream;
        }

        public Format getFormat() {
            return this.format;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time getDuration() {
            return this.parser.getDuration();
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public void setTrackListener(TrackListener trackListener) {
            this.listener = trackListener;
        }

        public void readFrame(Buffer buffer) {
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null) {
                byArray = new byte[500];
                buffer.setData(byArray);
            }
            try {
                int n2 = this.pss.read(byArray, 0, byArray.length);
                buffer.setLength(n2);
            }
            catch (IOException iOException) {
                buffer.setDiscard(true);
            }
        }

        public int mapTimeToFrame(Time time) {
            return -1;
        }

        public Time mapFrameToTime(int n2) {
            return new Time(0L);
        }
    }
}

