/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.v4l;

import com.sun.media.protocol.v4l.V4LSourceStream;
import java.io.IOException;
import javax.media.CaptureDeviceInfo;
import javax.media.Duration;
import javax.media.Time;
import javax.media.control.FormatControl;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;

public class DataSource
extends PushBufferDataSource
implements CaptureDevice {
    protected Object[] controls = new Object[0];
    protected boolean started = false;
    protected String contentType = "raw";
    protected boolean connected = false;
    protected Time duration = Duration.DURATION_UNBOUNDED;
    protected V4LSourceStream[] streams = null;
    protected V4LSourceStream stream = null;

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.streams = new V4LSourceStream[1];
        try {
            this.stream = new V4LSourceStream(this.getLocator());
            this.controls = this.stream.getControls();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        catch (Error error) {
            throw new IOException(error.toString());
        }
        this.streams[0] = this.stream;
        this.connected = true;
    }

    public String getContentType() {
        if (!this.connected) {
            throw new Error("DataSource not connected yet!");
        }
        return this.contentType;
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        return this.stream.getCaptureDeviceInfo();
    }

    public FormatControl[] getFormatControls() {
        return this.stream.getFormatControls();
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        V4LSourceStream v4LSourceStream = this.stream;
        synchronized (v4LSourceStream) {
            try {
                if (this.started) {
                    this.stop();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stream.close();
            this.connected = false;
        }
    }

    public void start() throws IOException {
        if (!this.connected) {
            throw new Error("DataSource must be connected before it can be started");
        }
        V4LSourceStream v4LSourceStream = this.stream;
        synchronized (v4LSourceStream) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.stream.start(true);
        }
    }

    public void stop() throws IOException {
        V4LSourceStream v4LSourceStream = this.stream;
        synchronized (v4LSourceStream) {
            if (!this.connected || !this.started) {
                return;
            }
            this.started = false;
            this.stream.start(false);
        }
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Object getControl(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object[] objectArray = this.getControls();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (clazz.isInstance(objectArray[n2])) {
                    return objectArray[n2];
                }
                ++n2;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Time getDuration() {
        return this.duration;
    }

    public PushBufferStream[] getStreams() {
        return this.streams;
    }
}

