/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.v4l;

import com.sun.media.protocol.v4l.V4LCapture;
import com.sun.media.protocol.v4l.VCapability;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.VideoFormat;

public class V4LDeviceQuery
extends CaptureDeviceInfo {
    private transient V4LCapture capture;
    private transient Vector vecFormats = new Vector();
    private transient byte[] buffer = new byte[0x1B0000];
    protected transient Dimension[] sizes = new Dimension[]{new Dimension(160, 120), new Dimension(320, 240), new Dimension(640, 480), new Dimension(176, 144), new Dimension(352, 288), new Dimension(768, 576)};

    private void addFormat(Format format) {
        Enumeration enumeration = this.vecFormats.elements();
        while (enumeration.hasMoreElements()) {
            Format format2 = (Format)enumeration.nextElement();
            if (!format2.equals(format)) continue;
            return;
        }
        this.vecFormats.addElement(format);
    }

    private void tryFormat(V4LCapture v4LCapture, int n2, int n3, int n4) {
        System.err.println("Trying " + n2 + " " + n3 + " " + n4);
        if (v4LCapture.setFormat(v4LCapture.paletteToDepth(n2), n2, n3, n4, 30.0f) < 0) {
            return;
        }
        if (v4LCapture.start() < 0) {
            return;
        }
        int n5 = 0;
        while (n5 < 5) {
            if (v4LCapture.readNextFrame(this.buffer, 0, this.buffer.length) >= 0) {
                VideoFormat videoFormat = v4LCapture.paletteToFormat(n2, new Dimension(n3, n4));
                System.err.println("Format is " + videoFormat);
                if (videoFormat != null) {
                    this.addFormat(videoFormat);
                }
                v4LCapture.stop();
                return;
            }
            ++n5;
        }
        v4LCapture.stop();
    }

    public V4LDeviceQuery(int n2) {
        VCapability vCapability = new VCapability();
        this.capture = new V4LCapture(n2);
        this.capture.getCapability(vCapability);
        this.name = "v4l:" + vCapability.name + ":" + n2;
        System.err.println("Name = " + this.name);
        this.tryFormat(this.capture, 4, 320, 240);
        int n3 = 3;
        while (n3 < 16) {
            int n4 = 0;
            while (n4 < this.sizes.length) {
                this.tryFormat(this.capture, n3, this.sizes[n4].width, this.sizes[n4].height);
                ++n4;
            }
            ++n3;
        }
        this.formats = new Format[this.vecFormats.size()];
        Enumeration enumeration = this.vecFormats.elements();
        int n5 = 0;
        while (enumeration.hasMoreElements()) {
            Format format = (Format)enumeration.nextElement();
            this.formats[n5++] = format;
        }
        this.locator = new MediaLocator("v4l://" + n2);
    }
}

